/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.material.AllowedMaterial;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class ModuleStats
implements ModuleProperty {
    public static String KEY = "module_stats";
    public static ModuleStats property;

    public ModuleStats() {
        property = this;
        ModularItemCache.setSupplier(KEY, ModuleStats::createCache);
        StatResolver.registerResolver("module", new StatResolver.Resolver(){

            @Override
            public double resolveDouble(String data, ItemModule.ModuleInstance instance) {
                if (instance.module.equals(ItemModule.internal)) {
                    return 1.0;
                }
                if ("cost".equals(data)) {
                    return AllowedMaterial.getMaterialCost(instance);
                }
                return ModuleStats.getStats(instance).getOrDefault(data, 0).intValue();
            }

            @Override
            public String resolveString(String data, ItemModule.ModuleInstance instance) {
                return null;
            }
        });
    }

    public static Map<String, Integer> getStats(ItemStack itemStack) {
        return ModularItemCache.get(itemStack, KEY, new HashMap());
    }

    public static Map<String, Integer> getStats(ItemModule.ModuleInstance moduleInstance) {
        JsonElement element = property.getJsonElement(moduleInstance);
        if (element != null) {
            return ModuleStats.getStats(element);
        }
        return new HashMap<String, Integer>();
    }

    private static Map<String, Integer> createCache(ItemStack itemStack) {
        JsonElement element = property.getJsonElement(itemStack);
        if (element != null) {
            return ModuleStats.getStats(element);
        }
        return new HashMap<String, Integer>();
    }

    public static Map<String, Integer> getStats(JsonElement element) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (element != null && element.isJsonObject()) {
            JsonObject jsonObject = element.getAsJsonObject();
            Set entrySet = jsonObject.entrySet();
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                JsonElement valueElement = (JsonElement)entry.getValue();
                if (valueElement.isJsonPrimitive() && ((JsonPrimitive)valueElement).isNumber()) {
                    int value = valueElement.getAsInt();
                    map.put(key, value);
                    continue;
                }
                throw new JsonParseException("Value for key '" + key + "' is not an integer.");
            }
        }
        return map;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        ModuleStats.getStats(data);
        return true;
    }
}

