/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class NemesisProperty
extends DoubleProperty
implements CraftingProperty {
    public static String KEY = "nemesis";
    public static NemesisProperty property;
    public DecimalFormat modifierFormat = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("##.#"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public NemesisProperty() {
        super(KEY);
        this.setupLore();
        property = this;
        EntityEvent.LIVING_DEATH.register((livingEntity, damageSource) -> {
            ItemStack weapon = MiapiEvents.LivingHurtEvent.getCausingItemStack(damageSource);
            if (weapon.m_41720_() instanceof ModularItem && !livingEntity.m_9236_().m_5776_()) {
                Double nemesisScale = this.getValue(weapon);
                CompoundTag compound = weapon.m_41784_();
                if (nemesisScale != null && nemesisScale > 0.0) {
                    String entityType = compound.m_128461_("miapi_nemesis_target");
                    int value = compound.m_128451_("miapi_nemesis");
                    EntityType attackedType = livingEntity.m_6095_();
                    Optional entityType1 = EntityType.m_20632_((String)entityType);
                    if (entityType1.isPresent()) {
                        EntityType targetType = (EntityType)entityType1.get();
                        if (attackedType.equals(targetType)) {
                            compound.m_128405_("miapi_nemesis", value + 1);
                        } else if ((value -= 5) < 0) {
                            compound.m_128473_("miapi_nemesis_target");
                            compound.m_128405_("miapi_nemesis", 0);
                        } else {
                            compound.m_128405_("miapi_nemesis", value);
                        }
                    } else {
                        compound.m_128359_("miapi_nemesis_target", EntityType.m_20613_((EntityType)attackedType).toString());
                        compound.m_128405_("miapi_nemesis", 1);
                    }
                }
                weapon.m_41751_(compound);
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(listener -> {
            ItemStack weapon = listener.getCausingItemStack();
            if (weapon.m_41720_() instanceof ModularItem) {
                Double nemesisScale = this.getValue(weapon);
                CompoundTag compound = weapon.m_41784_();
                if (nemesisScale != null && nemesisScale > 0.0) {
                    String entityType = compound.m_128461_("miapi_nemesis_target");
                    int value = compound.m_128451_("miapi_nemesis");
                    EntityType attackedType = listener.livingEntity.m_6095_();
                    Optional entityType1 = EntityType.m_20632_((String)entityType);
                    if (entityType1.isPresent()) {
                        EntityType targetType = (EntityType)entityType1.get();
                        if (attackedType.equals(targetType)) {
                            double factor = NemesisProperty.scale(value, nemesisScale);
                            listener.amount += (float)factor * listener.amount;
                        } else {
                            double factor = NemesisProperty.scale(value, nemesisScale);
                            factor = Math.min(0.95, factor);
                            listener.amount -= (float)factor * listener.amount;
                        }
                    }
                }
                weapon.m_41751_(compound);
            }
            return EventResult.pass();
        });
    }

    public void setupLore() {
        LoreProperty.loreSuppliers.add((weapon, world, tooltip, context) -> {
            Double nemesisScale = this.getValue(weapon);
            CompoundTag compound = weapon.m_41784_();
            if (nemesisScale != null && nemesisScale > 0.0) {
                String entityType = compound.m_128461_("miapi_nemesis_target");
                int value = compound.m_128451_("miapi_nemesis");
                double factor = NemesisProperty.scale(value, nemesisScale) * 100.0f - 1.0f;
                Optional entityType1 = EntityType.m_20632_((String)entityType);
                MutableComponent entity = Component.m_237115_((String)"miapi.lore.nemesis.no_entity");
                if (entityType1.isPresent()) {
                    entity = ((EntityType)entityType1.get()).m_20676_();
                }
                MutableComponent blueNumber = Component.m_237113_((String)(this.modifierFormat.format(factor) + "%")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLUE));
                MutableComponent redNumber = Component.m_237113_((String)(this.modifierFormat.format(factor / 2.0) + "%")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
                MutableComponent whiteNumber = Component.m_237113_((String)String.valueOf(value)).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE));
                entity = Component.m_237113_((String)entity.getString()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));
                tooltip.add(Component.m_237110_((String)"miapi.lore.nemesis.0", (Object[])new Object[]{whiteNumber, entity}));
                if (factor != 0.0) {
                    tooltip.add(Component.m_237110_((String)"miapi.lore.nemesis.1", (Object[])new Object[]{blueNumber, Component.m_237113_((String)entity.getString()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLUE))}));
                    tooltip.add(Component.m_237110_((String)"miapi.lore.nemesis.2", (Object[])new Object[]{redNumber, Component.m_237113_((String)entity.getString()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED))}));
                }
            }
        });
    }

    public static float scale(int rawValue, double scale) {
        double factor = (Math.log(Math.pow(rawValue + 1, 5.0)) + 1.0) * scale;
        if (rawValue < 0) {
            factor = 0.0;
        }
        return (float)factor / 100.0f;
    }

    @Override
    public Double getValue(ItemStack stack) {
        return this.getValueRaw(stack);
    }

    @Override
    public double getValueSafe(ItemStack stack) {
        return this.getValueSafeRaw(stack);
    }

    @Override
    public ItemStack preview(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<String, String> data) {
        crafting.m_41749_("miapi_nemesis");
        return crafting;
    }
}

