/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.items.ModularCrossbow;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.MagazineCrossbowShotDelay;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class RapidfireCrossbowProperty
extends DoubleProperty {
    public static String KEY = "rapid_fire_crossbow";
    public static String NBTKEY = "miapi" + KEY;
    public static RapidfireCrossbowProperty property;

    public RapidfireCrossbowProperty() {
        super(KEY);
        property = this;
        MiapiProjectileEvents.MODULAR_CROSSBOW_LOAD_AFTER.register(context -> {
            int shotCount = RapidfireCrossbowProperty.getShotCount(context.crossbow);
            ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>(RapidfireCrossbowProperty.getSavedProjectilesOnCrossbow(context.crossbow));
            for (int i = projectiles.size(); i < shotCount; ++i) {
                Player player2;
                LivingEntity patt1598$temp;
                ItemStack otherAmmo = context.player.m_6298_(context.crossbow);
                Player player = null;
                if (!otherAmmo.m_41619_() && (patt1598$temp = context.player) instanceof Player && !(player2 = (Player)patt1598$temp).m_7500_()) {
                    player = player2;
                } else {
                    otherAmmo = otherAmmo.m_41777_();
                }
                otherAmmo = otherAmmo.m_41620_(1);
                if (otherAmmo.m_41619_()) continue;
                if (otherAmmo.m_41763_()) {
                    otherAmmo.m_41622_(1, context.player, livingEntity -> {});
                }
                projectiles.add(otherAmmo.m_41777_());
                if (player == null) continue;
                player.m_150109_().m_36057_(otherAmmo);
            }
            RapidfireCrossbowProperty.writeProjectileListToCrossbow(context.crossbow, projectiles);
            return EventResult.pass();
        });
        MiapiProjectileEvents.MODULAR_CROSSBOW_POST_SHOT.register((player, crossbow) -> {
            List<ItemStack> projectiles;
            if (crossbow.m_41720_() instanceof ModularCrossbow && !(projectiles = RapidfireCrossbowProperty.getSavedProjectilesOnCrossbow(crossbow)).isEmpty()) {
                ItemStack itemStack = projectiles.remove(0);
                ModularCrossbow.putProjectile(crossbow, itemStack);
                if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)crossbow) > 0) {
                    ModularCrossbow.putProjectile(crossbow, itemStack.m_41777_());
                    ModularCrossbow.putProjectile(crossbow, itemStack.m_41777_());
                }
                RapidfireCrossbowProperty.writeProjectileListToCrossbow(crossbow, projectiles);
                ModularCrossbow.m_40884_((ItemStack)crossbow, (boolean)true);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                    serverPlayerEntity.m_36335_().m_41524_(crossbow.m_41720_(), (int)MagazineCrossbowShotDelay.property.getValueSafe(crossbow));
                }
            }
            return EventResult.pass();
        });
        LoreProperty.loreSuppliers.add((stack, world, tooltip, context) -> {
            if (stack.m_41720_() instanceof ModularItem) {
                List<ItemStack> projectiles = RapidfireCrossbowProperty.getSavedProjectilesOnCrossbow(stack);
                for (ItemStack projectile : projectiles) {
                    tooltip.add(Component.m_237110_((String)"miapi.crossbow.ammo.addition", (Object[])new Object[]{projectile.m_41786_()}));
                }
            }
        });
    }

    public static void writeProjectileListToCrossbow(ItemStack crossbow, List<ItemStack> projectiles) {
        ListTag list = new ListTag();
        for (ItemStack itemStack : projectiles) {
            list.add((Object)itemStack.m_41739_(new CompoundTag()));
        }
        crossbow.m_41784_().m_128365_(NBTKEY, (Tag)list);
    }

    public static List<ItemStack> getSavedProjectilesOnCrossbow(ItemStack crossbow) {
        Tag tag;
        ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
        if (crossbow.m_41782_() && (tag = crossbow.m_41784_().m_128423_(NBTKEY)) instanceof ListTag) {
            ListTag list = (ListTag)tag;
            for (int i = 0; i < list.size(); ++i) {
                projectiles.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)list.get(i))));
            }
        }
        return projectiles;
    }

    public static int getShotCount(ItemStack itemStack) {
        return (int)property.getValueSafeRaw(itemStack);
    }

    @Override
    public Double getValue(ItemStack stack) {
        Double value = this.getValueRaw(stack);
        if (value != null) {
            return (double)value.intValue() + 1.0;
        }
        return null;
    }

    @Override
    public double getValueSafe(ItemStack stack) {
        return (int)this.getValueSafeRaw(stack) + 1;
    }
}

