/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.mining.MiningShapeProperty;
import smartin.miapi.modules.properties.mining.condition.MiningCondition;
import smartin.miapi.modules.properties.mining.mode.MiningMode;
import smartin.miapi.modules.properties.mining.modifier.MiningModifier;
import smartin.miapi.modules.properties.mining.shape.MiningShape;

public class MiningShapeJson {
    public MiningCondition miningCondition;
    public boolean sameBlock;
    public MiningMode miningMode;
    public MiningShape miningShape;
    public List<MiningModifier> modifiers = new ArrayList<MiningModifier>();

    public MiningShapeJson(JsonObject element, ItemModule.ModuleInstance moduleInstance) {
        JsonObject conditionJson = element.get("condition").getAsJsonObject();
        MiningCondition condition = MiningShapeProperty.miningConditionMap.get(conditionJson.get("type").getAsString());
        if (condition == null) {
            throw new IllegalArgumentException("Mining Condition " + conditionJson.get("type") + " doesn't exist");
        }
        this.miningCondition = condition.fromJson(conditionJson, moduleInstance);
        JsonObject shapeJson = element.get("shape").getAsJsonObject();
        MiningShape shape = MiningShapeProperty.miningShapeMap.get(shapeJson.get("type").getAsString());
        if (shape == null) {
            throw new IllegalArgumentException("Mining Shape " + shapeJson.get("type") + " doesn't exist");
        }
        this.miningShape = shape.fromJson(shapeJson, moduleInstance);
        this.sameBlock = MiningShapeProperty.getBoolean(element, "sameBlock", true);
        JsonObject modeJson = element.get("collapseMode").getAsJsonObject();
        MiningMode mode = MiningShapeProperty.miningModeMap.get(modeJson.get("type").getAsString());
        if (mode == null) {
            throw new IllegalArgumentException("Mining Mode " + modeJson.get("type") + " doesn't exist");
        }
        this.miningMode = mode.fromJson(modeJson, moduleInstance);
        if (element.has("modifiers")) {
            element.get("modifiers").getAsJsonObject().asMap().forEach((id, jsonElement) -> {
                MiningModifier modifier = MiningShapeProperty.miningModifierMap.get(id);
                if (modifier != null) {
                    this.modifiers.add(modifier.fromJson((JsonElement)jsonElement, moduleInstance));
                } else {
                    Miapi.LOGGER.info("Modifier " + id + " was not found and could not be resolved");
                }
            });
        }
    }

    public void execute(BlockPos pos, Level level, ItemStack stack, ServerPlayer player, Direction facing) {
        List<BlockPos> posList = this.miningCondition.trimList(level, pos, this.miningShape.getMiningBlocks(level, pos, facing));
        for (MiningModifier modifier : this.modifiers) {
            posList = modifier.adjustMiningBlock(level, pos, (Player)player, stack, posList);
        }
        this.miningMode.execute(posList, level, player, pos, stack);
    }
}

