/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.mining.condition.MiningCondition;

public class BlockTagCondition
implements MiningCondition {
    public List<TagKey<Block>> blockTags;

    public BlockTagCondition(List<TagKey<Block>> blockTags) {
        this.blockTags = blockTags;
    }

    @Override
    public MiningCondition fromJson(JsonObject object, ItemModule.ModuleInstance moduleInstance) {
        JsonElement element = object.get("tags");
        ArrayList<TagKey<Block>> tags = new ArrayList<TagKey<Block>>();
        if (element != null && element.isJsonArray()) {
            element.getAsJsonArray().forEach(entry -> tags.add(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(entry.getAsString()))));
        }
        return new BlockTagCondition(tags);
    }

    @Override
    public List<BlockPos> trimList(Level level, BlockPos original, List<BlockPos> positions) {
        return positions.stream().filter(pos -> this.isInAny(level, (BlockPos)pos)).toList();
    }

    public boolean isInAny(Level world, BlockPos pos) {
        for (TagKey<Block> tag : this.blockTags) {
            if (!world.m_8055_(pos).m_204336_(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canMine(Player player, Level level, ItemStack miningStack, BlockPos pos, Direction face) {
        return this.isInAny(level, pos);
    }
}

