/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining.shape;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.mining.MiningShapeProperty;
import smartin.miapi.modules.properties.mining.shape.MiningShape;

public class CubeMiningShape
implements MiningShape {
    int width;
    int height;
    int depth;

    @Override
    public MiningShape fromJson(JsonObject object, ItemModule.ModuleInstance moduleInstance) {
        int radius = MiningShapeProperty.getInteger(object, "radius", 1);
        CubeMiningShape cube = new CubeMiningShape();
        cube.width = MiningShapeProperty.getInteger(object, "width", moduleInstance, radius);
        cube.height = MiningShapeProperty.getInteger(object, "height", moduleInstance, radius);
        cube.depth = MiningShapeProperty.getInteger(object, "depth", moduleInstance, radius);
        return cube;
    }

    @Override
    public List<BlockPos> getMiningBlocks(Level world, BlockPos pos, Direction face) {
        ArrayList<Direction.Axis> axisList = new ArrayList<Direction.Axis>(List.of(Direction.Axis.values()));
        axisList.remove(face.m_122434_());
        Direction.Axis widthDirection = (Direction.Axis)axisList.remove(0);
        Direction.Axis heightDirection = (Direction.Axis)axisList.remove(0);
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(this.depth * this.height * this.width);
        for (int x = 0; x < this.depth; ++x) {
            for (int y = 1; y <= this.width; ++y) {
                for (int z = 1; z <= this.height; ++z) {
                    BlockPos.MutableBlockPos pos1 = pos.m_122032_();
                    pos1 = pos1.m_121955_(face.m_122436_().m_142393_(-x));
                    pos1 = pos1.m_5487_(widthDirection, CubeMiningShape.intHalfInverse(y));
                    pos1 = pos1.m_5487_(heightDirection, CubeMiningShape.intHalfInverse(z));
                    list.add((BlockPos)pos1);
                }
            }
        }
        return list;
    }

    public static int intHalfInverse(int i) {
        if (i % 2 == 0) {
            return i / 2 * -1;
        }
        return i / 2;
    }
}

