/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining.shape;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.mining.MiningShapeProperty;
import smartin.miapi.modules.properties.mining.shape.MiningShape;

public class VeinMiningShape
implements MiningShape {
    public int size = 5;
    public int maxBlocks = 15;

    @Override
    public MiningShape fromJson(JsonObject object, ItemModule.ModuleInstance moduleInstance) {
        VeinMiningShape veinMiningShape = new VeinMiningShape();
        veinMiningShape.size = MiningShapeProperty.getInteger(object, "size", moduleInstance, 5);
        veinMiningShape.maxBlocks = MiningShapeProperty.getInteger(object, "max", moduleInstance, 5);
        return veinMiningShape;
    }

    @Override
    public List<BlockPos> getMiningBlocks(Level world, BlockPos pos, Direction face) {
        ArrayList<BlockPos> miningBlocks = new ArrayList<BlockPos>();
        if (this.maxBlocks < 1) {
            return miningBlocks;
        }
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        ArrayList<BlockPos> visited = new ArrayList<BlockPos>();
        queue.add(pos);
        visited.add(pos);
        BlockState centerState = world.m_8055_(pos);
        while (!queue.isEmpty() && miningBlocks.size() < this.size * this.size * this.size && miningBlocks.size() < this.maxBlocks) {
            BlockPos currentPos = (BlockPos)queue.poll();
            miningBlocks.add(currentPos);
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = currentPos.m_121945_(direction);
                int dx1 = neighborPos.m_123341_() - pos.m_123341_() + this.size;
                int dy1 = neighborPos.m_123342_() - pos.m_123342_() + this.size;
                int dz1 = neighborPos.m_123343_() - pos.m_123343_() + this.size;
                if (Math.abs(dx1 - this.size) > this.size || Math.abs(dy1 - this.size) > this.size || Math.abs(dz1 - this.size) > this.size || visited.contains(neighborPos)) continue;
                visited.add(neighborPos);
                BlockState neighborState = world.m_8055_(neighborPos);
                if (!neighborState.m_60734_().equals(centerState.m_60734_())) continue;
                queue.add(neighborPos);
            }
        }
        return miningBlocks;
    }
}

