/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.potion;

import dev.architectury.event.EventResult;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.potion.PotionEffectProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class OnDamagedEffects
extends PotionEffectProperty {
    public static String KEY = "on_hurt_potion";
    public OnDamagedEffects property = this;

    public OnDamagedEffects() {
        super(KEY);
        MiapiEvents.LIVING_HURT.register(listener -> {
            if (!listener.livingEntity.m_9236_().m_5776_()) {
                this.applyEffects(listener.livingEntity, listener.livingEntity, listener.getCausingItemStack(), listener.livingEntity, this::isTargetSelf);
                Entity patt1207$temp = listener.damageSource.m_7639_();
                if (patt1207$temp instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)patt1207$temp;
                    this.applyEffects(attacker, listener.livingEntity, listener.getCausingItemStack(), attacker, this::isTargetOther);
                }
            }
            return EventResult.pass();
        });
        this.setupLore();
    }

    public void setupLore() {
        LoreProperty.loreSuppliers.add((itemStack, world, tooltip, context) -> {
            ArrayList<Object> lines = new ArrayList<Object>();
            for (PotionEffectProperty.EffectHolder effectHolder : this.merge(this.getStatusEffects(itemStack))) {
                if (!effectHolder.isGuiVisibility()) continue;
                Component text = effectHolder.getPotionDescription();
                if (this.isTargetSelf(effectHolder)) {
                    lines.add(Component.m_237110_((String)"miapi.potion.damaged.self.tooltip", (Object[])new Object[]{text, effectHolder.getDurationSeconds(), effectHolder.getAmplifier()}));
                    continue;
                }
                lines.add(Component.m_237110_((String)"miapi.potion.damaged.other.tooltip", (Object[])new Object[]{text, effectHolder.getDurationSeconds(), effectHolder.getAmplifier()}));
            }
            if (!lines.isEmpty()) {
                lines.add(0, (Component)Component.m_237115_((String)"miapi.potion.damaged.on_hit").m_178405_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)).get(0));
                lines.add(0, Component.m_237119_());
            }
            tooltip.addAll(lines);
        });
    }

    public boolean isTargetOther(PotionEffectProperty.EffectHolder holder, EquipmentSlot slot) {
        return this.isTargetOther(holder);
    }

    public boolean isTargetOther(PotionEffectProperty.EffectHolder holder) {
        return !ModuleProperty.getBoolean(holder.rawData(), "target_self", holder.moduleInstance(), false);
    }

    public boolean isTargetSelf(PotionEffectProperty.EffectHolder holder, EquipmentSlot slot) {
        return !this.isTargetOther(holder);
    }

    public boolean isTargetSelf(PotionEffectProperty.EffectHolder holder) {
        return !this.isTargetOther(holder);
    }
}

