/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.item.modular.TransformMap;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.modules.properties.render.ModelProperty;
import smartin.miapi.modules.properties.render.RenderProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

@OnlyIn(value=Dist.CLIENT)
public class ModelMergeProperty
implements RenderProperty {
    public static final String KEY = "modelMerge";
    public static ModuleProperty property;

    public ModelMergeProperty() {
        property = this;
        ModelProperty.modelTransformers.add(new ModelProperty.ModelTransformer(){

            @Override
            public List<ModelProperty.TransformedUnbakedModel> unBakedTransform(List<ModelProperty.TransformedUnbakedModel> list, ItemStack stack) {
                ItemModule.ModuleInstance root = ItemModule.getModules(stack);
                ArrayList toMerge = new ArrayList();
                root.allSubModules().forEach(moduleInstance -> {
                    JsonElement data = moduleInstance.getProperties().get(property);
                    if (data != null) {
                        Type type = new TypeToken<List<Json>>(){}.getType();
                        List jsonDatas = (List)Miapi.gson.fromJson(data, type);
                        jsonDatas.forEach(jsonData -> {
                            TransformMap transformMap = SlotProperty.getTransformStack(SlotProperty.getSlotIn(moduleInstance));
                            if (jsonData.transform == null) {
                                jsonData.transform = Transform.IDENTITY;
                            } else {
                                jsonData.transform.origin = null;
                            }
                            Transform from = transformMap.get(jsonData.from).copy();
                            jsonData.transform = from = from.merge(jsonData.transform);
                            toMerge.add(jsonData);
                        });
                    }
                });
                ArrayList<ModelProperty.TransformedUnbakedModel> newList = new ArrayList<ModelProperty.TransformedUnbakedModel>(list);
                list.forEach(unbakedModel -> toMerge.forEach(json -> {
                    if (json.from.equals(unbakedModel.transform().primary)) {
                        TransformMap stack1 = unbakedModel.transform().copy();
                        stack1 = new TransformMap();
                        stack1.add(json.to, unbakedModel.transform().get());
                        stack1.add(json.to, stack1.get());
                        stack1.primary = json.to;
                        ModelProperty.TransformedUnbakedModel transformedUnbakedModel1 = new ModelProperty.TransformedUnbakedModel(stack1, unbakedModel.unbakedModel(), unbakedModel.instance(), unbakedModel.color());
                        newList.add(transformedUnbakedModel1);
                    }
                }));
                return newList;
            }
        });
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }

    static class Json {
        public String from;
        public String to;
        public Transform transform;

        Json() {
        }
    }
}

