/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.render.RenderProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

@OnlyIn(value=Dist.CLIENT)
public class ModelTransformationProperty
implements RenderProperty {
    public static final String KEY = "modelTransform";
    public static ModuleProperty property;

    public ModelTransformationProperty() {
        property = this;
        ModularItemCache.setSupplier(KEY, ModelTransformationProperty::getTransformation);
        MiapiItemModel.modelTransformers.add((matrices, itemStack, mode, modelType, tickDelta) -> {
            ModelTransformationProperty.applyTransformation(itemStack, mode, matrices);
            return matrices;
        });
    }

    public static void applyTransformation(ItemStack stack, ItemDisplayContext mode, PoseStack matrices) {
        ItemTransform transformation = ModularItemCache.getVisualOnlyCache(stack, KEY, ItemTransforms.f_111786_).m_269404_(mode);
        boolean leftHanded = ModelTransformationProperty.isLeftHanded(mode);
        matrices.m_252880_(0.5f, 0.5f, 0.5f);
        if (transformation != null) {
            transformation.m_111763_(false, matrices);
        }
        matrices.m_252880_(-0.5f, -0.5f, -0.5f);
    }

    public static ItemTransforms getTransformation(ItemStack stack) {
        ItemTransforms transformation = ItemTransforms.f_111786_;
        for (ItemModule.ModuleInstance instance : ItemModule.createFlatList(ItemModule.getModules(stack))) {
            Transform merged;
            Transform transform;
            JsonObject replace;
            JsonElement element = instance.getProperties().get(property);
            if (element == null) continue;
            HashMap<ItemDisplayContext, ItemTransform> map = new HashMap<ItemDisplayContext, ItemTransform>();
            if (element.getAsJsonObject().has("replace")) {
                replace = element.getAsJsonObject().getAsJsonObject("replace");
                for (ItemDisplayContext mode : ItemDisplayContext.values()) {
                    map.put(mode, transformation.m_269404_(mode));
                    for (String modeString : ModelTransformationProperty.getStringOfMode(mode)) {
                        if (!replace.has(modeString)) continue;
                        transform = Transform.toModelTransformation((Transform)Miapi.gson.fromJson((JsonElement)replace.getAsJsonObject(modeString), Transform.class));
                        map.put(mode, transform.toTransformation());
                    }
                }
            }
            if (element.getAsJsonObject().has("display")) {
                replace = element.getAsJsonObject().getAsJsonObject("display");
                for (ItemDisplayContext mode : ItemDisplayContext.values()) {
                    map.put(mode, transformation.m_269404_(mode));
                    for (String modeString : ModelTransformationProperty.getStringOfMode(mode)) {
                        if (!replace.has(modeString)) continue;
                        transform = Transform.toModelTransformation((Transform)Miapi.gson.fromJson((JsonElement)replace.getAsJsonObject(modeString), Transform.class));
                        if (ModelTransformationProperty.isLeftHanded(mode)) {
                            transform = ModelTransformationProperty.makeLeft(transform);
                        }
                        map.put(mode, transform.toTransformation());
                    }
                }
            }
            if (element.getAsJsonObject().has("display-merge")) {
                replace = element.getAsJsonObject().getAsJsonObject("display-merge");
                for (ItemDisplayContext mode : ItemDisplayContext.values()) {
                    map.put(mode, transformation.m_269404_(mode));
                    for (String modeString : ModelTransformationProperty.getStringOfMode(mode)) {
                        if (!replace.has(modeString)) continue;
                        merged = Transform.merge(new Transform(transformation.m_269404_(mode)), (Transform)Miapi.gson.fromJson((JsonElement)replace.getAsJsonObject(modeString), Transform.class));
                        if (ModelTransformationProperty.isLeftHanded(mode)) {
                            merged = ModelTransformationProperty.makeLeft(merged);
                        }
                        map.put(mode, merged.toTransformation());
                    }
                }
            }
            if (element.getAsJsonObject().has("merge")) {
                replace = element.getAsJsonObject().getAsJsonObject("merge");
                for (ItemDisplayContext mode : ItemDisplayContext.values()) {
                    map.put(mode, transformation.m_269404_(mode));
                    for (String modeString : ModelTransformationProperty.getStringOfMode(mode)) {
                        if (!replace.has(modeString)) continue;
                        merged = Transform.merge(new Transform(transformation.m_269404_(mode)), (Transform)Miapi.gson.fromJson((JsonElement)replace.getAsJsonObject(modeString), Transform.class));
                        map.put(mode, merged.toTransformation());
                    }
                }
            }
            transformation = new ItemTransforms((ItemTransform)map.get(ItemDisplayContext.THIRD_PERSON_LEFT_HAND), (ItemTransform)map.get(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND), (ItemTransform)map.get(ItemDisplayContext.FIRST_PERSON_LEFT_HAND), (ItemTransform)map.get(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND), (ItemTransform)map.get(ItemDisplayContext.HEAD), (ItemTransform)map.get(ItemDisplayContext.GUI), (ItemTransform)map.get(ItemDisplayContext.GROUND), (ItemTransform)map.get(ItemDisplayContext.FIXED));
        }
        return transformation;
    }

    public static boolean isLeftHanded(ItemDisplayContext mode) {
        return switch (mode) {
            case ItemDisplayContext.THIRD_PERSON_LEFT_HAND, ItemDisplayContext.FIRST_PERSON_LEFT_HAND -> true;
            default -> false;
        };
    }

    public static Transform makeLeft(Transform transform) {
        transform = transform.copy();
        transform.translation.set((Vector3fc)new Vector3f(-transform.translation.x(), transform.translation.y(), transform.translation.z()));
        Matrix4f m = transform.toMatrix();
        m.rotate((float)Math.PI, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f));
        m.rotate((float)Math.PI, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        m.rotate((float)Math.PI, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f));
        Transform rotated = Transform.fromMatrix(m);
        rotated.origin = transform.origin;
        return rotated;
    }

    private static Set<String> getStringOfMode(ItemDisplayContext mode) {
        ArrayList<String> modes = new ArrayList<String>();
        modes.add(mode.toString());
        modes.add(mode.toString().replace("_", ""));
        modes.add(mode.toString().toLowerCase());
        modes.add(mode.toString().toLowerCase().replace("_", ""));
        switch (mode) {
            case GUI: {
                modes.add("gui");
                break;
            }
            case HEAD: {
                modes.add("head");
                break;
            }
            case FIXED: {
                modes.add("fixed");
                break;
            }
            case GROUND: {
                modes.add("ground");
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                modes.add("firstperson_lefthand");
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                modes.add("firstperson_righthand");
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                modes.add("thirdperson_lefthand");
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                modes.add("thirdperson_righthand");
            }
        }
        return Set.copyOf(modes);
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }
}

