/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render.colorproviders;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.redpxnda.nucleus.util.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;

public interface ColorProvider {
    public static final Map<String, ColorProvider> colorProviders = new HashMap<String, ColorProvider>();

    public static void setup() {
        colorProviders.put("material", new MaterialColorProvider());
        colorProviders.put("model", new ModelColorProvider());
        colorProviders.put("potion", new PotionColorProvider());
        colorProviders.put("parent", new ParentColorProvider());
    }

    public static ColorProvider getProvider(String type, ItemStack itemStack, ItemModule.ModuleInstance moduleInstance) {
        return colorProviders.getOrDefault(type, colorProviders.get("material")).getInstance(itemStack, moduleInstance);
    }

    default public Color getVertexColor() {
        return Color.WHITE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public VertexConsumer getConsumer(MultiBufferSource var1, TextureAtlasSprite var2, ItemStack var3, ItemModule.ModuleInstance var4, ItemDisplayContext var5);

    public ColorProvider getInstance(ItemStack var1, ItemModule.ModuleInstance var2);

    public static class MaterialColorProvider
    implements ColorProvider {
        public Material material;

        public MaterialColorProvider() {
        }

        public MaterialColorProvider(Material material) {
            this.material = material;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public VertexConsumer getConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite sprite, ItemStack stack, ItemModule.ModuleInstance moduleInstance, ItemDisplayContext mode) {
            return this.material.getRenderController().getVertexConsumer(vertexConsumers, sprite, stack, moduleInstance, mode);
        }

        @Override
        public ColorProvider getInstance(ItemStack stack, ItemModule.ModuleInstance instance) {
            Material material1 = MaterialProperty.getMaterial(instance);
            if (material1 != null) {
                return new MaterialColorProvider(material1);
            }
            return new ModelColorProvider();
        }
    }

    public static class ModelColorProvider
    implements ColorProvider {
        public ModelColorProvider() {
        }

        public ModelColorProvider(ItemStack stack) {
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public VertexConsumer getConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite sprite, ItemStack stack, ItemModule.ModuleInstance moduleInstance, ItemDisplayContext mode) {
            return vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109279_((ItemStack)stack, (boolean)true));
        }

        @Override
        public ColorProvider getInstance(ItemStack stack, ItemModule.ModuleInstance instance) {
            return new ModelColorProvider(stack);
        }
    }

    public static class PotionColorProvider
    implements ColorProvider {
        Color potioncolor;

        public PotionColorProvider() {
        }

        public PotionColorProvider(ItemStack stack) {
            this.potioncolor = new Color(PotionUtils.m_43575_((ItemStack)stack));
        }

        @Override
        public Color getVertexColor() {
            return this.potioncolor;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public VertexConsumer getConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite sprite, ItemStack stack, ItemModule.ModuleInstance moduleInstance, ItemDisplayContext mode) {
            return vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109279_((ItemStack)stack, (boolean)true));
        }

        @Override
        public ColorProvider getInstance(ItemStack stack, ItemModule.ModuleInstance instance) {
            return new PotionColorProvider(stack);
        }
    }

    public static class ParentColorProvider
    extends MaterialColorProvider {
        @Override
        public ColorProvider getInstance(ItemStack stack, ItemModule.ModuleInstance instance) {
            if (instance.parent != null) {
                return super.getInstance(stack, instance.parent);
            }
            return new ModelColorProvider(stack);
        }
    }
}

