/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public abstract class DoubleProperty
implements ModuleProperty {
    public ModuleProperty property = this;
    protected String privateKey;
    public double baseValue = 0.0;
    public boolean allowVisualOnly = false;

    protected DoubleProperty(String key) {
        this.privateKey = key;
        ModularItemCache.setSupplier(key, itemstack -> this.createValue(itemstack, this.property));
    }

    public boolean isModularItem(ItemStack itemStack) {
        if (this.allowVisualOnly) {
            return itemStack.m_41720_() instanceof VisualModularItem;
        }
        return itemStack.m_41720_() instanceof ModularItem;
    }

    public abstract Double getValue(ItemStack var1);

    public abstract double getValueSafe(ItemStack var1);

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        if (type == MergeType.SMART || type == MergeType.EXTEND) {
            ArrayList<JsonElement> jsonElements = new ArrayList<JsonElement>();
            this.addToList(jsonElements, old);
            this.addToList(jsonElements, toMerge);
            JsonArray jsonArray = new JsonArray();
            for (JsonElement element : jsonElements) {
                jsonArray.add(element);
            }
            return jsonArray;
        }
        if (type == MergeType.OVERWRITE) {
            return toMerge;
        }
        return old;
    }

    private void addToList(List<JsonElement> elements, JsonElement toAdd) {
        if (toAdd.isJsonArray()) {
            for (JsonElement element : toAdd.getAsJsonArray()) {
                elements.add(element);
            }
        } else {
            elements.add(toAdd);
        }
    }

    private Double createValue(ItemStack itemStack, ModuleProperty property) {
        double value = this.baseValue;
        boolean hasValue = false;
        ArrayList<Double> addition = new ArrayList<Double>();
        ArrayList<Double> multiplyBase = new ArrayList<Double>();
        ArrayList<Double> multiplyTotal = new ArrayList<Double>();
        if (!this.isModularItem(itemStack)) {
            return null;
        }
        for (ItemModule.ModuleInstance moduleInstance : ItemModule.getModules(itemStack).allSubModules()) {
            JsonElement element = moduleInstance.getProperties().get(property);
            if (element == null) continue;
            if (element.isJsonArray()) {
                for (JsonElement innerElement : element.getAsJsonArray()) {
                    hasValue = true;
                    Operation operation = new Operation(innerElement, moduleInstance);
                    switch (operation.attributeOperation) {
                        case ADDITION: {
                            addition.add(operation.solve());
                            break;
                        }
                        case MULTIPLY_BASE: {
                            multiplyBase.add(operation.solve());
                            break;
                        }
                        case MULTIPLY_TOTAL: {
                            multiplyTotal.add(operation.solve());
                        }
                    }
                }
                continue;
            }
            hasValue = true;
            Operation operation = new Operation(element, moduleInstance);
            switch (operation.attributeOperation) {
                case ADDITION: {
                    addition.add(operation.solve());
                    break;
                }
                case MULTIPLY_BASE: {
                    multiplyBase.add(operation.solve());
                    break;
                }
                case MULTIPLY_TOTAL: {
                    multiplyTotal.add(operation.solve());
                }
            }
        }
        for (Double currentValue : addition) {
            value += currentValue.doubleValue();
        }
        double multiplier = 1.0;
        for (Double currentValue : multiplyBase) {
            multiplier += currentValue.doubleValue();
        }
        value *= multiplier;
        for (Double currentValue : multiplyTotal) {
            value = currentValue * value;
        }
        if (hasValue) {
            if (Double.isNaN(value)) {
                return 0.0;
            }
            return value;
        }
        return null;
    }

    public Double getValueForModule(ItemModule.ModuleInstance moduleInstance, @Nullable Double fallback) {
        double value = 0.0;
        boolean hasValue = false;
        ArrayList<Double> addition = new ArrayList<Double>();
        ArrayList<Double> multiplyBase = new ArrayList<Double>();
        ArrayList<Double> multiplyTotal = new ArrayList<Double>();
        JsonElement element = moduleInstance.getProperties().get(this);
        if (element != null) {
            if (element.isJsonArray()) {
                for (JsonElement innerElement : element.getAsJsonArray()) {
                    hasValue = true;
                    Operation operation = new Operation(innerElement, moduleInstance);
                    switch (operation.attributeOperation) {
                        case ADDITION: {
                            addition.add(operation.solve());
                            break;
                        }
                        case MULTIPLY_BASE: {
                            multiplyBase.add(operation.solve());
                            break;
                        }
                        case MULTIPLY_TOTAL: {
                            multiplyTotal.add(operation.solve());
                        }
                    }
                }
            } else {
                hasValue = true;
                Operation operation = new Operation(element, moduleInstance);
                switch (operation.attributeOperation) {
                    case ADDITION: {
                        addition.add(operation.solve());
                        break;
                    }
                    case MULTIPLY_BASE: {
                        multiplyBase.add(operation.solve());
                        break;
                    }
                    case MULTIPLY_TOTAL: {
                        multiplyTotal.add(operation.solve());
                    }
                }
            }
        }
        for (Double currentValue : addition) {
            value += currentValue.doubleValue();
        }
        double multiplier = 1.0;
        for (Double currentValue : multiplyBase) {
            multiplier += currentValue.doubleValue();
        }
        value *= multiplier;
        for (Double currentValue : multiplyTotal) {
            value = currentValue * value;
        }
        if (hasValue) {
            return value;
        }
        return fallback;
    }

    public boolean hasValue(ItemStack itemStack) {
        return this.getValueRaw(itemStack) != null;
    }

    public double getForEntityNonHand(LivingEntity living) {
        ArrayList<ItemStack> itemsNotInSecondIterable = new ArrayList<ItemStack>();
        for (ItemStack item : living.m_20158_()) {
            boolean found = false;
            for (ItemStack secondItem : living.m_6167_()) {
                if (!item.equals(secondItem)) continue;
                found = true;
                break;
            }
            if (found) continue;
            itemsNotInSecondIterable.add(item);
        }
        return this.getForItems(itemsNotInSecondIterable);
    }

    public double getForItems(Iterable<ItemStack> itemStacks) {
        double mergedValue = 0.0;
        for (ItemStack armorItem : itemStacks) {
            mergedValue += this.getValueSafe(armorItem);
        }
        return mergedValue;
    }

    @Nullable
    public Double getValueRaw(ItemStack itemStack) {
        return (Double)ModularItemCache.getRaw(itemStack, this.privateKey);
    }

    public double getValueSafeRaw(ItemStack itemStack) {
        if (this.allowVisualOnly) {
            return ModularItemCache.getVisualOnlyCache(itemStack, this.privateKey, 0.0);
        }
        return ModularItemCache.get(itemStack, this.privateKey, 0.0);
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        new Operation(data, new ItemModule.ModuleInstance(ItemModule.empty));
        return true;
    }

    private static AttributeModifier.Operation getOperation(String operationString) {
        return switch (operationString) {
            case "*" -> AttributeModifier.Operation.MULTIPLY_BASE;
            case "**" -> AttributeModifier.Operation.MULTIPLY_TOTAL;
            default -> AttributeModifier.Operation.ADDITION;
        };
    }

    private static class Operation {
        public AttributeModifier.Operation attributeOperation;
        public String value;
        public ItemModule.ModuleInstance instance;

        public Operation(JsonElement toLoad, ItemModule.ModuleInstance instance) {
            if (toLoad.isJsonObject()) {
                JsonObject object = toLoad.getAsJsonObject();
                this.attributeOperation = DoubleProperty.getOperation(object.get("operation").getAsString());
                this.value = object.get("value").getAsString();
            } else {
                this.attributeOperation = AttributeModifier.Operation.ADDITION;
                this.value = toLoad.getAsJsonPrimitive().isBoolean() ? (toLoad.getAsBoolean() ? "1.0" : "0") : (toLoad.getAsJsonPrimitive().isNumber() ? Double.toString(toLoad.getAsDouble()) : toLoad.getAsString());
            }
            this.instance = instance;
        }

        public double solve() {
            return StatResolver.resolveDouble(this.value, this.instance);
        }
    }
}

