/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.util;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public abstract class DynamicCodecBasedProperty<T, A>
implements ModuleProperty {
    private final String key;

    public DynamicCodecBasedProperty(String key) {
        this.key = key;
        ModularItemCache.setSupplier(key, this::createCache);
    }

    public A createCache(ItemStack stack) {
        A holder = this.createNewHolder();
        ItemModule.ModuleInstance rootInstance = ItemModule.getModules(stack);
        for (ItemModule.ModuleInstance subModule : rootInstance.allSubModules()) {
            JsonElement element = subModule.getProperties().get(this);
            if (element == null) continue;
            T deserialized = this.getDataFromSubModule(element, subModule);
            this.addTo(subModule, deserialized, holder);
        }
        return holder;
    }

    public abstract void addTo(ItemModule.ModuleInstance var1, T var2, A var3);

    public abstract A createNewHolder();

    public abstract Codec<T> codec(ItemModule.ModuleInstance var1);

    public T getDataFromSubModule(JsonElement element, ItemModule.ModuleInstance module) {
        return (T)this.codec(module).parse((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to deserialize module data for DynamicCodecBasedProperty! -> {}", s));
    }

    @Nullable
    public A get(ItemStack itemStack) {
        return (A)ModularItemCache.getRaw(itemStack, this.key);
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        this.codec(new ItemModule.ModuleInstance(ItemModule.empty)).parse((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to load DynamicCodecBasedProperty! -> {}", s));
        return true;
    }

    public static class IntermediateList<I, O>
    extends FlattenedList<O> {
        protected final Codec<List<I>> codec;
        protected final BiFunction<I, ItemModule.ModuleInstance, O> converter;

        public IntermediateList(String key, Codec<List<I>> codec, BiFunction<I, ItemModule.ModuleInstance, O> converter) {
            super(key);
            this.codec = codec;
            this.converter = converter;
        }

        @Override
        public Codec<List<O>> codec(ItemModule.ModuleInstance instance) {
            return null;
        }

        @Override
        public List<O> getDataFromSubModule(JsonElement element, ItemModule.ModuleInstance module) {
            List input = (List)this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to deserialize module data for DynamicCodecBasedProperty.IntermediateList! -> {}", s));
            return input.stream().map(i -> this.converter.apply(i, module)).toList();
        }

        @Override
        public boolean load(String moduleKey, JsonElement data) throws Exception {
            this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to load data for DynamicCodecBasedProperty.IntermediateList! -> {}", s));
            return true;
        }
    }

    public static abstract class FlattenedList<T>
    extends DynamicCodecBasedProperty<List<T>, List<T>> {
        public FlattenedList(String key) {
            super(key);
        }

        @Override
        public void addTo(ItemModule.ModuleInstance module, List<T> object, List<T> holder) {
            holder.addAll(object);
        }

        @Override
        public List<T> createNewHolder() {
            return new ArrayList();
        }

        @Override
        public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
            return ModuleProperty.mergeList(old, toMerge, type);
        }
    }

    public static abstract class CollectedList<T>
    extends DynamicCodecBasedProperty<T, List<T>> {
        public CollectedList(String key) {
            super(key);
        }

        @Override
        public void addTo(ItemModule.ModuleInstance module, T object, List<T> holder) {
            holder.add(object);
        }

        @Override
        public List<T> createNewHolder() {
            return new ArrayList();
        }
    }
}

