/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.registries;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class MiapiRegistry<T> {
    protected final Map<String, T> entries = Collections.synchronizedMap(new LinkedHashMap());
    protected static final Map<Class<?>, MiapiRegistry<?>> REGISTRY_MAP = Collections.synchronizedMap(new LinkedHashMap());
    protected final List<Consumer<T>> callbacks = new ArrayList<Consumer<T>>();
    protected final Map<String, Supplier<T>> suppliers = Collections.synchronizedMap(new LinkedHashMap());

    protected MiapiRegistry() {
    }

    public static <T> MiapiRegistry<T> getInstance(Class<T> clazz) {
        if (!REGISTRY_MAP.containsKey(clazz)) {
            MiapiRegistry<T> instance = new MiapiRegistry<T>();
            REGISTRY_MAP.put(clazz, instance);
            return instance;
        }
        return REGISTRY_MAP.get(clazz);
    }

    @Nullable
    public <T> String findKey(T value) {
        Optional<String> matchingId = this.entries.entrySet().stream().filter(entry -> entry.getValue().equals(value)).map(Map.Entry::getKey).findFirst();
        return matchingId.orElse(null);
    }

    public static <T> MiapiRegistry<T> getInstance(Class<T> clazz, List<Consumer<T>> callbacks) {
        MiapiRegistry<Object> instance;
        if (!REGISTRY_MAP.containsKey(clazz)) {
            instance = new MiapiRegistry<T>();
            REGISTRY_MAP.put(clazz, instance);
        }
        MiapiRegistry<Object> finalInstance = instance = REGISTRY_MAP.get(clazz);
        callbacks.forEach(finalInstance::addCallback);
        return REGISTRY_MAP.computeIfAbsent(clazz, T -> new MiapiRegistry());
    }

    public T register(String name, T value) {
        if (this.entries.containsKey(name) || this.suppliers.containsKey(name)) {
            throw new IllegalArgumentException("Entry with name '" + name + "' already exists.");
        }
        this.entries.put(name, value);
        this.callbacks.forEach(callback -> callback.accept(value));
        return value;
    }

    public void registerSupplier(String name, Supplier<T> value) {
        if (this.entries.containsKey(name)) {
            throw new IllegalArgumentException("Entry with name '" + name + "' already exists.");
        }
        this.suppliers.put(name, value);
    }

    public void clear() {
        this.suppliers.clear();
        this.entries.clear();
    }

    public void loadAllSupplier() {
        this.suppliers.forEach((id, supplier) -> {
            Object entry = supplier.get();
            this.entries.put((String)id, entry);
            this.suppliers.remove(entry);
            this.callbacks.forEach(callbacks -> callbacks.accept(entry));
        });
    }

    @Nullable
    public T get(String name) {
        if (!this.entries.containsKey(name)) {
            if (this.suppliers.containsKey(name)) {
                Object entry = this.suppliers.get(name).get();
                this.entries.put(name, entry);
                this.suppliers.remove(entry);
                this.callbacks.forEach(callbacks -> callbacks.accept(entry));
                return entry;
            }
            return null;
        }
        return this.entries.get(name);
    }

    public void addCallback(Consumer<T> callback) {
        this.callbacks.add(callback);
        this.entries.values().forEach(callback);
    }

    public Map<String, T> getFlatMap() {
        return this.entries;
    }

    public Codec<T> codec() {
        return Codec.STRING.xmap(this::get, this::findKey);
    }
}

