/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.registries;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.blocks.ModularWorkBench;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.blueprint.BlueprintProperty;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.client.atlas.MaterialAtlasManager;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.craft.stat.CraftingStat;
import smartin.miapi.effects.CryoStatusEffect;
import smartin.miapi.effects.StunResistanceStatusEffect;
import smartin.miapi.effects.StunStatusEffect;
import smartin.miapi.effects.TeleportBlockEffect;
import smartin.miapi.entity.BoomerangItemProjectileEntity;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.item.MaterialSmithingRecipe;
import smartin.miapi.item.modular.ModularItemPart;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.item.modular.items.ExampleModularItem;
import smartin.miapi.item.modular.items.ExampleModularStrackableItem;
import smartin.miapi.item.modular.items.ModularArrow;
import smartin.miapi.item.modular.items.ModularAxe;
import smartin.miapi.item.modular.items.ModularBoots;
import smartin.miapi.item.modular.items.ModularBow;
import smartin.miapi.item.modular.items.ModularChestPlate;
import smartin.miapi.item.modular.items.ModularCrossbow;
import smartin.miapi.item.modular.items.ModularElytraItem;
import smartin.miapi.item.modular.items.ModularHelmet;
import smartin.miapi.item.modular.items.ModularHoe;
import smartin.miapi.item.modular.items.ModularLeggings;
import smartin.miapi.item.modular.items.ModularPickaxe;
import smartin.miapi.item.modular.items.ModularShovel;
import smartin.miapi.item.modular.items.ModularSword;
import smartin.miapi.item.modular.items.ModularVisualOnlyItem;
import smartin.miapi.item.modular.items.ModularWeapon;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.abilities.AreaHarvestReplant;
import smartin.miapi.modules.abilities.BlockAbility;
import smartin.miapi.modules.abilities.BoomerangThrowingAbility;
import smartin.miapi.modules.abilities.CircleAttackAbility;
import smartin.miapi.modules.abilities.CrossbowAbility;
import smartin.miapi.modules.abilities.EatAbility;
import smartin.miapi.modules.abilities.HeavyAttackAbility;
import smartin.miapi.modules.abilities.RiptideAbility;
import smartin.miapi.modules.abilities.ShieldBlockAbility;
import smartin.miapi.modules.abilities.ThrowingAbility;
import smartin.miapi.modules.abilities.toolabilities.AxeAbility;
import smartin.miapi.modules.abilities.toolabilities.HoeAbility;
import smartin.miapi.modules.abilities.toolabilities.ShovelAbility;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.conditions.AdvancementCondition;
import smartin.miapi.modules.conditions.AndCondition;
import smartin.miapi.modules.conditions.ChildCondition;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.IsModLoadedCondition;
import smartin.miapi.modules.conditions.ItemInInventoryCondition;
import smartin.miapi.modules.conditions.MaterialCondition;
import smartin.miapi.modules.conditions.MaterialCountCondition;
import smartin.miapi.modules.conditions.MiapiPerm;
import smartin.miapi.modules.conditions.ModuleTypeCondition;
import smartin.miapi.modules.conditions.NotCondition;
import smartin.miapi.modules.conditions.OrCondition;
import smartin.miapi.modules.conditions.OtherModuleModuleCondition;
import smartin.miapi.modules.conditions.ParentCondition;
import smartin.miapi.modules.conditions.TagCondition;
import smartin.miapi.modules.conditions.TrueCondition;
import smartin.miapi.modules.edit_options.CosmeticEditOption;
import smartin.miapi.modules.edit_options.CreateItemOption.CreateItemOption;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.edit_options.PropertyInjectionDev;
import smartin.miapi.modules.edit_options.ReplaceOption;
import smartin.miapi.modules.edit_options.skins.SkinOptions;
import smartin.miapi.modules.material.AllowedMaterial;
import smartin.miapi.modules.material.CopyParentMaterialProperty;
import smartin.miapi.modules.material.MaterialInscribeDataProperty;
import smartin.miapi.modules.material.MaterialInscribeProperty;
import smartin.miapi.modules.material.MaterialProperties;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.AbilityMangerProperty;
import smartin.miapi.modules.properties.AbilityProperty;
import smartin.miapi.modules.properties.AirDragProperty;
import smartin.miapi.modules.properties.AllowedSlots;
import smartin.miapi.modules.properties.ArmorPenProperty;
import smartin.miapi.modules.properties.ArrowProperty;
import smartin.miapi.modules.properties.AttributeProperty;
import smartin.miapi.modules.properties.AttributeSplitProperty;
import smartin.miapi.modules.properties.BlockProperty;
import smartin.miapi.modules.properties.CanChangeParentModule;
import smartin.miapi.modules.properties.CanChildBeEmpty;
import smartin.miapi.modules.properties.CanWalkOnSnow;
import smartin.miapi.modules.properties.ChannelingProperty;
import smartin.miapi.modules.properties.CircleAttackProperty;
import smartin.miapi.modules.properties.CraftingConditionProperty;
import smartin.miapi.modules.properties.CraftingEnchantProperty;
import smartin.miapi.modules.properties.CrossbowProperty;
import smartin.miapi.modules.properties.CryoProperty;
import smartin.miapi.modules.properties.DisplayNameProperty;
import smartin.miapi.modules.properties.DurabilityProperty;
import smartin.miapi.modules.properties.EdibleProperty;
import smartin.miapi.modules.properties.EmissiveProperty;
import smartin.miapi.modules.properties.EnchantAbilityProperty;
import smartin.miapi.modules.properties.EnchantmentProperty;
import smartin.miapi.modules.properties.EnchantmentTransformerProperty;
import smartin.miapi.modules.properties.EnderpearlProperty;
import smartin.miapi.modules.properties.EquipmentSlotProperty;
import smartin.miapi.modules.properties.ExhaustionProperty;
import smartin.miapi.modules.properties.ExplosionProperty;
import smartin.miapi.modules.properties.FakeEnchantmentProperty;
import smartin.miapi.modules.properties.FakeItemTagProperty;
import smartin.miapi.modules.properties.FireProof;
import smartin.miapi.modules.properties.FlexibilityProperty;
import smartin.miapi.modules.properties.FortuneProperty;
import smartin.miapi.modules.properties.FracturingProperty;
import smartin.miapi.modules.properties.GlintProperty;
import smartin.miapi.modules.properties.GuiStatProperty;
import smartin.miapi.modules.properties.HandheldItemProperty;
import smartin.miapi.modules.properties.HealthPercentDamage;
import smartin.miapi.modules.properties.HeavyAttackProperty;
import smartin.miapi.modules.properties.HideFlagsProperty;
import smartin.miapi.modules.properties.ImmolateProperty;
import smartin.miapi.modules.properties.IsCrossbowShootAble;
import smartin.miapi.modules.properties.IsPiglinGold;
import smartin.miapi.modules.properties.ItemIdProperty;
import smartin.miapi.modules.properties.LeechingProperty;
import smartin.miapi.modules.properties.LightningOnHit;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.LuminousLearningProperty;
import smartin.miapi.modules.properties.MagazineCrossbowShotDelay;
import smartin.miapi.modules.properties.MendingProperty;
import smartin.miapi.modules.properties.ModuleStats;
import smartin.miapi.modules.properties.NameProperty;
import smartin.miapi.modules.properties.NemesisProperty;
import smartin.miapi.modules.properties.OnKillExplosion;
import smartin.miapi.modules.properties.PillagesGuard;
import smartin.miapi.modules.properties.PriorityProperty;
import smartin.miapi.modules.properties.ProjectileTriggerProperty;
import smartin.miapi.modules.properties.RapidfireCrossbowProperty;
import smartin.miapi.modules.properties.RarityProperty;
import smartin.miapi.modules.properties.RepairPriority;
import smartin.miapi.modules.properties.RiptideProperty;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.modules.properties.StatProvisionProperty;
import smartin.miapi.modules.properties.StatRequirementProperty;
import smartin.miapi.modules.properties.StepCancelingProperty;
import smartin.miapi.modules.properties.TagProperty;
import smartin.miapi.modules.properties.TeleportTarget;
import smartin.miapi.modules.properties.ToolOrWeaponProperty;
import smartin.miapi.modules.properties.WaterDragProperty;
import smartin.miapi.modules.properties.WaterGravityProperty;
import smartin.miapi.modules.properties.compat.apoli.ApoliPowersProperty;
import smartin.miapi.modules.properties.compat.better_combat.BetterCombatProperty;
import smartin.miapi.modules.properties.compat.ht_treechop.TreechopProperty;
import smartin.miapi.modules.properties.damage_boosts.AquaticDamage;
import smartin.miapi.modules.properties.damage_boosts.IllagerBane;
import smartin.miapi.modules.properties.damage_boosts.SmiteDamage;
import smartin.miapi.modules.properties.damage_boosts.SpiderDamage;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;
import smartin.miapi.modules.properties.mining.MiningShapeProperty;
import smartin.miapi.modules.properties.potion.OnDamagedEffects;
import smartin.miapi.modules.properties.potion.OnHitTargetEffects;
import smartin.miapi.modules.properties.potion.OnKillEffects;
import smartin.miapi.modules.properties.render.BannerModelProperty;
import smartin.miapi.modules.properties.render.BlockModelProperty;
import smartin.miapi.modules.properties.render.ConduitModelProperty;
import smartin.miapi.modules.properties.render.CrystalModelProperty;
import smartin.miapi.modules.properties.render.EntityModelProperty;
import smartin.miapi.modules.properties.render.GuiOffsetProperty;
import smartin.miapi.modules.properties.render.ItemModelProperty;
import smartin.miapi.modules.properties.render.ModelMergeProperty;
import smartin.miapi.modules.properties.render.ModelProperty;
import smartin.miapi.modules.properties.render.ModelTransformationProperty;
import smartin.miapi.modules.properties.render.OverlayModelProperty;
import smartin.miapi.modules.properties.render.ServerReplaceProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.modules.synergies.SynergyManager;
import smartin.miapi.registries.MiapiRegistrar;
import smartin.miapi.registries.MiapiRegistry;

public class RegistryInventory {
    public static final Supplier<RegistrarManager> registrar = Suppliers.memoize(() -> RegistrarManager.get((String)"miapi"));
    public static final MiapiRegistrar<Item> modularItems = MiapiRegistrar.of(registrar.get().get(Registries.f_256913_));
    public static final Registrar<Item> items = registrar.get().get(Registries.f_256913_);
    public static final Registrar<Block> blocks = registrar.get().get(Registries.f_256747_);
    public static final Registrar<BlockEntityType<?>> blockEntities = registrar.get().get(Registries.f_256922_);
    public static final Registrar<Attribute> attributes = registrar.get().get(Registries.f_256728_);
    public static final Registrar<EntityType<?>> entityTypes = registrar.get().get(Registries.f_256939_);
    public static final Registrar<MenuType<?>> screenHandlers = registrar.get().get(Registries.f_256798_);
    public static final Registrar<MobEffect> statusEffects = registrar.get().get(Registries.f_256929_);
    public static final Registrar<CreativeModeTab> tab = registrar.get().get(Registries.f_279569_);
    public static final Registrar<GameEvent> gameEvents = registrar.get().get(Registries.f_256827_);
    public static final Registrar<RecipeSerializer<?>> recipeSerializers = registrar.get().get(Registries.f_256764_);
    public static final MiapiRegistry<ModuleProperty> moduleProperties = MiapiRegistry.getInstance(ModuleProperty.class);
    public static final MiapiRegistry<ItemModule> modules = MiapiRegistry.getInstance(ItemModule.class);
    public static final MiapiRegistry<EditOption> editOptions = MiapiRegistry.getInstance(EditOption.class);
    public static final MiapiRegistry<CraftingStat> craftingStats = MiapiRegistry.getInstance(CraftingStat.class);
    public static final TagKey<Item> MIAPI_FORBIDDEN_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("miapi_forbidden"));
    public static Block modularWorkBench;
    public static BlockEntityType<ModularWorkBenchEntity> modularWorkBenchEntityType;
    public static Item modularItem;
    public static Item visualOnlymodularItem;
    public static Item modularAxe;
    public static Item modularMattock;
    public static MobEffect cryoStatusEffect;
    public static MobEffect teleportBlockEffect;
    public static MobEffect stunEffect;
    public static MobEffect stunResistanceEffect;
    public static GameEvent statProviderCreatedEvent;
    public static GameEvent statProviderRemovedEvent;
    public static RecipeSerializer serializer;
    public static RegistrySupplier<EntityType<ItemProjectileEntity>> itemProjectileType;
    public static RegistrySupplier<EntityType<BoomerangItemProjectileEntity>> itemBoomerangProjectileType;
    public static MenuType<CraftingScreenHandler> craftingScreenHandler;

    public static <T> RegistrySupplier<T> registerAndSupply(Registrar<T> rg, ResourceLocation id, Supplier<T> object) {
        return rg.register(id, object);
    }

    public static <T> RegistrySupplier<T> registerAndSupply(Registrar<T> rg, String id, Supplier<T> object) {
        return RegistryInventory.registerAndSupply(rg, new ResourceLocation("miapi", id), object);
    }

    public static <T, E extends T> void register(Registrar<T> rg, ResourceLocation id, Supplier<E> object, Consumer<E> onRegister) {
        rg.register(id, object).listen(onRegister);
    }

    public static <T, E extends T> void register(Registrar<T> rg, String id, Supplier<E> object, Consumer<E> onRegister) {
        RegistryInventory.register(rg, new ResourceLocation("miapi", id), object, onRegister);
    }

    public static <T> void register(Registrar<T> rg, ResourceLocation id, Supplier<T> object) {
        rg.register(id, object);
    }

    public static <T> void register(Registrar<T> rg, String id, Supplier<T> object) {
        RegistryInventory.register(rg, new ResourceLocation("miapi", id), object);
    }

    public static <T> void registerMiapi(MiapiRegistry<T> rg, String id, T object) {
        rg.register(id, object);
    }

    public static <T, E extends T> void registerMiapi(MiapiRegistry<T> rg, String id, E object, Consumer<E> onRegister) {
        rg.register(id, object);
        onRegister.accept(object);
    }

    public static <T> void addCallback(Registrar<T> rg, Consumer<T> consumer) {
        rg.getIds().forEach(id -> rg.listen(id, consumer));
    }

    public static void registerAtt(String id, boolean attach, Supplier<Attribute> sup, Consumer<Attribute> onRegister) {
        ResourceLocation rl = new ResourceLocation("miapi", id);
        String stringId = rl.toString();
        RegistrySupplier obj = attributes.register(rl, sup);
        obj.listen(onRegister);
        if (attach) {
            obj.listen(att -> AttributeRegistry.entityAttributeMap.put(stringId, (Attribute)att));
        }
    }

    public static void setup() {
        RegistryInventory.register(screenHandlers, "default_crafting", () -> new MenuType(CraftingScreenHandler::new, FeatureFlagSet.m_246902_()), (E scr) -> {
            craftingScreenHandler = scr;
            if (Platform.getEnvironment() == Env.CLIENT) {
                MiapiClient.registerScreenHandler();
            }
        });
        RegistryInventory.register(recipeSerializers, "smithing", MaterialSmithingRecipe.Serializer::new, (E i) -> {
            serializer = i;
        });
        RegistryInventory.register(blocks, "modular_work_bench", () -> new ModularWorkBench(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(2.5f, 6.0f).m_60918_(SoundType.f_56743_).m_60955_().m_278166_(PushReaction.IGNORE)), (E b) -> {
            modularWorkBench = b;
        });
        RegistryInventory.register(blockEntities, "modular_work_bench", () -> BlockEntityType.Builder.m_155273_(ModularWorkBenchEntity::new, (Block[])new Block[]{modularWorkBench}).m_58966_(null), (E be) -> {
            modularWorkBenchEntityType = be;
            if (Platform.getEnvironment() == Env.CLIENT) {
                MiapiClient.registerBlockEntityRenderer();
            }
        });
        RegistryInventory.register(items, "modular_work_bench", () -> new BlockItem(modularWorkBench, new Item.Properties()));
        RegistryInventory.register(tab, "miapi_tab", () -> CreativeTabRegistry.create(b -> {
            b.m_257941_((Component)Component.m_237115_((String)"miapi.tab.name"));
            b.m_257737_(() -> new ItemStack((ItemLike)modularWorkBench));
            b.m_257501_((displayContext, entries) -> entries.m_246326_((ItemLike)modularWorkBench));
        }));
        RegistryInventory.register(modularItems, "modular_broken_item", ModularVisualOnlyItem::new, (E i) -> {
            visualOnlymodularItem = i;
        });
        RegistryInventory.register(modularItems, "modular_item", ExampleModularItem::new, (E i) -> {
            modularItem = i;
        });
        RegistryInventory.register(modularItems, "modular_part", ModularItemPart::new);
        RegistryInventory.register(modularItems, "modular_handheld", ModularWeapon::new);
        RegistryInventory.register(modularItems, "modular_katars", ModularSword::new);
        RegistryInventory.register(modularItems, "modular_gauntlets", ModularWeapon::new);
        RegistryInventory.register(modularItems, "modular_knuckles", ModularWeapon::new);
        RegistryInventory.register(modularItems, "modular_tonfa", ModularWeapon::new);
        RegistryInventory.register(modularItems, "modular_handle", ModularWeapon::new);
        RegistryInventory.register(modularItems, "modular_sword", ModularSword::new);
        RegistryInventory.register(modularItems, "twin_blade", ModularSword::new);
        RegistryInventory.register(modularItems, "modular_katana", ModularSword::new);
        RegistryInventory.register(modularItems, "modular_naginata", ModularSword::new);
        RegistryInventory.register(modularItems, "modular_greatsword", ModularSword::new);
        RegistryInventory.register(modularItems, "modular_dagger", ModularSword::new);
        RegistryInventory.register(modularItems, "modular_spear", ModularSword::new);
        RegistryInventory.register(modularItems, "modular_throwing_knife", ModularSword::new);
        RegistryInventory.register(modularItems, "modular_rapier", ModularSword::new);
        RegistryInventory.register(modularItems, "modular_longsword", ModularSword::new);
        RegistryInventory.register(modularItems, "modular_trident", ModularSword::new);
        RegistryInventory.register(modularItems, "modular_scythe", ModularSword::new);
        RegistryInventory.register(modularItems, "modular_sickle", ModularSword::new);
        RegistryInventory.register(modularItems, "modular_shovel", ModularShovel::new);
        RegistryInventory.register(modularItems, "modular_pickaxe", ModularPickaxe::new);
        RegistryInventory.register(modularItems, "modular_hammer", ModularPickaxe::new);
        RegistryInventory.register(modularItems, "modular_axe", ModularAxe::new, (E i) -> {
            modularAxe = i;
        });
        RegistryInventory.register(modularItems, "modular_hoe", ModularHoe::new);
        RegistryInventory.register(modularItems, "modular_mattock", ModularAxe::new, (E i) -> {
            modularMattock = i;
        });
        RegistryInventory.register(modularItems, "modular_bow", ModularBow::new);
        RegistryInventory.register(modularItems, "modular_small_bow", ModularBow::new);
        RegistryInventory.register(modularItems, "modular_large_bow", ModularBow::new);
        RegistryInventory.register(modularItems, "modular_bow_part", ExampleModularItem::new);
        RegistryInventory.register(modularItems, "modular_crossbow", ModularCrossbow::new);
        RegistryInventory.register(modularItems, "modular_small_crossbow", ModularCrossbow::new);
        RegistryInventory.register(modularItems, "modular_large_crossbow", ModularCrossbow::new);
        RegistryInventory.register(modularItems, "modular_crossbow_part", ExampleModularItem::new);
        RegistryInventory.register(modularItems, "modular_arrow", ModularArrow::new);
        RegistryInventory.register(modularItems, "modular_arrow_part", ExampleModularStrackableItem::new);
        RegistryInventory.register(modularItems, "modular_helmet", ModularHelmet::new);
        RegistryInventory.register(modularItems, "modular_chestplate", ModularChestPlate::new);
        RegistryInventory.register(modularItems, "modular_leggings", ModularLeggings::new);
        RegistryInventory.register(modularItems, "modular_boots", ModularBoots::new);
        RegistryInventory.register(modularItems, "modular_elytra", ModularElytraItem::getInstance);
        RegistryInventory.register(statusEffects, "cryo", CryoStatusEffect::new, (E eff) -> {
            cryoStatusEffect = eff;
        });
        RegistryInventory.register(statusEffects, "teleport_block", TeleportBlockEffect::new, (E eff) -> {
            teleportBlockEffect = eff;
        });
        RegistryInventory.register(statusEffects, "stun", StunStatusEffect::new, (E eff) -> {
            stunEffect = eff;
        });
        RegistryInventory.register(statusEffects, "stun_resistance", StunResistanceStatusEffect::new, (E eff) -> {
            stunResistanceEffect = eff;
        });
        RegistryInventory.registerAtt("generic.mining_speed.pickaxe", false, () -> new RangedAttribute("miapi.attribute.name.mining_speed.pickaxe", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.MINING_SPEED_PICKAXE = att;
        });
        RegistryInventory.registerAtt("generic.mining_speed.axe", false, () -> new RangedAttribute("miapi.attribute.name.mining_speed.axe", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.MINING_SPEED_AXE = att;
        });
        RegistryInventory.registerAtt("generic.mining_speed.shovel", false, () -> new RangedAttribute("miapi.attribute.name.mining_speed.shovel", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.MINING_SPEED_SHOVEL = att;
        });
        RegistryInventory.registerAtt("generic.mining_speed.hoe", false, () -> new RangedAttribute("miapi.attribute.name.mining_speed.hoe", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.MINING_SPEED_HOE = att;
        });
        RegistryInventory.registerAtt("generic.resistance", true, () -> new RangedAttribute("miapi.attribute.name.resistance", 0.0, 0.0, 100.0).m_22084_(true), att -> {
            AttributeRegistry.DAMAGE_RESISTANCE = att;
        });
        RegistryInventory.registerAtt("generic.back_stab", true, () -> new RangedAttribute("miapi.attribute.name.back_stab", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.BACK_STAB = att;
        });
        RegistryInventory.registerAtt("generic.armor_crushing", true, () -> new RangedAttribute("miapi.attribute.name.armor_crushing", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.ARMOR_CRUSHING = att;
        });
        RegistryInventory.registerAtt("generic.projectile_armor", true, () -> new RangedAttribute("miapi.attribute.name.projectile_armor", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.PROJECTILE_ARMOR = att;
        });
        RegistryInventory.registerAtt("generic.shield_break", true, () -> new RangedAttribute("miapi.attribute.name.shield_break", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.SHIELD_BREAK = att;
        });
        RegistryInventory.registerAtt("generic.player_item_use_speed", true, () -> new RangedAttribute("miapi.attribute.name.player_item_use_speed", -0.8, -1.0, 0.0).m_22084_(true), att -> {
            AttributeRegistry.PLAYER_ITEM_USE_MOVEMENT_SPEED = att;
        });
        RegistryInventory.registerAtt("generic.magic_damage", true, () -> new RangedAttribute("miapi.attribute.name.magic_damage", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.MAGIC_DAMAGE = att;
        });
        RegistryInventory.registerAtt("generic.stun_damage", true, () -> new RangedAttribute("miapi.attribute.name.stun_damage", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.STUN_DAMAGE = att;
        });
        RegistryInventory.registerAtt("generic.stun_max_health", true, () -> new RangedAttribute("miapi.attribute.name.stun_max_health", MiapiConfig.INSTANCE.server.stunEffectCategory.stunHealth, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.STUN_MAX_HEALTH = att;
        });
        RegistryInventory.registerAtt("generic.crit_damage", true, () -> new RangedAttribute("miapi.attribute.name.crit_damage", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.CRITICAL_DAMAGE = att;
        });
        RegistryInventory.registerAtt("generic.crit_chance", true, () -> new RangedAttribute("miapi.attribute.name.crit_chance", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.CRITICAL_CHANCE = att;
        });
        RegistryInventory.registerAtt("generic.bow_draw_time", true, () -> new RangedAttribute("miapi.attribute.name.bow_draw_time", 0.0, -1024.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.BOW_DRAW_TIME = att;
        });
        RegistryInventory.registerAtt("generic.projectile_damage", true, () -> new RangedAttribute("miapi.attribute.name.projectile_damage", 0.0, -1024.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.PROJECTILE_DAMAGE = att;
        });
        RegistryInventory.registerAtt("generic.projectile_speed", true, () -> new RangedAttribute("miapi.attribute.name.projectile_speed", 0.0, -1024.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.PROJECTILE_SPEED = att;
        });
        RegistryInventory.registerAtt("generic.projectile_accuracy", true, () -> new RangedAttribute("miapi.attribute.name.projectile_accuracy", 0.0, -1024.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.PROJECTILE_ACCURACY = att;
        });
        RegistryInventory.registerAtt("generic.projectile_piercing", true, () -> new RangedAttribute("miapi.attribute.name.projectile_piercing", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.PROJECTILE_PIERCING = att;
        });
        RegistryInventory.registerAtt("generic.projectile_crit_multiplier", true, () -> new RangedAttribute("miapi.attribute.name.projectile_crit_multiplier", 1.5, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.PROJECTILE_CRIT_MULTIPLIER = att;
        });
        RegistryInventory.registerAtt("generic.elytra_turn_efficiency", true, () -> new RangedAttribute("miapi.attribute.name.elytra_turn_efficiency", 0.0, -1024.0, 100.0).m_22084_(true), att -> {
            AttributeRegistry.ELYTRA_TURN_EFFICIENCY = att;
        });
        RegistryInventory.registerAtt("generic.elytra_glide_efficiency", true, () -> new RangedAttribute("miapi.attribute.name.elytra_glide_efficiency", 0.0, -1024.0, 100.0).m_22084_(true), att -> {
            AttributeRegistry.ELYTRA_GLIDE_EFFICIENCY = att;
        });
        RegistryInventory.registerAtt("generic.elytra_rocket_efficiency", true, () -> new RangedAttribute("miapi.attribute.name.elytra_rocket_efficiency", 1.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.ELYTRA_ROCKET_EFFICIENCY = att;
        });
        RegistryInventory.registerAtt("generic.shielding_armor", true, () -> new RangedAttribute("miapi.attribute.name.shielding_armor", 0.0, 0.0, 1024.0).m_22084_(true), att -> {
            AttributeRegistry.SHIELDING_ARMOR = att;
        });
        RegistryInventory.register(gameEvents, "stat_provider_added", () -> new GameEvent("miapi:stat_provider_added", 16), (E ev) -> {
            statProviderCreatedEvent = ev;
        });
        RegistryInventory.register(gameEvents, "stat_provider_removed", () -> new GameEvent("miapi:stat_provider_removed", 16), (E ev) -> {
            statProviderRemovedEvent = ev;
        });
        LifecycleEvent.SETUP.register(() -> {
            RegistryInventory.registerMiapi(editOptions, "replace", new ReplaceOption());
            RegistryInventory.registerMiapi(editOptions, "dev", new PropertyInjectionDev());
            RegistryInventory.registerMiapi(editOptions, "skin", new SkinOptions());
            RegistryInventory.registerMiapi(editOptions, "create", new CreateItemOption());
            RegistryInventory.registerMiapi(editOptions, "cosmetic", new CosmeticEditOption());
            SynergyManager.setup();
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "true", new TrueCondition());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "not", new NotCondition());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "or", new OrCondition());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "and", new AndCondition());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "child", new ChildCondition());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "parent", new ParentCondition());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "otherModule", new OtherModuleModuleCondition());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "module", new ModuleTypeCondition());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "material", new MaterialCondition());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "material_count", new MaterialCountCondition());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "tag", new TagCondition());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "miapi_perm", new MiapiPerm());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "item_in_inventory", new ItemInInventoryCondition());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "mod_loaded", new IsModLoadedCondition());
            RegistryInventory.registerMiapi(ConditionManager.moduleConditionRegistry, "advancement", new AdvancementCondition());
            if (Environment.isClient()) {
                RegistryInventory.registerMiapi(moduleProperties, "texture", new ModelProperty());
                RegistryInventory.registerMiapi(moduleProperties, "modelTransform", new ModelTransformationProperty());
                RegistryInventory.registerMiapi(moduleProperties, "modelMerge", new ModelMergeProperty());
                RegistryInventory.registerMiapi(moduleProperties, "guiOffset", new GuiOffsetProperty());
                RegistryInventory.registerMiapi(moduleProperties, "item_model", new ItemModelProperty());
                RegistryInventory.registerMiapi(moduleProperties, "banner", new BannerModelProperty());
                RegistryInventory.registerMiapi(moduleProperties, BlockModelProperty.KEY, new BlockModelProperty());
                RegistryInventory.registerMiapi(moduleProperties, EntityModelProperty.KEY, new EntityModelProperty());
                RegistryInventory.registerMiapi(moduleProperties, CrystalModelProperty.KEY, new CrystalModelProperty());
                RegistryInventory.registerMiapi(moduleProperties, ConduitModelProperty.KEY, new ConduitModelProperty());
                RegistryInventory.registerMiapi(moduleProperties, OverlayModelProperty.KEY, new OverlayModelProperty());
            } else {
                RegistryInventory.registerMiapi(moduleProperties, "texture", new ServerReplaceProperty());
                RegistryInventory.registerMiapi(moduleProperties, "modelTransform", new ServerReplaceProperty());
                RegistryInventory.registerMiapi(moduleProperties, "modelMerge", new ServerReplaceProperty());
                RegistryInventory.registerMiapi(moduleProperties, "guiOffset", new ServerReplaceProperty());
                RegistryInventory.registerMiapi(moduleProperties, "item_model", new ServerReplaceProperty());
                RegistryInventory.registerMiapi(moduleProperties, "banner", new ServerReplaceProperty());
                RegistryInventory.registerMiapi(moduleProperties, "crystal_model", new ServerReplaceProperty());
                RegistryInventory.registerMiapi(moduleProperties, "block_model", new ServerReplaceProperty());
                RegistryInventory.registerMiapi(moduleProperties, "entity_model", new ServerReplaceProperty());
                RegistryInventory.registerMiapi(moduleProperties, "conduit_model", new ServerReplaceProperty());
                RegistryInventory.registerMiapi(moduleProperties, "overlay_texture_model", new ServerReplaceProperty());
            }
            RegistryInventory.registerMiapi(moduleProperties, CanChildBeEmpty.KEY, new CanChildBeEmpty());
            RegistryInventory.registerMiapi(moduleProperties, "itemLore", new LoreProperty());
            RegistryInventory.registerMiapi(moduleProperties, "name", new NameProperty());
            RegistryInventory.registerMiapi(moduleProperties, "slots", new SlotProperty());
            RegistryInventory.registerMiapi(moduleProperties, "allowedInSlots", new AllowedSlots());
            RegistryInventory.registerMiapi(moduleProperties, "material", new MaterialProperty());
            RegistryInventory.registerMiapi(moduleProperties, "allowedMaterial", new AllowedMaterial());
            RegistryInventory.registerMiapi(moduleProperties, "attributes", new AttributeProperty());
            RegistryInventory.registerMiapi(moduleProperties, "displayName", new DisplayNameProperty());
            RegistryInventory.registerMiapi(moduleProperties, "itemId", new ItemIdProperty());
            RegistryInventory.registerMiapi(moduleProperties, "equipmentSlot", new EquipmentSlotProperty());
            RegistryInventory.registerMiapi(moduleProperties, "flexibility", new FlexibilityProperty());
            RegistryInventory.registerMiapi(moduleProperties, "abilities", new AbilityProperty());
            RegistryInventory.registerMiapi(moduleProperties, "blocking", new BlockProperty());
            RegistryInventory.registerMiapi(moduleProperties, "riptide", new RiptideProperty());
            RegistryInventory.registerMiapi(moduleProperties, "healthPercent", new HealthPercentDamage());
            RegistryInventory.registerMiapi(moduleProperties, "armor_pen", new ArmorPenProperty());
            RegistryInventory.registerMiapi(moduleProperties, "heavyAttack", new HeavyAttackProperty());
            RegistryInventory.registerMiapi(moduleProperties, CircleAttackProperty.KEY, new CircleAttackProperty());
            RegistryInventory.registerMiapi(moduleProperties, "Crossbow", new CrossbowProperty());
            RegistryInventory.registerMiapi(moduleProperties, "isWeapon", new ToolOrWeaponProperty());
            RegistryInventory.registerMiapi(moduleProperties, "mining_level", new MiningLevelProperty());
            RegistryInventory.registerMiapi(moduleProperties, "tag", new TagProperty());
            RegistryInventory.registerMiapi(moduleProperties, "enchantments", new EnchantmentProperty());
            RegistryInventory.registerMiapi(moduleProperties, MaterialProperties.KEY, new MaterialProperties());
            RegistryInventory.registerMiapi(moduleProperties, "crafting_condition", new CraftingConditionProperty());
            RegistryInventory.registerMiapi(moduleProperties, "statRequirements", new StatRequirementProperty());
            RegistryInventory.registerMiapi(moduleProperties, "provideStats", new StatProvisionProperty());
            RegistryInventory.registerMiapi(moduleProperties, "glint_settings", new GlintProperty());
            RegistryInventory.registerMiapi(moduleProperties, "is_enderpearl", new EnderpearlProperty());
            RegistryInventory.registerMiapi(moduleProperties, "teleport_target", new TeleportTarget());
            RegistryInventory.registerMiapi(moduleProperties, "explosion_projectile", new ExplosionProperty());
            RegistryInventory.registerMiapi(moduleProperties, "inscribe_on_craft", new MaterialInscribeProperty());
            RegistryInventory.registerMiapi(moduleProperties, "replace_projectile", new ProjectileTriggerProperty());
            RegistryInventory.registerMiapi(moduleProperties, "channeling", new ChannelingProperty());
            RegistryInventory.registerMiapi(moduleProperties, "air_drag", new AirDragProperty());
            RegistryInventory.registerMiapi(moduleProperties, "water_drag", new WaterDragProperty());
            RegistryInventory.registerMiapi(moduleProperties, "is_arrow", new ArrowProperty());
            RegistryInventory.registerMiapi(moduleProperties, "durability", new DurabilityProperty());
            RegistryInventory.registerMiapi(moduleProperties, "fracturing", new FracturingProperty());
            RegistryInventory.registerMiapi(moduleProperties, "fortune", new FortuneProperty());
            RegistryInventory.registerMiapi(moduleProperties, "mending", new MendingProperty());
            RegistryInventory.registerMiapi(moduleProperties, "isPiglinGold", new IsPiglinGold());
            RegistryInventory.registerMiapi(moduleProperties, "canWalkOnSnow", new CanWalkOnSnow());
            RegistryInventory.registerMiapi(moduleProperties, "fireProof", new FireProof());
            RegistryInventory.registerMiapi(moduleProperties, "repairPriority", new RepairPriority());
            RegistryInventory.registerMiapi(moduleProperties, "priority", new PriorityProperty());
            RegistryInventory.registerMiapi(moduleProperties, "immolate", new ImmolateProperty());
            RegistryInventory.registerMiapi(moduleProperties, "leeching", new LeechingProperty());
            RegistryInventory.registerMiapi(moduleProperties, "crossbowAmmunition", new IsCrossbowShootAble());
            RegistryInventory.registerMiapi(moduleProperties, "edible", new EdibleProperty());
            RegistryInventory.registerMiapi(moduleProperties, "cryo", new CryoProperty());
            RegistryInventory.registerMiapi(moduleProperties, "aquatic_damage", new AquaticDamage());
            RegistryInventory.registerMiapi(moduleProperties, "spider_damage", new SpiderDamage());
            RegistryInventory.registerMiapi(moduleProperties, "smite_damage", new SmiteDamage());
            RegistryInventory.registerMiapi(moduleProperties, "illagerBane", new IllagerBane());
            RegistryInventory.registerMiapi(moduleProperties, "pillagerGuard", new PillagesGuard());
            RegistryInventory.registerMiapi(moduleProperties, "luminiousLearning", new LuminousLearningProperty());
            RegistryInventory.registerMiapi(moduleProperties, BlueprintProperty.KEY, new BlueprintProperty());
            RegistryInventory.registerMiapi(moduleProperties, "water_gravity", new WaterGravityProperty());
            RegistryInventory.registerMiapi(moduleProperties, "crafting_enchants", new CraftingEnchantProperty());
            RegistryInventory.registerMiapi(moduleProperties, "fake_enchant", new FakeEnchantmentProperty());
            RegistryInventory.registerMiapi(moduleProperties, "food_exhaustion", new ExhaustionProperty());
            RegistryInventory.registerMiapi(moduleProperties, "inscribe_data_on_craft", new MaterialInscribeDataProperty());
            RegistryInventory.registerMiapi(moduleProperties, "fake_item_tag", new FakeItemTagProperty());
            RegistryInventory.registerMiapi(moduleProperties, RarityProperty.KEY, new RarityProperty());
            RegistryInventory.registerMiapi(moduleProperties, HideFlagsProperty.KEY, new HideFlagsProperty());
            RegistryInventory.registerMiapi(moduleProperties, MiningShapeProperty.KEY, new MiningShapeProperty());
            RegistryInventory.registerMiapi(moduleProperties, ModuleStats.KEY, new ModuleStats());
            RegistryInventory.registerMiapi(moduleProperties, EnchantAbilityProperty.KEY, new EnchantAbilityProperty());
            RegistryInventory.registerMiapi(moduleProperties, StepCancelingProperty.KEY, new StepCancelingProperty());
            RegistryInventory.registerMiapi(moduleProperties, LightningOnHit.KEY, new LightningOnHit());
            RegistryInventory.registerMiapi(moduleProperties, GuiStatProperty.KEY, new GuiStatProperty());
            RegistryInventory.registerMiapi(moduleProperties, AbilityMangerProperty.KEY, new AbilityMangerProperty());
            RegistryInventory.registerMiapi(moduleProperties, OnHitTargetEffects.KEY, new OnHitTargetEffects());
            RegistryInventory.registerMiapi(moduleProperties, OnDamagedEffects.KEY, new OnDamagedEffects());
            RegistryInventory.registerMiapi(moduleProperties, OnKillEffects.KEY, new OnKillEffects());
            RegistryInventory.registerMiapi(moduleProperties, OnKillExplosion.KEY, new OnKillExplosion());
            RegistryInventory.registerMiapi(moduleProperties, "allowChangeParent", new CanChangeParentModule());
            RegistryInventory.registerMiapi(moduleProperties, NemesisProperty.KEY, new NemesisProperty());
            RegistryInventory.registerMiapi(moduleProperties, CopyParentMaterialProperty.KEY, new CopyParentMaterialProperty());
            RegistryInventory.registerMiapi(moduleProperties, "emissive", new EmissiveProperty());
            RegistryInventory.registerMiapi(moduleProperties, EnchantmentTransformerProperty.KEY, new EnchantmentTransformerProperty());
            RegistryInventory.registerMiapi(moduleProperties, RapidfireCrossbowProperty.KEY, new RapidfireCrossbowProperty());
            RegistryInventory.registerMiapi(moduleProperties, MagazineCrossbowShotDelay.KEY, new MagazineCrossbowShotDelay());
            RegistryInventory.registerMiapi(moduleProperties, HandheldItemProperty.KEY, new HandheldItemProperty());
            RegistryInventory.registerMiapi(moduleProperties, AttributeSplitProperty.KEY, new AttributeSplitProperty());
            RegistryInventory.registerMiapi(moduleProperties, BetterCombatProperty.KEY, new BetterCombatProperty());
            RegistryInventory.registerMiapi(moduleProperties, "apoli_powers", new ApoliPowersProperty());
            RegistryInventory.registerMiapi(moduleProperties, TreechopProperty.KEY, new TreechopProperty());
            RegistryInventory.registerMiapi(ItemAbilityManager.useAbilityRegistry, "throw", new ThrowingAbility());
            RegistryInventory.registerMiapi(ItemAbilityManager.useAbilityRegistry, "boomerang_throw", new BoomerangThrowingAbility());
            RegistryInventory.registerMiapi(ItemAbilityManager.useAbilityRegistry, "block", new BlockAbility());
            RegistryInventory.registerMiapi(ItemAbilityManager.useAbilityRegistry, "full_block", new ShieldBlockAbility());
            RegistryInventory.registerMiapi(ItemAbilityManager.useAbilityRegistry, "riptide", new RiptideAbility());
            RegistryInventory.registerMiapi(ItemAbilityManager.useAbilityRegistry, "heavyAttack", new HeavyAttackAbility());
            RegistryInventory.registerMiapi(ItemAbilityManager.useAbilityRegistry, CircleAttackProperty.KEY, new CircleAttackAbility());
            RegistryInventory.registerMiapi(ItemAbilityManager.useAbilityRegistry, "Crossbow", new CrossbowAbility());
            RegistryInventory.registerMiapi(ItemAbilityManager.useAbilityRegistry, "axe_ability", new AxeAbility());
            RegistryInventory.registerMiapi(ItemAbilityManager.useAbilityRegistry, "hoe_ability", new HoeAbility());
            RegistryInventory.registerMiapi(ItemAbilityManager.useAbilityRegistry, "shovel_ability", new ShovelAbility());
            RegistryInventory.registerMiapi(ItemAbilityManager.useAbilityRegistry, "eat", new EatAbility());
            RegistryInventory.registerMiapi(ItemAbilityManager.useAbilityRegistry, AreaHarvestReplant.KEY, new AreaHarvestReplant());
            Miapi.LOGGER.info("Registered Truly Modulars Property resolvers:");
            PropertyResolver.registry.forEach(pair -> Miapi.LOGGER.info("registered resolver: " + ((ResourceLocation)pair.m_14418_()).toString()));
        });
    }

    static {
        itemProjectileType = RegistryInventory.registerAndSupply(entityTypes, "thrown_item", () -> EntityType.Builder.m_20704_(ItemProjectileEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20).m_20712_("miapi:thrown_item"));
        itemBoomerangProjectileType = RegistryInventory.registerAndSupply(entityTypes, "thrown_boomerang_item", () -> EntityType.Builder.m_20704_(BoomerangItemProjectileEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20).m_20712_("miapi:thrown_boomerang_item"));
        itemProjectileType.listen(e -> {
            if (Platform.getEnvironment() == Env.CLIENT) {
                MiapiClient.registerEntityRenderer();
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        public static final ResourceLocation customGlintTexture = new ResourceLocation("miapi", "textures/custom_glint.png");
        public static ShaderInstance entityTranslucentMaterialShader;
        public static ShaderInstance glintShader;
        public static final RenderType modularItemGlint;
        public static final RenderType TRANSLUCENT_NO_CULL;

        private static void setupGlintTexturing(float scale) {
            long l = (long)((double)Util.m_137550_() * (Double)Minecraft.m_91087_().f_91066_.m_267805_().m_231551_() * 8.0);
            float f = (float)(l % 110000L) / 110000.0f;
            float g = (float)(l % 30000L) / 30000.0f;
            Matrix4f matrix4f = new Matrix4f().translation(-f, g, 0.0f);
            matrix4f.rotateZ(0.17453292f).scale(scale);
            RenderSystem.setTextureMatrix((Matrix4f)matrix4f);
        }

        static {
            modularItemGlint = RenderType.m_173215_((String)"miapi_glint_direct|immediatelyfast:renderlast", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> {
                if (!RenderSystem.isOnRenderThreadOrInit()) {
                    throw new RuntimeException("attempted miapi glint setup on-non-render thread. Please report this to Truly Modular");
                }
                glintShader.m_173363_();
                int id = 10;
                RenderSystem.setShaderTexture((int)id, (ResourceLocation)customGlintTexture);
                RenderSystem.bindTexture((int)id);
                int j = RenderSystem.getShaderTexture((int)id);
                glintShader.m_173350_("CustomGlintTexture", (Object)j);
                RenderStateShard.TextureStateShard a = new RenderStateShard.TextureStateShard(customGlintTexture, true, false);
                return glintShader;
            })).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.m_173127_().m_173132_(TextureAtlas.f_118259_, false, false).m_173132_(MaterialAtlasManager.MATERIAL_ID, false, false).m_173131_()).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110671_(RenderStateShard.f_110152_).m_110687_(RenderStateShard.f_110115_).m_110683_(RenderType.f_110151_).m_110677_(RenderStateShard.f_110154_).m_110691_(false));
            TRANSLUCENT_NO_CULL = RenderType.m_173215_((String)"miapi_translucent_no_cull", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110671_(RenderStateShard.f_110152_).m_173292_(RenderStateShard.f_173108_).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.f_110145_).m_110685_(RenderStateShard.f_110139_).m_110675_(RenderStateShard.f_110125_).m_110661_(RenderStateShard.f_110110_).m_110691_(true));
        }
    }
}

