/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.a_man_with_plushies.network;

import java.util.function.Supplier;
import net.mcreator.a_man_with_plushies.AManWithPlushiesMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AManWithPlushiesModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        AManWithPlushiesMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        AManWithPlushiesMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.TotalPlushiesObtained = message.data.TotalPlushiesObtained;
                    variables.PeashooterPlushieObtained = message.data.PeashooterPlushieObtained;
                    variables.CrewmatePlushieObtained = message.data.CrewmatePlushieObtained;
                    variables.FreddyFazbearPlushieObtained = message.data.FreddyFazbearPlushieObtained;
                    variables.HeavyPlushieObtained = message.data.HeavyPlushieObtained;
                    variables.FallGuyPlushieObtained = message.data.FallGuyPlushieObtained;
                    variables.CreeperPlushieObtained = message.data.CreeperPlushieObtained;
                    variables.NoobPlushieObtained = message.data.NoobPlushieObtained;
                    variables.WilsonPlushieObtained = message.data.WilsonPlushieObtained;
                    variables.IsaacPlushieObtained = message.data.IsaacPlushieObtained;
                    variables.CompanionCubePlushieObtained = message.data.CompanionCubePlushieObtained;
                    variables.LariatPlushieObtained = message.data.LariatPlushieObtained;
                    variables.GLaDOSPlushieObtained = message.data.GLaDOSPlushieObtained;
                    variables.MeatBoyPlushieObtained = message.data.MeatBoyPlushieObtained;
                    variables.PopgoesPlushieObtained = message.data.PopgoesPlushieObtained;
                    variables.GDCubePlushieObtained = message.data.GDCubePlushieObtained;
                    variables.CupheadPlushieObtained = message.data.CupheadPlushieObtained;
                    variables.CandyPlushieObtained = message.data.CandyPlushieObtained;
                    variables.SansPlushieObtained = message.data.SansPlushieObtained;
                    variables.SpamtonPlushieObtained = message.data.SpamtonPlushieObtained;
                    variables.EndermanPlushieObtained = message.data.EndermanPlushieObtained;
                    variables.CCKnightPlushieObtained = message.data.CCKnightPlushieObtained;
                    variables.GoosePlushieObtained = message.data.GoosePlushieObtained;
                    variables.HenryStickiminPlushieObtained = message.data.HenryStickiminPlushieObtained;
                    variables.PigPlushieObtained = message.data.PigPlushieObtained;
                    variables.SheepPlushieObtained = message.data.SheepPlushieObtained;
                    variables.CowPlushieObtained = message.data.CowPlushieObtained;
                    variables.TheKnightPlushieObtained = message.data.TheKnightPlushieObtained;
                    variables.HeadcrabPlushieObtained = message.data.HeadcrabPlushieObtained;
                    variables.GhastPlushieObtained = message.data.GhastPlushieObtained;
                    variables.BaldiPlushieObtained = message.data.BaldiPlushieObtained;
                    variables.ChickenPlushieObtained = message.data.ChickenPlushieObtained;
                    variables.AllayPlushieObtained = message.data.AllayPlushieObtained;
                    variables.AudinoPlushieObtained = message.data.AudinoPlushieObtained;
                    variables.BlisseyPlushieObtained = message.data.BlisseyPlushieObtained;
                    variables.IndeedeePlushieObtained = message.data.IndeedeePlushieObtained;
                    variables.SudowoodoPlushieObtained = message.data.SudowoodoPlushieObtained;
                    variables.PikminPlushieObtained = message.data.PikminPlushieObtained;
                    variables.MadelinePlushieObtained = message.data.MadelinePlushieObtained;
                    variables.PeppinoPlushieObtained = message.data.PeppinoPlushieObtained;
                    variables.V1PlushieObtained = message.data.V1PlushieObtained;
                    variables.HappycanePlushieObtained = message.data.HappycanePlushieObtained;
                    variables.InsomniPlushieObtained = message.data.InsomniPlushieObtained;
                    variables.WiglinPlushieObtained = message.data.WiglinPlushieObtained;
                    variables.SteppaPlushieObtained = message.data.SteppaPlushieObtained;
                    variables.RhythPlushieObtained = message.data.RhythPlushieObtained;
                    variables.SenseiSeaweedPlushieObtained = message.data.SenseiSeaweedPlushieObtained;
                    variables.WobblewokPlushieObtained = message.data.WobblewokPlushieObtained;
                    variables.PufferfishPlushieObtained = message.data.PufferfishPlushieObtained;
                    variables.SquidPlushieObtained = message.data.SquidPlushieObtained;
                    variables.CrabsterPlushieObtained = message.data.CrabsterPlushieObtained;
                    variables.ShulkerPlushieObtained = message.data.ShulkerPlushieObtained;
                    variables.NinjiPlushieObtained = message.data.NinjiPlushieObtained;
                    variables.StickTipShown = message.data.StickTipShown;
                    variables.RatatinDialogueProgress = message.data.RatatinDialogueProgress;
                    variables.RatatinVoiceLineCooldown = message.data.RatatinVoiceLineCooldown;
                    variables.SpamtonVoiceLineCooldown = message.data.SpamtonVoiceLineCooldown;
                    variables.MoaiHintShown = message.data.MoaiHintShown;
                    variables.CoilHeadSpringCooldown = message.data.CoilHeadSpringCooldown;
                    variables.StevePlushieObtained = message.data.StevePlushieObtained;
                    variables.GuffPlushieObtained = message.data.GuffPlushieObtained;
                    variables.HatKidPlushieObtained = message.data.HatKidPlushieObtained;
                    variables.EmployeePlushieObtained = message.data.EmployeePlushieObtained;
                    variables.CoilHeadPlushieObtained = message.data.CoilHeadPlushieObtained;
                    variables.ShovelKnightPlushieObtained = message.data.ShovelKnightPlushieObtained;
                    variables.EyeOfCthulhuPlushieObtained = message.data.EyeOfCthulhuPlushieObtained;
                    variables.OmoriPlushieObtained = message.data.OmoriPlushieObtained;
                    variables.SackboyPlushieObtained = message.data.SackboyPlushieObtained;
                    variables.WheatleyPlushieObtained = message.data.WheatleyPlushieObtained;
                    variables.SpycrabPlushieObtained = message.data.SpycrabPlushieObtained;
                    variables.AnimdudePlushieObtained = message.data.AnimdudePlushieObtained;
                    variables.BendyPlushieObtained = message.data.BendyPlushieObtained;
                    variables.TheLambPlushieObtained = message.data.TheLambPlushieObtained;
                    variables.RoyaleKingPlushieObtained = message.data.RoyaleKingPlushieObtained;
                    variables.MonikaPlushieObtained = message.data.MonikaPlushieObtained;
                    variables.BoyfriendPlushieObtained = message.data.BoyfriendPlushieObtained;
                    variables.RambleyPlushieObtained = message.data.RambleyPlushieObtained;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double TotalPlushiesObtained = 0.0;
        public boolean PeashooterPlushieObtained = false;
        public boolean CrewmatePlushieObtained = false;
        public boolean FreddyFazbearPlushieObtained = false;
        public boolean HeavyPlushieObtained = false;
        public boolean FallGuyPlushieObtained = false;
        public boolean CreeperPlushieObtained = false;
        public boolean NoobPlushieObtained = false;
        public boolean WilsonPlushieObtained = false;
        public boolean IsaacPlushieObtained = false;
        public boolean CompanionCubePlushieObtained = false;
        public boolean LariatPlushieObtained = false;
        public boolean GLaDOSPlushieObtained = false;
        public boolean MeatBoyPlushieObtained = false;
        public boolean PopgoesPlushieObtained = false;
        public boolean GDCubePlushieObtained = false;
        public boolean CupheadPlushieObtained = false;
        public boolean CandyPlushieObtained = false;
        public boolean SansPlushieObtained = false;
        public boolean SpamtonPlushieObtained = false;
        public boolean EndermanPlushieObtained = false;
        public boolean CCKnightPlushieObtained = false;
        public boolean GoosePlushieObtained = false;
        public boolean HenryStickiminPlushieObtained = false;
        public boolean PigPlushieObtained = false;
        public boolean SheepPlushieObtained = false;
        public boolean CowPlushieObtained = false;
        public boolean TheKnightPlushieObtained = false;
        public boolean HeadcrabPlushieObtained = false;
        public boolean GhastPlushieObtained = false;
        public boolean BaldiPlushieObtained = false;
        public boolean ChickenPlushieObtained = false;
        public boolean AllayPlushieObtained = false;
        public boolean AudinoPlushieObtained = false;
        public boolean BlisseyPlushieObtained = false;
        public boolean IndeedeePlushieObtained = false;
        public boolean SudowoodoPlushieObtained = false;
        public boolean PikminPlushieObtained = false;
        public boolean MadelinePlushieObtained = false;
        public boolean PeppinoPlushieObtained = false;
        public boolean V1PlushieObtained = false;
        public boolean HappycanePlushieObtained = false;
        public boolean InsomniPlushieObtained = false;
        public boolean WiglinPlushieObtained = false;
        public boolean SteppaPlushieObtained = false;
        public boolean RhythPlushieObtained = false;
        public boolean SenseiSeaweedPlushieObtained = false;
        public boolean WobblewokPlushieObtained = false;
        public boolean PufferfishPlushieObtained = false;
        public boolean SquidPlushieObtained = false;
        public boolean CrabsterPlushieObtained = false;
        public boolean ShulkerPlushieObtained = false;
        public boolean NinjiPlushieObtained = false;
        public boolean StickTipShown = false;
        public double RatatinDialogueProgress = 0.0;
        public boolean RatatinVoiceLineCooldown = false;
        public boolean SpamtonVoiceLineCooldown = false;
        public boolean MoaiHintShown = false;
        public boolean CoilHeadSpringCooldown = false;
        public boolean StevePlushieObtained = false;
        public boolean GuffPlushieObtained = false;
        public boolean HatKidPlushieObtained = false;
        public boolean EmployeePlushieObtained = false;
        public boolean CoilHeadPlushieObtained = false;
        public boolean ShovelKnightPlushieObtained = false;
        public boolean EyeOfCthulhuPlushieObtained = false;
        public boolean OmoriPlushieObtained = false;
        public boolean SackboyPlushieObtained = false;
        public boolean WheatleyPlushieObtained = false;
        public boolean SpycrabPlushieObtained = false;
        public boolean AnimdudePlushieObtained = false;
        public boolean BendyPlushieObtained = false;
        public boolean TheLambPlushieObtained = false;
        public boolean RoyaleKingPlushieObtained = false;
        public boolean MonikaPlushieObtained = false;
        public boolean BoyfriendPlushieObtained = false;
        public boolean RambleyPlushieObtained = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                AManWithPlushiesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("TotalPlushiesObtained", this.TotalPlushiesObtained);
            nbt.m_128379_("PeashooterPlushieObtained", this.PeashooterPlushieObtained);
            nbt.m_128379_("CrewmatePlushieObtained", this.CrewmatePlushieObtained);
            nbt.m_128379_("FreddyFazbearPlushieObtained", this.FreddyFazbearPlushieObtained);
            nbt.m_128379_("HeavyPlushieObtained", this.HeavyPlushieObtained);
            nbt.m_128379_("FallGuyPlushieObtained", this.FallGuyPlushieObtained);
            nbt.m_128379_("CreeperPlushieObtained", this.CreeperPlushieObtained);
            nbt.m_128379_("NoobPlushieObtained", this.NoobPlushieObtained);
            nbt.m_128379_("WilsonPlushieObtained", this.WilsonPlushieObtained);
            nbt.m_128379_("IsaacPlushieObtained", this.IsaacPlushieObtained);
            nbt.m_128379_("CompanionCubePlushieObtained", this.CompanionCubePlushieObtained);
            nbt.m_128379_("LariatPlushieObtained", this.LariatPlushieObtained);
            nbt.m_128379_("GLaDOSPlushieObtained", this.GLaDOSPlushieObtained);
            nbt.m_128379_("MeatBoyPlushieObtained", this.MeatBoyPlushieObtained);
            nbt.m_128379_("PopgoesPlushieObtained", this.PopgoesPlushieObtained);
            nbt.m_128379_("GDCubePlushieObtained", this.GDCubePlushieObtained);
            nbt.m_128379_("CupheadPlushieObtained", this.CupheadPlushieObtained);
            nbt.m_128379_("CandyPlushieObtained", this.CandyPlushieObtained);
            nbt.m_128379_("SansPlushieObtained", this.SansPlushieObtained);
            nbt.m_128379_("SpamtonPlushieObtained", this.SpamtonPlushieObtained);
            nbt.m_128379_("EndermanPlushieObtained", this.EndermanPlushieObtained);
            nbt.m_128379_("CCKnightPlushieObtained", this.CCKnightPlushieObtained);
            nbt.m_128379_("GoosePlushieObtained", this.GoosePlushieObtained);
            nbt.m_128379_("HenryStickiminPlushieObtained", this.HenryStickiminPlushieObtained);
            nbt.m_128379_("PigPlushieObtained", this.PigPlushieObtained);
            nbt.m_128379_("SheepPlushieObtained", this.SheepPlushieObtained);
            nbt.m_128379_("CowPlushieObtained", this.CowPlushieObtained);
            nbt.m_128379_("TheKnightPlushieObtained", this.TheKnightPlushieObtained);
            nbt.m_128379_("HeadcrabPlushieObtained", this.HeadcrabPlushieObtained);
            nbt.m_128379_("GhastPlushieObtained", this.GhastPlushieObtained);
            nbt.m_128379_("BaldiPlushieObtained", this.BaldiPlushieObtained);
            nbt.m_128379_("ChickenPlushieObtained", this.ChickenPlushieObtained);
            nbt.m_128379_("AllayPlushieObtained", this.AllayPlushieObtained);
            nbt.m_128379_("AudinoPlushieObtained", this.AudinoPlushieObtained);
            nbt.m_128379_("BlisseyPlushieObtained", this.BlisseyPlushieObtained);
            nbt.m_128379_("IndeedeePlushieObtained", this.IndeedeePlushieObtained);
            nbt.m_128379_("SudowoodoPlushieObtained", this.SudowoodoPlushieObtained);
            nbt.m_128379_("PikminPlushieObtained", this.PikminPlushieObtained);
            nbt.m_128379_("MadelinePlushieObtained", this.MadelinePlushieObtained);
            nbt.m_128379_("PeppinoPlushieObtained", this.PeppinoPlushieObtained);
            nbt.m_128379_("V1PlushieObtained", this.V1PlushieObtained);
            nbt.m_128379_("HappycanePlushieObtained", this.HappycanePlushieObtained);
            nbt.m_128379_("InsomniPlushieObtained", this.InsomniPlushieObtained);
            nbt.m_128379_("WiglinPlushieObtained", this.WiglinPlushieObtained);
            nbt.m_128379_("SteppaPlushieObtained", this.SteppaPlushieObtained);
            nbt.m_128379_("RhythPlushieObtained", this.RhythPlushieObtained);
            nbt.m_128379_("SenseiSeaweedPlushieObtained", this.SenseiSeaweedPlushieObtained);
            nbt.m_128379_("WobblewokPlushieObtained", this.WobblewokPlushieObtained);
            nbt.m_128379_("PufferfishPlushieObtained", this.PufferfishPlushieObtained);
            nbt.m_128379_("SquidPlushieObtained", this.SquidPlushieObtained);
            nbt.m_128379_("CrabsterPlushieObtained", this.CrabsterPlushieObtained);
            nbt.m_128379_("ShulkerPlushieObtained", this.ShulkerPlushieObtained);
            nbt.m_128379_("NinjiPlushieObtained", this.NinjiPlushieObtained);
            nbt.m_128379_("StickTipShown", this.StickTipShown);
            nbt.m_128347_("RatatinDialogueProgress", this.RatatinDialogueProgress);
            nbt.m_128379_("RatatinVoiceLineCooldown", this.RatatinVoiceLineCooldown);
            nbt.m_128379_("SpamtonVoiceLineCooldown", this.SpamtonVoiceLineCooldown);
            nbt.m_128379_("MoaiHintShown", this.MoaiHintShown);
            nbt.m_128379_("CoilHeadSpringCooldown", this.CoilHeadSpringCooldown);
            nbt.m_128379_("StevePlushieObtained", this.StevePlushieObtained);
            nbt.m_128379_("GuffPlushieObtained", this.GuffPlushieObtained);
            nbt.m_128379_("HatKidPlushieObtained", this.HatKidPlushieObtained);
            nbt.m_128379_("EmployeePlushieObtained", this.EmployeePlushieObtained);
            nbt.m_128379_("CoilHeadPlushieObtained", this.CoilHeadPlushieObtained);
            nbt.m_128379_("ShovelKnightPlushieObtained", this.ShovelKnightPlushieObtained);
            nbt.m_128379_("EyeOfCthulhuPlushieObtained", this.EyeOfCthulhuPlushieObtained);
            nbt.m_128379_("OmoriPlushieObtained", this.OmoriPlushieObtained);
            nbt.m_128379_("SackboyPlushieObtained", this.SackboyPlushieObtained);
            nbt.m_128379_("WheatleyPlushieObtained", this.WheatleyPlushieObtained);
            nbt.m_128379_("SpycrabPlushieObtained", this.SpycrabPlushieObtained);
            nbt.m_128379_("AnimdudePlushieObtained", this.AnimdudePlushieObtained);
            nbt.m_128379_("BendyPlushieObtained", this.BendyPlushieObtained);
            nbt.m_128379_("TheLambPlushieObtained", this.TheLambPlushieObtained);
            nbt.m_128379_("RoyaleKingPlushieObtained", this.RoyaleKingPlushieObtained);
            nbt.m_128379_("MonikaPlushieObtained", this.MonikaPlushieObtained);
            nbt.m_128379_("BoyfriendPlushieObtained", this.BoyfriendPlushieObtained);
            nbt.m_128379_("RambleyPlushieObtained", this.RambleyPlushieObtained);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.TotalPlushiesObtained = nbt.m_128459_("TotalPlushiesObtained");
            this.PeashooterPlushieObtained = nbt.m_128471_("PeashooterPlushieObtained");
            this.CrewmatePlushieObtained = nbt.m_128471_("CrewmatePlushieObtained");
            this.FreddyFazbearPlushieObtained = nbt.m_128471_("FreddyFazbearPlushieObtained");
            this.HeavyPlushieObtained = nbt.m_128471_("HeavyPlushieObtained");
            this.FallGuyPlushieObtained = nbt.m_128471_("FallGuyPlushieObtained");
            this.CreeperPlushieObtained = nbt.m_128471_("CreeperPlushieObtained");
            this.NoobPlushieObtained = nbt.m_128471_("NoobPlushieObtained");
            this.WilsonPlushieObtained = nbt.m_128471_("WilsonPlushieObtained");
            this.IsaacPlushieObtained = nbt.m_128471_("IsaacPlushieObtained");
            this.CompanionCubePlushieObtained = nbt.m_128471_("CompanionCubePlushieObtained");
            this.LariatPlushieObtained = nbt.m_128471_("LariatPlushieObtained");
            this.GLaDOSPlushieObtained = nbt.m_128471_("GLaDOSPlushieObtained");
            this.MeatBoyPlushieObtained = nbt.m_128471_("MeatBoyPlushieObtained");
            this.PopgoesPlushieObtained = nbt.m_128471_("PopgoesPlushieObtained");
            this.GDCubePlushieObtained = nbt.m_128471_("GDCubePlushieObtained");
            this.CupheadPlushieObtained = nbt.m_128471_("CupheadPlushieObtained");
            this.CandyPlushieObtained = nbt.m_128471_("CandyPlushieObtained");
            this.SansPlushieObtained = nbt.m_128471_("SansPlushieObtained");
            this.SpamtonPlushieObtained = nbt.m_128471_("SpamtonPlushieObtained");
            this.EndermanPlushieObtained = nbt.m_128471_("EndermanPlushieObtained");
            this.CCKnightPlushieObtained = nbt.m_128471_("CCKnightPlushieObtained");
            this.GoosePlushieObtained = nbt.m_128471_("GoosePlushieObtained");
            this.HenryStickiminPlushieObtained = nbt.m_128471_("HenryStickiminPlushieObtained");
            this.PigPlushieObtained = nbt.m_128471_("PigPlushieObtained");
            this.SheepPlushieObtained = nbt.m_128471_("SheepPlushieObtained");
            this.CowPlushieObtained = nbt.m_128471_("CowPlushieObtained");
            this.TheKnightPlushieObtained = nbt.m_128471_("TheKnightPlushieObtained");
            this.HeadcrabPlushieObtained = nbt.m_128471_("HeadcrabPlushieObtained");
            this.GhastPlushieObtained = nbt.m_128471_("GhastPlushieObtained");
            this.BaldiPlushieObtained = nbt.m_128471_("BaldiPlushieObtained");
            this.ChickenPlushieObtained = nbt.m_128471_("ChickenPlushieObtained");
            this.AllayPlushieObtained = nbt.m_128471_("AllayPlushieObtained");
            this.AudinoPlushieObtained = nbt.m_128471_("AudinoPlushieObtained");
            this.BlisseyPlushieObtained = nbt.m_128471_("BlisseyPlushieObtained");
            this.IndeedeePlushieObtained = nbt.m_128471_("IndeedeePlushieObtained");
            this.SudowoodoPlushieObtained = nbt.m_128471_("SudowoodoPlushieObtained");
            this.PikminPlushieObtained = nbt.m_128471_("PikminPlushieObtained");
            this.MadelinePlushieObtained = nbt.m_128471_("MadelinePlushieObtained");
            this.PeppinoPlushieObtained = nbt.m_128471_("PeppinoPlushieObtained");
            this.V1PlushieObtained = nbt.m_128471_("V1PlushieObtained");
            this.HappycanePlushieObtained = nbt.m_128471_("HappycanePlushieObtained");
            this.InsomniPlushieObtained = nbt.m_128471_("InsomniPlushieObtained");
            this.WiglinPlushieObtained = nbt.m_128471_("WiglinPlushieObtained");
            this.SteppaPlushieObtained = nbt.m_128471_("SteppaPlushieObtained");
            this.RhythPlushieObtained = nbt.m_128471_("RhythPlushieObtained");
            this.SenseiSeaweedPlushieObtained = nbt.m_128471_("SenseiSeaweedPlushieObtained");
            this.WobblewokPlushieObtained = nbt.m_128471_("WobblewokPlushieObtained");
            this.PufferfishPlushieObtained = nbt.m_128471_("PufferfishPlushieObtained");
            this.SquidPlushieObtained = nbt.m_128471_("SquidPlushieObtained");
            this.CrabsterPlushieObtained = nbt.m_128471_("CrabsterPlushieObtained");
            this.ShulkerPlushieObtained = nbt.m_128471_("ShulkerPlushieObtained");
            this.NinjiPlushieObtained = nbt.m_128471_("NinjiPlushieObtained");
            this.StickTipShown = nbt.m_128471_("StickTipShown");
            this.RatatinDialogueProgress = nbt.m_128459_("RatatinDialogueProgress");
            this.RatatinVoiceLineCooldown = nbt.m_128471_("RatatinVoiceLineCooldown");
            this.SpamtonVoiceLineCooldown = nbt.m_128471_("SpamtonVoiceLineCooldown");
            this.MoaiHintShown = nbt.m_128471_("MoaiHintShown");
            this.CoilHeadSpringCooldown = nbt.m_128471_("CoilHeadSpringCooldown");
            this.StevePlushieObtained = nbt.m_128471_("StevePlushieObtained");
            this.GuffPlushieObtained = nbt.m_128471_("GuffPlushieObtained");
            this.HatKidPlushieObtained = nbt.m_128471_("HatKidPlushieObtained");
            this.EmployeePlushieObtained = nbt.m_128471_("EmployeePlushieObtained");
            this.CoilHeadPlushieObtained = nbt.m_128471_("CoilHeadPlushieObtained");
            this.ShovelKnightPlushieObtained = nbt.m_128471_("ShovelKnightPlushieObtained");
            this.EyeOfCthulhuPlushieObtained = nbt.m_128471_("EyeOfCthulhuPlushieObtained");
            this.OmoriPlushieObtained = nbt.m_128471_("OmoriPlushieObtained");
            this.SackboyPlushieObtained = nbt.m_128471_("SackboyPlushieObtained");
            this.WheatleyPlushieObtained = nbt.m_128471_("WheatleyPlushieObtained");
            this.SpycrabPlushieObtained = nbt.m_128471_("SpycrabPlushieObtained");
            this.AnimdudePlushieObtained = nbt.m_128471_("AnimdudePlushieObtained");
            this.BendyPlushieObtained = nbt.m_128471_("BendyPlushieObtained");
            this.TheLambPlushieObtained = nbt.m_128471_("TheLambPlushieObtained");
            this.RoyaleKingPlushieObtained = nbt.m_128471_("RoyaleKingPlushieObtained");
            this.MonikaPlushieObtained = nbt.m_128471_("MonikaPlushieObtained");
            this.BoyfriendPlushieObtained = nbt.m_128471_("BoyfriendPlushieObtained");
            this.RambleyPlushieObtained = nbt.m_128471_("RambleyPlushieObtained");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("a_man_with_plushies", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "a_man_with_plushies_mapvars";
        public boolean AllPlushiesObtained = false;
        public boolean HerobrineLightingCooldown = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.AllPlushiesObtained = nbt.m_128471_("AllPlushiesObtained");
            this.HerobrineLightingCooldown = nbt.m_128471_("HerobrineLightingCooldown");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("AllPlushiesObtained", this.AllPlushiesObtained);
            nbt.m_128379_("HerobrineLightingCooldown", this.HerobrineLightingCooldown);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                AManWithPlushiesMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "a_man_with_plushies_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                AManWithPlushiesMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.TotalPlushiesObtained = original.TotalPlushiesObtained;
            clone.PeashooterPlushieObtained = original.PeashooterPlushieObtained;
            clone.CrewmatePlushieObtained = original.CrewmatePlushieObtained;
            clone.FreddyFazbearPlushieObtained = original.FreddyFazbearPlushieObtained;
            clone.HeavyPlushieObtained = original.HeavyPlushieObtained;
            clone.FallGuyPlushieObtained = original.FallGuyPlushieObtained;
            clone.CreeperPlushieObtained = original.CreeperPlushieObtained;
            clone.NoobPlushieObtained = original.NoobPlushieObtained;
            clone.WilsonPlushieObtained = original.WilsonPlushieObtained;
            clone.IsaacPlushieObtained = original.IsaacPlushieObtained;
            clone.CompanionCubePlushieObtained = original.CompanionCubePlushieObtained;
            clone.LariatPlushieObtained = original.LariatPlushieObtained;
            clone.GLaDOSPlushieObtained = original.GLaDOSPlushieObtained;
            clone.MeatBoyPlushieObtained = original.MeatBoyPlushieObtained;
            clone.PopgoesPlushieObtained = original.PopgoesPlushieObtained;
            clone.GDCubePlushieObtained = original.GDCubePlushieObtained;
            clone.CupheadPlushieObtained = original.CupheadPlushieObtained;
            clone.CandyPlushieObtained = original.CandyPlushieObtained;
            clone.SansPlushieObtained = original.SansPlushieObtained;
            clone.SpamtonPlushieObtained = original.SpamtonPlushieObtained;
            clone.EndermanPlushieObtained = original.EndermanPlushieObtained;
            clone.CCKnightPlushieObtained = original.CCKnightPlushieObtained;
            clone.GoosePlushieObtained = original.GoosePlushieObtained;
            clone.HenryStickiminPlushieObtained = original.HenryStickiminPlushieObtained;
            clone.PigPlushieObtained = original.PigPlushieObtained;
            clone.SheepPlushieObtained = original.SheepPlushieObtained;
            clone.CowPlushieObtained = original.CowPlushieObtained;
            clone.TheKnightPlushieObtained = original.TheKnightPlushieObtained;
            clone.HeadcrabPlushieObtained = original.HeadcrabPlushieObtained;
            clone.GhastPlushieObtained = original.GhastPlushieObtained;
            clone.BaldiPlushieObtained = original.BaldiPlushieObtained;
            clone.ChickenPlushieObtained = original.ChickenPlushieObtained;
            clone.AllayPlushieObtained = original.AllayPlushieObtained;
            clone.AudinoPlushieObtained = original.AudinoPlushieObtained;
            clone.BlisseyPlushieObtained = original.BlisseyPlushieObtained;
            clone.IndeedeePlushieObtained = original.IndeedeePlushieObtained;
            clone.SudowoodoPlushieObtained = original.SudowoodoPlushieObtained;
            clone.PikminPlushieObtained = original.PikminPlushieObtained;
            clone.MadelinePlushieObtained = original.MadelinePlushieObtained;
            clone.PeppinoPlushieObtained = original.PeppinoPlushieObtained;
            clone.V1PlushieObtained = original.V1PlushieObtained;
            clone.HappycanePlushieObtained = original.HappycanePlushieObtained;
            clone.InsomniPlushieObtained = original.InsomniPlushieObtained;
            clone.WiglinPlushieObtained = original.WiglinPlushieObtained;
            clone.SteppaPlushieObtained = original.SteppaPlushieObtained;
            clone.RhythPlushieObtained = original.RhythPlushieObtained;
            clone.SenseiSeaweedPlushieObtained = original.SenseiSeaweedPlushieObtained;
            clone.WobblewokPlushieObtained = original.WobblewokPlushieObtained;
            clone.PufferfishPlushieObtained = original.PufferfishPlushieObtained;
            clone.SquidPlushieObtained = original.SquidPlushieObtained;
            clone.CrabsterPlushieObtained = original.CrabsterPlushieObtained;
            clone.ShulkerPlushieObtained = original.ShulkerPlushieObtained;
            clone.NinjiPlushieObtained = original.NinjiPlushieObtained;
            clone.StickTipShown = original.StickTipShown;
            clone.RatatinDialogueProgress = original.RatatinDialogueProgress;
            clone.RatatinVoiceLineCooldown = original.RatatinVoiceLineCooldown;
            clone.SpamtonVoiceLineCooldown = original.SpamtonVoiceLineCooldown;
            clone.MoaiHintShown = original.MoaiHintShown;
            clone.CoilHeadSpringCooldown = original.CoilHeadSpringCooldown;
            clone.StevePlushieObtained = original.StevePlushieObtained;
            clone.GuffPlushieObtained = original.GuffPlushieObtained;
            clone.HatKidPlushieObtained = original.HatKidPlushieObtained;
            clone.EmployeePlushieObtained = original.EmployeePlushieObtained;
            clone.CoilHeadPlushieObtained = original.CoilHeadPlushieObtained;
            clone.ShovelKnightPlushieObtained = original.ShovelKnightPlushieObtained;
            clone.EyeOfCthulhuPlushieObtained = original.EyeOfCthulhuPlushieObtained;
            clone.OmoriPlushieObtained = original.OmoriPlushieObtained;
            clone.SackboyPlushieObtained = original.SackboyPlushieObtained;
            clone.WheatleyPlushieObtained = original.WheatleyPlushieObtained;
            clone.SpycrabPlushieObtained = original.SpycrabPlushieObtained;
            clone.AnimdudePlushieObtained = original.AnimdudePlushieObtained;
            clone.BendyPlushieObtained = original.BendyPlushieObtained;
            clone.TheLambPlushieObtained = original.TheLambPlushieObtained;
            clone.RoyaleKingPlushieObtained = original.RoyaleKingPlushieObtained;
            clone.MonikaPlushieObtained = original.MonikaPlushieObtained;
            clone.BoyfriendPlushieObtained = original.BoyfriendPlushieObtained;
            clone.RambleyPlushieObtained = original.RambleyPlushieObtained;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    AManWithPlushiesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    AManWithPlushiesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                AManWithPlushiesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

