/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emitrades;

import com.google.common.collect.ImmutableSet;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import io.github.prismwork.emitrades.config.EMITradesConfig;
import io.github.prismwork.emitrades.recipe.VillagerTrade;
import io.github.prismwork.emitrades.util.EntityEmiStack;
import io.github.prismwork.emitrades.util.TradeProfile;
import io.github.prismwork.emitrades.util.XPlatUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.File;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EmiEntrypoint
public class EMITradesPlugin
implements EmiPlugin {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"EMI Trades");
    public static final VillagerProfession WANDERING_TRADER_PLACEHOLDER = new VillagerProfession("wandering_trader", entry -> false, entry -> false, ImmutableSet.builder().build(), ImmutableSet.builder().build(), SoundEvents.f_12539_);
    public static final EmiRecipeCategory VILLAGER_TRADES = new EmiRecipeCategory(new ResourceLocation("emitrades", "villager_trades"), (EmiRenderable)EmiStack.of((ItemLike)Items.f_42616_));
    public static EMITradesConfig.Config CONFIG;
    private static final File CONFIG_FILE;

    public void register(EmiRegistry registry) {
        CONFIG = EMITradesConfig.load(CONFIG_FILE);
        registry.addCategory(VILLAGER_TRADES);
        RandomSource random = RandomSource.m_216327_();
        for (VillagerProfession profession : BuiltInRegistries.f_256735_) {
            Villager villager = (Villager)((EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation("minecraft", "villager"))).m_20615_((Level)Minecraft.m_91087_().f_91073_);
            if (villager != null) {
                villager.m_34375_(villager.m_7141_().m_35565_(profession).m_35561_(5));
                registry.addWorkstation(VILLAGER_TRADES, (EmiIngredient)EntityEmiStack.ofScaled((Entity)villager, 8.0f));
            }
            AtomicInteger id = new AtomicInteger();
            Int2ObjectMap offers2 = (Int2ObjectMap)VillagerTrades.f_35627_.get(profession);
            if (offers2 == null || offers2.isEmpty()) continue;
            for (int level = 0; level < 5; ++level) {
                Villager villager1 = (Villager)((EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation("minecraft", "villager"))).m_20615_((Level)Minecraft.m_91087_().f_91073_);
                if (villager1 != null) {
                    villager1.m_34375_(villager1.m_7141_().m_35565_(profession).m_35561_(level + 1));
                }
                for (VillagerTrades.ItemListing offer : (VillagerTrades.ItemListing[])offers2.get(level + 1)) {
                    if (EMITradesPlugin.isVanillaFactory(offer)) {
                        registry.addRecipe((EmiRecipe)new VillagerTrade(new TradeProfile.DefaultImpl(profession, offer, level + 1, (AbstractVillager)villager1), id.get()));
                        id.getAndIncrement();
                        continue;
                    }
                    try {
                        int attempts = 5;
                        TreeSet<MerchantOffer> genOffers = new TreeSet<MerchantOffer>(this::compareOffers);
                        while (attempts > 0) {
                            MerchantOffer inOffer = offer.m_213663_((Entity)Minecraft.m_91087_().f_91074_, random);
                            if (genOffers.add(inOffer)) {
                                ++attempts;
                                continue;
                            }
                            --attempts;
                        }
                        int finalLevel = level;
                        genOffers.forEach(tradeOffer -> {
                            registry.addRecipe((EmiRecipe)new VillagerTrade(new TradeProfile.DefaultImpl(profession, new FakeFactory((MerchantOffer)tradeOffer), finalLevel + 1, (AbstractVillager)villager1), id.get()));
                            id.getAndIncrement();
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        WanderingTrader wanderingTrader = (WanderingTrader)((EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation("minecraft", "wandering_trader"))).m_20615_((Level)Minecraft.m_91087_().f_91073_);
        registry.addWorkstation(VILLAGER_TRADES, (EmiIngredient)EntityEmiStack.of((Entity)wanderingTrader));
        AtomicInteger wanderingTraderId = new AtomicInteger();
        VillagerTrades.f_35628_.forEach((lvl, offers) -> {
            for (VillagerTrades.ItemListing offer : offers) {
                if (EMITradesPlugin.isVanillaFactory(offer)) {
                    registry.addRecipe((EmiRecipe)new VillagerTrade(new TradeProfile.DefaultImpl(WANDERING_TRADER_PLACEHOLDER, offer, (int)lvl, (AbstractVillager)wanderingTrader), wanderingTraderId.get()));
                    wanderingTraderId.getAndIncrement();
                    continue;
                }
                try {
                    int attempts = 5;
                    TreeSet<MerchantOffer> genOffers = new TreeSet<MerchantOffer>(this::compareOffers);
                    while (attempts > 0) {
                        MerchantOffer inOffer = offer.m_213663_((Entity)Minecraft.m_91087_().f_91074_, random);
                        if (genOffers.add(inOffer)) {
                            ++attempts;
                            continue;
                        }
                        --attempts;
                    }
                    int finalLevel = lvl;
                    genOffers.forEach(tradeOffer -> {
                        registry.addRecipe((EmiRecipe)new VillagerTrade(new TradeProfile.DefaultImpl(WANDERING_TRADER_PLACEHOLDER, new FakeFactory((MerchantOffer)tradeOffer), finalLevel, (AbstractVillager)wanderingTrader), wanderingTraderId.get()));
                        wanderingTraderId.getAndIncrement();
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        LOGGER.info("Reloaded.");
    }

    private static boolean isVanillaFactory(VillagerTrades.ItemListing offer) {
        return offer instanceof VillagerTrades.SuspiciousStewForEmerald || offer instanceof VillagerTrades.EnchantedItemForEmeralds || offer instanceof VillagerTrades.EnchantBookForEmeralds || offer instanceof VillagerTrades.TreasureMapForEmeralds || offer instanceof VillagerTrades.TippedArrowForItemsAndEmeralds || offer instanceof VillagerTrades.DyedArmorForEmeralds || offer instanceof VillagerTrades.EmeraldsForVillagerTypeItem || offer instanceof VillagerTrades.ItemsForEmeralds || offer instanceof VillagerTrades.EmeraldForItems || offer instanceof VillagerTrades.ItemsAndEmeraldsToItems;
    }

    private int compareOffers(@NotNull MerchantOffer a, @NotNull MerchantOffer b) {
        int diff = BuiltInRegistries.f_257033_.m_7447_((Object)a.m_45352_().m_41720_()) - BuiltInRegistries.f_257033_.m_7447_((Object)b.m_45352_().m_41720_());
        if (diff != 0) {
            return diff;
        }
        diff = BuiltInRegistries.f_257033_.m_7447_((Object)a.m_45364_().m_41720_()) - BuiltInRegistries.f_257033_.m_7447_((Object)b.m_45364_().m_41720_());
        if (diff != 0) {
            return diff;
        }
        diff = BuiltInRegistries.f_257033_.m_7447_((Object)a.m_45368_().m_41720_()) - BuiltInRegistries.f_257033_.m_7447_((Object)b.m_45368_().m_41720_());
        return diff;
    }

    static {
        CONFIG_FILE = XPlatUtils.getConfigPath().resolve("emitrades.json5").toFile();
    }

    @ApiStatus.Internal
    public static class FakeFactory
    implements VillagerTrades.ItemListing {
        public final ItemStack first;
        public final ItemStack second;
        public final ItemStack sell;

        public FakeFactory(MerchantOffer offer) {
            this.first = offer.m_45352_();
            this.second = offer.m_45364_();
            this.sell = offer.m_45368_();
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            throw new AssertionError((Object)"Nobody should use this");
        }
    }
}

