/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.central;

import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.FrequencyBlockEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface Frequencing {
    default public CompoundTag setFrequency(ItemStack stack, String frequencyName, Frequency.Modulation modulation) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("frequency", frequencyName);
        tag.m_128359_("modulation", modulation.shorthand);
        return tag;
    }

    default public void setFrequency(BlockEntity blockEntity, String frequencyName, Frequency.Modulation modulation) {
        this.setFrequency(blockEntity, Frequency.getOrCreateFrequency(frequencyName, modulation));
    }

    default public void setFrequency(BlockEntity blockEntity, Frequency frequency) {
        if (blockEntity instanceof FrequencyBlockEntity) {
            FrequencyBlockEntity frequencyBlockEntity = (FrequencyBlockEntity)blockEntity;
            frequencyBlockEntity.frequency = frequency;
        }
    }

    default public Frequency getFrequency(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("frequency") || !tag.m_128441_("modulation")) {
            return null;
        }
        String frequencyName = tag.m_128461_("frequency");
        Frequency.Modulation modulation = Frequency.modulationOf(tag.m_128461_("modulation"));
        return Frequency.getOrCreateFrequency(frequencyName, modulation);
    }

    default public Frequency getFrequency(BlockEntity blockEntity) {
        if (blockEntity instanceof FrequencyBlockEntity) {
            FrequencyBlockEntity frequencyBlockEntity = (FrequencyBlockEntity)blockEntity;
            return frequencyBlockEntity.frequency;
        }
        return null;
    }

    default public String getDefaultFrequency() {
        return Frequency.DEFAULT_FREQUENCY;
    }

    default public Frequency.Modulation getDefaultModulation() {
        return Frequency.DEFAULT_MODULATION;
    }

    default public boolean validate(String frequency, Frequency.Modulation modulation, UUID owner) {
        if (frequency == null) {
            return false;
        }
        if (modulation == null) {
            return false;
        }
        return this.validate(Frequency.getOrCreateFrequency(frequency, modulation), owner);
    }

    default public boolean validate(Frequency frequency, UUID owner) {
        return frequency.getChannel(owner) != null;
    }

    default public void tick(ItemStack stack, Level level) {
        if (level.f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("frequency") || tag.m_128461_("frequency").isEmpty()) {
            this.setFrequency(stack, this.getDefaultFrequency(), this.getDefaultModulation());
        }
    }

    default public void appendTooltip(ItemStack stack, List<Component> components) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("frequency")) {
            components.add((Component)Component.m_237113_((String)(tag.m_128461_("frequency") + tag.m_128461_("modulation"))).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (Screen.m_96638_() && tag.m_128441_("user")) {
            components.add((Component)Component.m_237110_((String)"tooltip.simpleradio.receiver_user", (Object[])new Object[]{tag.m_128342_("user")}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }
}

