/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.central;

import com.codinglitch.simpleradio.core.central.Frequencing;
import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import com.codinglitch.simpleradio.radio.CommonRadioPlugin;
import com.codinglitch.simpleradio.radio.RadioChannel;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface Receiving
extends Frequencing {
    public static boolean validateReceiver(WorldlyPosition position, @Nullable Frequency frequency) {
        BlockPos pos = position.realLocation();
        if (!position.level.m_46749_(pos)) {
            return false;
        }
        BlockState state = position.level.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        BlockEntity blockEntity = position.level.m_7702_(pos);
        Item item = state.m_60734_().m_5456_();
        if (item instanceof Receiving) {
            Receiving receiving = (Receiving)item;
            return frequency == null || receiving.getFrequency(blockEntity) == frequency;
        }
        return false;
    }

    public static boolean validateReceiver(UUID uuid, @Nullable Frequency frequency) {
        VoicechatConnection connection = CommonRadioPlugin.serverApi.getConnectionOf(uuid);
        if (connection != null) {
            return Receiving.validateReceiver(connection, frequency);
        }
        return false;
    }

    public static boolean validateReceiver(VoicechatConnection connection, @Nullable Frequency frequency) {
        ServerPlayer player = (ServerPlayer)connection.getPlayer().getPlayer();
        if (player == null) {
            return false;
        }
        return Receiving.validateReceiver(player, frequency);
    }

    public static boolean validateReceiver(ServerPlayer player, @Nullable Frequency frequency) {
        return player.m_150109_().m_216874_(stack -> {
            Item patt1850$temp = stack.m_41720_();
            if (patt1850$temp instanceof Receiving) {
                Receiving receiving = (Receiving)patt1850$temp;
                return frequency == null || receiving.getFrequency((ItemStack)stack) == frequency;
            }
            return false;
        });
    }

    default public RadioChannel startReceiving(String frequencyName, Frequency.Modulation modulation, UUID owner) {
        Frequency frequency = Frequency.getOrCreateFrequency(frequencyName, modulation);
        return frequency.tryAddReceiver(owner);
    }

    default public void stopReceiving(String frequencyName, Frequency.Modulation modulation, UUID owner) {
        Frequency frequency = Frequency.getOrCreateFrequency(frequencyName, modulation);
        frequency.removeReceiver(owner);
    }
}

