/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.central;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WorldlyPosition
extends Vector3f {
    public Level level;
    private final BlockPos realLocation;

    public WorldlyPosition(float x, float y, float z, Level level, BlockPos realLocation) {
        super(x, y, z);
        this.level = level;
        this.realLocation = realLocation;
    }

    public WorldlyPosition(float x, float y, float z, Level level) {
        this(x, y, z, level, null);
    }

    public WorldlyPosition() {
        this(0.0f, 0.0f, 0.0f, null, null);
    }

    public static WorldlyPosition of(BlockPos pos, Level level, BlockPos realLocation) {
        return new WorldlyPosition(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), level, realLocation);
    }

    public static WorldlyPosition of(BlockPos pos, Level level) {
        return new WorldlyPosition(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), level);
    }

    public static WorldlyPosition of(Vector3f pos, Level level, BlockPos realLocation) {
        return new WorldlyPosition(pos.x, pos.y, pos.z, level, realLocation);
    }

    public static WorldlyPosition of(Vector3f pos, Level level) {
        return new WorldlyPosition(pos.x, pos.y, pos.z, level);
    }

    public Vector3f position() {
        return this;
    }

    public boolean equals(WorldlyPosition location) {
        return location.level == this.level && location.position() == this.position();
    }

    public BlockPos blockPos() {
        return new BlockPos(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public BlockPos realLocation() {
        return this.realLocation == null ? this.blockPos() : this.realLocation;
    }

    public Vector3f dimensionScaled() {
        return this.position().mul((float)this.level.m_6042_().f_63859_());
    }

    public float distance(WorldlyPosition other) {
        return this.dimensionScaled().distance((Vector3fc)other.dimensionScaled());
    }
}

