/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.radio.RadioChannel;
import com.codinglitch.simpleradio.radio.RadioListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FrequencerBlockEntity
extends BlockEntity {
    public Frequency frequency;
    public List<String> listeners = new ArrayList<String>();
    public List<String> receivers = new ArrayList<String>();
    public List<String> frequencies = new ArrayList<String>();

    public FrequencerBlockEntity(BlockPos pos, BlockState state) {
        super(SimpleRadioBlockEntities.FREQUENCER, pos, state);
    }

    private static String parse(@Nullable Entity owner, WorldlyPosition location) {
        if (owner == null) {
            BlockPos blockPos = location.blockPos();
            BlockEntity listenerBlock = location.level.m_7702_(blockPos);
            if (listenerBlock != null) {
                return listenerBlock.m_58900_().m_60734_().m_49954_().getString() + " at " + blockPos.m_123344_();
            }
        } else {
            return owner.m_5446_().getString();
        }
        return null;
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, FrequencerBlockEntity blockEntity) {
        if (Math.round(level.m_46467_()) % 20 == 0 && !level.f_46443_) {
            Object frequency;
            blockEntity.frequencies.clear();
            blockEntity.listeners.clear();
            blockEntity.receivers.clear();
            if (blockEntity.frequency != null && (frequency = Frequency.getFrequency(blockEntity.frequency.frequency, blockEntity.frequency.modulation)) != blockEntity.frequency && frequency != null) {
                blockEntity.frequency = frequency;
            }
            if (blockEntity.frequency != null) {
                for (RadioChannel receiver : blockEntity.frequency.receivers) {
                    Player player = level.m_46003_(receiver.owner);
                    String name = FrequencerBlockEntity.parse((Entity)player, receiver.location);
                    if (name == null) continue;
                    blockEntity.receivers.add(name);
                }
                level.m_7260_(pos, blockState, blockState, 2);
            } else {
                if (level.m_8055_(blockEntity.m_58899_().m_7495_()).m_60713_(Blocks.f_50090_)) {
                    List<RadioListener> listeners = RadioListener.getListeners();
                    for (RadioListener listener : listeners) {
                        String name = FrequencerBlockEntity.parse(listener.owner, listener.location);
                        if (name == null) continue;
                        blockEntity.listeners.add(name);
                    }
                } else {
                    List<Frequency> frequencies = Frequency.getFrequencies();
                    for (Frequency frequency2 : frequencies) {
                        blockEntity.frequencies.add(frequency2.frequency + frequency2.modulation.shorthand);
                    }
                }
                level.m_7260_(pos, blockState, blockState, 2);
            }
        }
    }

    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.saveTag(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        CompoundTag tag = new CompoundTag();
        this.saveTag(tag);
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, blockEntity -> tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadTag(tag);
    }

    public void m_183515_(CompoundTag tag) {
        this.saveTag(tag);
        super.m_183515_(tag);
    }

    public void m_187476_(ItemStack stack) {
        this.saveTag(stack.m_41784_());
        super.m_187476_(stack);
    }

    public void loadTag(CompoundTag tag) {
        if (tag.m_128441_("frequency")) {
            String frequencyName = tag.m_128461_("frequency");
            Frequency.Modulation modulation = Frequency.modulationOf(tag.m_128461_("modulation"));
            this.frequency = Frequency.getOrCreateFrequency(frequencyName, modulation);
        } else {
            this.frequency = null;
        }
        CompoundTag receivers = tag.m_128469_("receivers");
        this.receivers.clear();
        for (Object key : receivers.m_128431_()) {
            this.receivers.add(receivers.m_128461_((String)key));
        }
        CompoundTag listeners = tag.m_128469_("listeners");
        this.listeners.clear();
        for (String key : listeners.m_128431_()) {
            this.listeners.add(listeners.m_128461_(key));
        }
        CompoundTag frequencies = tag.m_128469_("frequencies");
        this.frequencies.clear();
        for (String key : frequencies.m_128431_()) {
            this.frequencies.add(frequencies.m_128461_(key));
        }
    }

    public void saveTag(CompoundTag tag) {
        if (this.frequency != null) {
            tag.m_128359_("frequency", this.frequency.frequency);
            tag.m_128359_("modulation", this.frequency.modulation.shorthand);
        }
        CompoundTag receivers = new CompoundTag();
        for (int i = 0; i < this.receivers.size(); ++i) {
            receivers.m_128359_(String.valueOf(i), this.receivers.get(i));
        }
        tag.m_128365_("receivers", (Tag)receivers);
        CompoundTag listeners = new CompoundTag();
        for (int i = 0; i < this.listeners.size(); ++i) {
            listeners.m_128359_(String.valueOf(i), this.listeners.get(i));
        }
        tag.m_128365_("listeners", (Tag)listeners);
        CompoundTag frequencies = new CompoundTag();
        for (int i = 0; i < this.frequencies.size(); ++i) {
            frequencies.m_128359_(String.valueOf(i), this.frequencies.get(i));
        }
        tag.m_128365_("frequencies", (Tag)frequencies);
    }
}

