/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.FrequencyBlockEntity;
import com.codinglitch.simpleradio.core.central.Receiving;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioChannel;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RadioBlockEntity
extends FrequencyBlockEntity
implements Receiving {
    public boolean isListening = false;
    public UUID listenerID = UUID.randomUUID();
    private RadioChannel channel;

    public RadioBlockEntity(BlockPos pos, BlockState state) {
        super(SimpleRadioBlockEntities.RADIO, pos, state);
    }

    public void m_7651_() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.channel != null) {
            this.f_58857_.m_6263_(null, (double)this.channel.location.x, (double)this.channel.location.y, (double)this.channel.location.z, SimpleRadioSounds.RADIO_CLOSE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (this.frequency != null) {
            this.stopReceiving(this.frequency.frequency, this.frequency.modulation, this.listenerID);
        }
        super.m_7651_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadTag(tag);
    }

    public void m_183515_(CompoundTag tag) {
        this.saveTag(tag);
        super.m_183515_(tag);
    }

    public void m_187476_(ItemStack stack) {
        this.saveTag(stack.m_41784_());
        super.m_187476_(stack);
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, RadioBlockEntity blockEntity) {
        if (!level.f_46443_ && blockEntity.frequency != null && !blockEntity.isListening) {
            blockEntity.listen();
        }
    }

    public void listen() {
        this.channel = this.startReceiving(this.frequency.frequency, this.frequency.modulation, this.listenerID);
        this.channel.location = Services.COMPAT.modifyPosition(Services.COMPAT.modifyPosition(WorldlyPosition.of(this.f_58858_, this.f_58857_, this.f_58858_)));
        this.f_58857_.m_6263_(null, (double)this.channel.location.x, (double)this.channel.location.y, (double)this.channel.location.z, SimpleRadioSounds.RADIO_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.isListening = true;
    }

    public void loadFromItem(ItemStack stack) {
        this.loadTag(stack.m_41784_());
    }

    public void loadTag(CompoundTag tag) {
        if (this.frequency != null) {
            this.stopReceiving(this.frequency.frequency, this.frequency.modulation, this.listenerID);
            this.isListening = false;
        }
        String frequencyName = tag.m_128461_("frequency");
        Frequency.Modulation modulation = Frequency.modulationOf(tag.m_128461_("modulation"));
        this.frequency = Frequency.getOrCreateFrequency(frequencyName, modulation);
    }

    public void saveTag(CompoundTag tag) {
        if (this.frequency == null) {
            return;
        }
        tag.m_128359_("frequency", this.frequency.frequency);
        tag.m_128359_("modulation", this.frequency.modulation.shorthand);
    }
}

