/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.items;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.Receiving;
import com.codinglitch.simpleradio.core.central.Transmitting;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundRadioPacket;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.core.registry.items.WalkieTalkieItem;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioListener;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioSource;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TransceiverItem
extends Item
implements Receiving,
Transmitting {
    public TransceiverItem(Item.Properties settings) {
        super(settings);
    }

    private void transmit(ServerPlayer player, boolean started) {
        Services.NETWORKING.sendToPlayer(player, new ClientboundRadioPacket(started, player.m_20148_(), this.getClass().getName()));
    }

    private void startTransceiving(Level level, ItemStack stack, String frequencyName, String modulation, UUID owner) {
        this.startReceiving(frequencyName, Frequency.modulationOf(modulation), owner);
        Player player = level.m_46003_(owner);
        RadioListener listener = this.startListening((Entity)player);
        listener.range = 4.0f;
        listener.acceptor(source -> {
            ItemStack using = player.m_21211_();
            CompoundTag usingTag = using.m_41784_();
            if (!usingTag.m_128441_("frequency") || !usingTag.m_128441_("modulation")) {
                return;
            }
            if (!usingTag.m_128461_("frequency").equals(frequencyName) || !usingTag.m_128461_("modulation").equals(modulation)) {
                return;
            }
            if (this.getClass() == TransceiverItem.class) {
                source.type = RadioSource.Type.TRANSCEIVER;
            } else if (this.getClass() == WalkieTalkieItem.class) {
                source.type = RadioSource.Type.WALKIE_TALKIE;
            }
            Frequency frequency = this.getFrequency(stack);
            if (frequency != null) {
                RadioManager.transmit(source, frequency);
            }
        });
    }

    private void stopTransceiving(Level level, String frequencyName, String modulation, UUID owner) {
        this.stopReceiving(frequencyName, Frequency.modulationOf(modulation), owner);
        Player entity = level.m_46003_(owner);
        this.stopListening((Entity)entity);
    }

    public int getCooldown() {
        return 20;
    }

    public void m_142312_(CompoundTag tag) {
        super.m_142312_(tag);
        if (tag.m_128441_("user")) {
            tag.m_128473_("user");
        }
    }

    public void m_142023_(ItemEntity itemEntity) {
        super.m_142023_(itemEntity);
        CompoundTag tag = itemEntity.m_32055_().m_41784_();
        if (tag.m_128441_("frequency") && tag.m_128441_("modulation") && tag.m_128441_("user")) {
            this.stopTransceiving(itemEntity.m_9236_(), tag.m_128461_("frequency"), tag.m_128461_("modulation"), tag.m_128342_("user"));
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean b) {
        super.m_6883_(stack, level, entity, slot, b);
        CompoundTag tag = stack.m_41784_();
        String frequency = tag.m_128461_("frequency");
        String modulation = tag.m_128461_("modulation");
        this.tick(stack, level);
        if (frequency.isEmpty() || modulation.isEmpty()) {
            return;
        }
        if (!Frequency.check(frequency)) {
            CommonSimpleRadio.info("Invalid frequency {}, replacing with default", frequency);
            frequency = this.getDefaultFrequency();
            tag.m_128359_("frequency", frequency);
        }
        UUID uuid = entity.m_20148_();
        if (tag.m_128441_("user")) {
            UUID currentUUID = tag.m_128342_("user");
            if (currentUUID.equals(uuid)) {
                if (this.validate(frequency, Frequency.modulationOf(modulation), currentUUID)) {
                    return;
                }
            } else if (!level.f_46443_) {
                this.stopTransceiving(level, frequency, modulation, currentUUID);
            }
        }
        frequency = tag.m_128461_("frequency");
        modulation = tag.m_128461_("modulation");
        if (!level.f_46443_) {
            this.startTransceiving(level, stack, frequency, modulation, uuid);
        }
        tag.m_128362_("user", uuid);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltip) {
        this.appendTooltip(stack, components);
        super.m_7373_(stack, level, components, tooltip);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        level.m_5594_(player, player.m_20183_(), SimpleRadioSounds.RADIO_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_6672_(hand);
        if (!level.f_46443_) {
            this.transmit((ServerPlayer)player, true);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.TOOT_HORN;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player player = (Player)user;
            level.m_5594_(player, user.m_20183_(), SimpleRadioSounds.RADIO_CLOSE, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                this.transmit((ServerPlayer)player, false);
            }
            player.m_36335_().m_41524_((Item)this, this.getCooldown());
        }
        super.m_5551_(stack, level, user, remainingUseTicks);
    }
}

