/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio;

import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.items.TransceiverItem;
import com.codinglitch.simpleradio.radio.RadioChannel;
import com.codinglitch.simpleradio.radio.RadioListener;
import com.codinglitch.simpleradio.radio.RadioSource;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class RadioManager {
    private static RadioManager INSTANCE;

    public static RadioManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RadioManager();
        }
        return INSTANCE;
    }

    public static void serverTick(int tickCount) {
        if (tickCount % 20 == 0) {
            RadioManager.garbageCollect();
        }
        List<Frequency> frequencies = Frequency.getFrequencies();
        for (Frequency frequency : frequencies) {
            frequency.serverTick(tickCount);
            for (RadioListener radioListener : frequency.transmitters) {
            }
            for (RadioChannel receiver : frequency.receivers) {
                receiver.serverTick(tickCount);
            }
        }
        List<RadioListener> listeners = RadioListener.getListeners();
        for (RadioListener listener : listeners) {
            listener.serverTick(tickCount);
        }
    }

    public static void garbageCollect() {
        Frequency.garbageCollect();
        RadioListener.garbageCollect();
    }

    public void onMicPacket(MicrophonePacketEvent event) {
        ItemStack itemStack;
        VoicechatConnection senderConnection = event.getSenderConnection();
        if (senderConnection == null) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)senderConnection.getPlayer().getPlayer();
        ServerLevel level = sender.m_284548_();
        TreeMap<Float, RadioListener> qualified = new TreeMap<Float, RadioListener>();
        for (RadioListener radioListener : RadioListener.getListeners()) {
            Vector3f position;
            if (radioListener.owner != null) {
                position = radioListener.owner.m_20182_().m_252839_();
            } else {
                if (radioListener.location == null) continue;
                position = radioListener.location.position();
            }
            float distance = position.distanceSquared((float)sender.m_20185_(), (float)sender.m_20186_(), (float)sender.m_20189_());
            if (distance > radioListener.range) continue;
            qualified.put(Float.valueOf(distance), radioListener);
        }
        int listenedTo = 0;
        Iterator iterator = qualified.keySet().iterator();
        while (iterator.hasNext()) {
            float distance = ((Float)iterator.next()).floatValue();
            RadioListener listener3 = (RadioListener)qualified.get(Float.valueOf(distance));
            float scale = 1.0f - distance / listener3.range;
            listener3.onData(new RadioSource(sender.m_20148_(), WorldlyPosition.of(sender.m_20182_().m_252839_(), (Level)level), ((MicrophonePacket)event.getPacket()).getOpusEncodedData(), scale));
            if (++listenedTo < SimpleRadioLibrary.SERVER_CONFIG.frequency.listenerBuffer) continue;
            break;
        }
        if ((itemStack = sender.m_21211_()).m_41720_() instanceof TransceiverItem) {
            CompoundTag tag = itemStack.m_41784_();
            Frequency frequency = Frequency.getOrCreateFrequency(tag.m_128461_("frequency"), Frequency.modulationOf(tag.m_128461_("modulation")));
        }
    }

    public static void transmit(RadioSource source, Frequency frequency) {
        for (RadioChannel channel : frequency.receivers) {
            if (source.owner.equals(channel.owner)) continue;
            channel.transmit(source, frequency);
        }
    }
}

