/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio.effects;

import com.codinglitch.simpleradio.radio.effects.AudioEffect;
import java.util.Random;

public class BaseAudioEffect
extends AudioEffect {
    public static Random RANDOM = new Random();
    private static final double SAMPLE_RATE = 48000.0;
    private static final double MAX_SHORT = 32767.0;
    private final double normalizedCenterFrequency;
    private final double normalizedBandwidth;
    private double lastInputSample1;
    private double lastInputSample2;
    private double lastOutputSample1;
    private double lastOutputSample2;

    public BaseAudioEffect(double centerFrequency, double bandwidth) {
        this.normalizedCenterFrequency = 2.0 * centerFrequency / 48000.0;
        this.normalizedBandwidth = 2.0 * bandwidth / 48000.0;
    }

    public BaseAudioEffect() {
        this(750.0, 4000.0);
    }

    @Override
    public short[] apply(short[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (!(RANDOM.nextFloat(100.0f) < this.severity)) continue;
            int n = i;
            data[n] = (short)(data[n] * 0);
        }
        double[] doubleSamples = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            doubleSamples[i] = (double)data[i] / 32767.0;
        }
        double maxValue = 32767.0;
        for (int i = 0; i < doubleSamples.length; ++i) {
            doubleSamples[i] = this.bandpassFilter(doubleSamples[i]) * 32767.0;
            if (!(Math.abs(doubleSamples[i]) > maxValue)) continue;
            maxValue = Math.abs(doubleSamples[i]);
        }
        short[] output = new short[data.length];
        double factor = 32767.0 / maxValue;
        for (int i = 0; i < doubleSamples.length; ++i) {
            output[i] = (short)Math.floor(doubleSamples[i] * factor);
        }
        return super.apply(output);
    }

    private double bandpassFilter(double inputSample) {
        double bandwidth = this.normalizedBandwidth * (1.0 - (double)this.severity * 0.001);
        double w0 = Math.PI * 2 * this.normalizedCenterFrequency;
        double alpha = Math.sin(w0) * Math.sinh(Math.log(2.0) / 2.0 * bandwidth * w0 / Math.sin(w0));
        double a0 = 1.0 + alpha;
        double b0 = (1.0 - Math.cos(w0)) / 2.0;
        double b1 = 1.0 - Math.cos(w0);
        double b2 = b0;
        double a1 = -2.0 * Math.cos(w0);
        double a2 = 1.0 - alpha;
        double filteredSample = (b0 * inputSample + b1 * this.lastInputSample1 + b2 * this.lastInputSample2 - a1 * this.lastOutputSample1 - a2 * this.lastOutputSample2) / a0;
        this.lastInputSample2 = this.lastInputSample1;
        this.lastInputSample1 = inputSample;
        this.lastOutputSample2 = this.lastOutputSample1;
        this.lastOutputSample1 = filteredSample;
        return filteredSample;
    }
}

