/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base;

import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.material.AutocannonMaterial;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.BigCannonBreechStrengthHandler;
import rbasamoyai.createbigcannons.cannons.big_cannons.cannon_end.BigCannonEnd;
import rbasamoyai.createbigcannons.cannons.big_cannons.material.BigCannonMaterialProperties;
import rbasamoyai.createbigcannons.index.CBCBigCannonMaterials;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;
import rbasamoyai.createbigcannons.manual_loading.RamRodItem;
import rbasamoyai.createbigcannons.manual_loading.WormItem;
import rbasamoyai.createbigcannons.munitions.big_cannon.mortar_stone.MortarStoneProperties;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCannonPropellantBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlockItem;
import rbasamoyai.createbigcannons.munitions.config.MunitionPropertiesHandler;

public class CBCTooltip {
    private static Style primary = TooltipHelper.Palette.GRAY_AND_WHITE.primary();
    private static Style highlight = TooltipHelper.Palette.GRAY_AND_WHITE.highlight();

    private static void addHoldShift(boolean desc, List<Component> tooltip) {
        String[] holdDesc = Lang.translateDirect((String)"tooltip.holdForDescription", (Object[])new Object[]{"$"}).getString().split("\\$");
        if (holdDesc.length < 2) {
            return;
        }
        MutableComponent keyShift = Lang.translateDirect((String)"tooltip.keyShift", (Object[])new Object[0]);
        MutableComponent tabBuilder = Component.m_237113_((String)"");
        tabBuilder.m_7220_((Component)Component.m_237113_((String)holdDesc[0]).m_130940_(ChatFormatting.DARK_GRAY));
        tabBuilder.m_7220_((Component)keyShift.m_6879_().m_130940_(desc ? ChatFormatting.WHITE : ChatFormatting.GRAY));
        tabBuilder.m_7220_((Component)Component.m_237113_((String)holdDesc[1]).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)tabBuilder);
    }

    private static Component getNoGogglesMeter(int outOfFive, boolean invertColor, boolean canBeInvalid) {
        int value = invertColor ? 5 - outOfFive : outOfFive;
        ChatFormatting color = switch (value) {
            case 0, 1 -> ChatFormatting.RED;
            case 2, 3 -> ChatFormatting.GOLD;
            case 4, 5 -> ChatFormatting.YELLOW;
            default -> canBeInvalid ? ChatFormatting.DARK_GRAY : (value < 0 ? ChatFormatting.RED : ChatFormatting.YELLOW);
        };
        return Component.m_237113_((String)(" " + TooltipHelper.makeProgressBar((int)5, (int)outOfFive))).m_130940_(color);
    }

    public static TooltipHelper.Palette getPalette(Level level, ItemStack stack) {
        return TooltipHelper.Palette.STANDARD_CREATE;
    }

    public static <T extends Block> void appendCannonBlockText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag, T block) {
        boolean desc = Screen.m_96638_();
        CBCTooltip.addHoldShift(desc, tooltip);
        if (!desc) {
            return;
        }
        TooltipHelper.Palette palette = CBCTooltip.getPalette(level, stack);
        BigCannonMaterialProperties material = ((BigCannonBlock)block).getCannonMaterial().properties();
        Minecraft mc = Minecraft.m_91087_();
        boolean hasGoggles = GogglesItem.isWearingGoggles((Player)mc.f_91074_);
        String rootKey = "block.createbigcannons.cannon.tooltip";
        tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)(rootKey + ".materialProperties"), (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".strength"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
        float rawStrength = material.maxSafePropellantStress();
        if (hasGoggles) {
            String strength = rawStrength > 1000.0f ? I18n.m_118938_((String)(rootKey + ".strength.unlimited"), (Object[])new Object[0]) : String.format("%.2f", Float.valueOf(rawStrength));
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + ".strength.goggles"), (Object[])new Object[]{strength}), (Style)palette.primary(), (Style)palette.highlight(), (int)2));
        } else {
            float nethersteelStrength = CBCBigCannonMaterials.NETHERSTEEL.properties().maxSafePropellantStress();
            int strength = Mth.m_14167_((float)Math.min(rawStrength / nethersteelStrength * 5.0f, 5.0f));
            tooltip.add(CBCTooltip.getNoGogglesMeter(strength, false, true));
        }
        double minVelPerBarrel = material.minimumVelocityPerBarrel();
        tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".cannonJamming"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
        if (hasGoggles) {
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + ".cannonJamming.goggles"), (Object[])new Object[]{String.format("%.2f", minVelPerBarrel * 20.0)}), (Style)palette.primary(), (Style)palette.highlight(), (int)2));
        } else {
            tooltip.add(CBCTooltip.getNoGogglesMeter(minVelPerBarrel < 1.0 ? 0 : Mth.m_14165_((double)(minVelPerBarrel * 5.0 / 6.0)), false, true));
        }
        tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".weightImpact"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
        float weightImpact = material.weight();
        if (hasGoggles) {
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + ".weightImpact.goggles"), (Object[])new Object[]{String.format("%.2f", Float.valueOf(weightImpact))}), (Style)palette.primary(), (Style)palette.highlight(), (int)2));
        } else {
            tooltip.add(CBCTooltip.getNoGogglesMeter((double)weightImpact < 1.0 ? 0 : (int)(weightImpact * 0.5f), true, true));
        }
        if (((BigCannonBlock)block).getDefaultOpeningType() == BigCannonEnd.CLOSED) {
            tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".breechStrength"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
            float breechStrength = BigCannonBreechStrengthHandler.getStrength(block, material.maxSafePropellantStress());
            if (hasGoggles) {
                tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + ".breechStrength.desc"), (Object[])new Object[]{Float.valueOf(breechStrength)}), (Style)palette.primary(), (Style)palette.highlight(), (int)2));
            } else {
                float nethersteelStrength = CBCBigCannonMaterials.NETHERSTEEL.properties().maxSafePropellantStress();
                int strength = Mth.m_14167_((float)Math.min(breechStrength / nethersteelStrength * 5.0f, 5.0f));
                tooltip.add(CBCTooltip.getNoGogglesMeter(strength, false, true));
            }
        }
        tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".onFailure"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
        String failKey = material.failureMode() == BigCannonMaterialProperties.FailureMode.RUPTURE ? ".onFailure.rupture" : ".onFailure.fragment";
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + failKey), (Object[])new Object[0]), (Style)palette.primary(), (Style)palette.highlight(), (int)2));
    }

    public static <T extends Block> void appendTextAutocannon(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag, T block) {
        boolean desc = Screen.m_96638_();
        CBCTooltip.addHoldShift(desc, tooltip);
        if (!desc) {
            return;
        }
        TooltipHelper.Palette palette = CBCTooltip.getPalette(level, stack);
        AutocannonMaterial material = ((AutocannonBlock)block).getAutocannonMaterial();
        Minecraft mc = Minecraft.m_91087_();
        boolean hasGoggles = GogglesItem.isWearingGoggles((Player)mc.f_91074_);
        String rootKey = "block.createbigcannons.autocannon.tooltip";
        tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)(rootKey + ".materialProperties"), (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
        int maxLength = material.properties().maxBarrelLength();
        tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".maxBarrelLength"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
        if (hasGoggles) {
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + ".maxBarrelLength.goggles"), (Object[])new Object[]{maxLength + 1}), (Style)palette.primary(), (Style)palette.highlight(), (int)2));
        } else {
            tooltip.add(CBCTooltip.getNoGogglesMeter(maxLength == 0 ? 0 : (maxLength - 1) / 2 + 1, false, true));
        }
        tooltip.add((Component)Component.m_237113_((String)(" " + I18n.m_118938_((String)(rootKey + ".weightImpact"), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
        float weightImpact = material.properties().weight();
        if (hasGoggles) {
            tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(rootKey + ".weightImpact.goggles"), (Object[])new Object[]{String.format("%.2f", Float.valueOf(weightImpact))}), (Style)palette.primary(), (Style)palette.highlight(), (int)2));
        } else {
            tooltip.add(CBCTooltip.getNoGogglesMeter((double)weightImpact < 1.0 ? 0 : Mth.m_14167_((float)weightImpact), true, true));
        }
    }

    public static void appendMortarStoneText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!Screen.m_96638_()) {
            return;
        }
        TooltipHelper.Palette palette = CBCTooltip.getPalette(level, stack);
        String key = stack.m_41778_() + ".tooltip.maximumCharges";
        tooltip.add((Component)Component.m_237115_((String)key).m_130940_(ChatFormatting.GRAY));
        MortarStoneProperties properties = (MortarStoneProperties)MunitionPropertiesHandler.getProperties((EntityType)CBCEntityTypes.MORTAR_STONE.get());
        String value = String.format("%.2f", Float.valueOf((properties == null ? 2.0f : properties.maxCharges()) * 20.0f));
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".value"), (Object[])new Object[]{value}), (Style)palette.primary(), (Style)palette.highlight(), (int)1));
    }

    public static void appendRamRodText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!Screen.m_96638_()) {
            return;
        }
        TooltipHelper.Palette palette = CBCTooltip.getPalette(level, stack);
        String keyBase = stack.m_41778_() + ".tooltip.";
        String key = keyBase + "pushStrength";
        tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".value"), (Object[])new Object[]{RamRodItem.getPushStrength()}), (Style)palette.primary(), (Style)palette.highlight(), (int)1));
        String key1 = keyBase + "reach";
        tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key1, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key1 + ".value"), (Object[])new Object[]{RamRodItem.getReach()}), (Style)palette.primary(), (Style)palette.highlight(), (int)1));
        String key2 = keyBase + "deployerCanUse";
        tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key2, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key2 + (RamRodItem.deployersCanUse() ? ".yes" : ".no")), (Object[])new Object[0]), (Style)palette.primary(), (Style)palette.highlight(), (int)1));
    }

    public static void appendWormText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!Screen.m_96638_()) {
            return;
        }
        TooltipHelper.Palette palette = CBCTooltip.getPalette(level, stack);
        String keyBase = stack.m_41778_() + ".tooltip.";
        String key = keyBase + "reach";
        tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".value"), (Object[])new Object[]{WormItem.getReach()}), (Style)palette.primary(), (Style)palette.highlight(), (int)1));
        String key1 = keyBase + "deployerCanUse";
        tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key1, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key1 + (WormItem.deployersCanUse() ? ".yes" : ".no")), (Object[])new Object[0]), (Style)palette.primary(), (Style)palette.highlight(), (int)1));
    }

    public static void appendImpactFuzeText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag, float detChance) {
        if (!Screen.m_96638_()) {
            return;
        }
        TooltipHelper.Palette palette = CBCTooltip.getPalette(level, stack);
        String key = stack.m_41778_() + ".tooltip.chance";
        tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".value"), (Object[])new Object[]{(int)(detChance * 100.0f)}), (Style)palette.primary(), (Style)palette.highlight(), (int)1));
    }

    public static void appendCannonCarriageText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag, BlockItem block) {
        if (!Screen.m_96638_()) {
            return;
        }
        TooltipHelper.Palette palette = CBCTooltip.getPalette(level, stack);
        String key = block.m_5524_() + ".tooltip";
        String fire = I18n.m_118938_((String)CBCClientCommon.FIRE_CONTROLLED_CANNON.m_90863_().getString(), (Object[])new Object[0]);
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".keyPressed"), (Object[])new Object[]{fire}), (Style)primary, (Style)highlight));
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".fireCannon"), (Object[])new Object[0]), (Style)palette.primary(), (Style)palette.highlight(), (int)1));
        String pitchMode = I18n.m_118938_((String)CBCClientCommon.PITCH_MODE.m_90863_().getString(), (Object[])new Object[0]);
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".keyPressed"), (Object[])new Object[]{pitchMode}), (Style)primary, (Style)highlight));
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".pitchMode"), (Object[])new Object[0]), (Style)palette.primary(), (Style)palette.highlight(), (int)1));
    }

    public static void appendMuzzleVelocityText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag, BigCannonPropellantBlock propellant) {
        if (!Screen.m_96638_()) {
            return;
        }
        TooltipHelper.Palette palette = CBCTooltip.getPalette(level, stack);
        String key = "block.createbigcannons.propellant.tooltip.added_muzzle_velocity";
        tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
        String s = String.format("%+.2f", Float.valueOf(propellant.getChargePower(stack) * 20.0f));
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".value"), (Object[])new Object[]{s}), (Style)palette.primary(), (Style)palette.highlight(), (int)1));
    }

    public static void appendPropellantStressText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag, BigCannonPropellantBlock propellant) {
        if (!Screen.m_96638_()) {
            return;
        }
        TooltipHelper.Palette palette = CBCTooltip.getPalette(level, stack);
        String key = "block.createbigcannons.propellant.tooltip.added_stress";
        tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
        String s = String.format("%+.2f", Float.valueOf(propellant.getStressOnCannon(stack)));
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".value"), (Object[])new Object[]{s}), (Style)palette.primary(), (Style)palette.highlight(), (int)1));
    }

    public static void appendPropellantPowerText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag, BigCannonPropellantBlock propellant) {
        if (!Screen.m_96638_()) {
            return;
        }
        TooltipHelper.Palette palette = CBCTooltip.getPalette(level, stack);
        String key = "block.createbigcannons.propellant.tooltip.power";
        tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)key, (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
        int min = BigCartridgeBlockItem.getPower(stack);
        int max = BigCartridgeBlock.getMaximumPowerLevels();
        tooltip.addAll(TooltipHelper.cutStringTextComponent((String)I18n.m_118938_((String)(key + ".value"), (Object[])new Object[]{min, max}), (Style)palette.primary(), (Style)palette.highlight(), (int)1));
    }
}

