/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_armor_properties.mimicking_blocks;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import rbasamoyai.createbigcannons.base.BlockStatePredicateHelper;

public record MimickingBlockArmorUnit(double emptyHardness, double materialHardnessMultiplier) {
    public static MimickingBlockArmorUnit fromJson(JsonObject obj) {
        double emptyHardness = Math.max(GsonHelper.m_144742_((JsonObject)obj, (String)"default_block_hardness", (double)1.0), 0.0);
        double materialHardnessMultiplier = Math.max(GsonHelper.m_144742_((JsonObject)obj, (String)"material_hardness_multiplier", (double)1.0), 0.0);
        return new MimickingBlockArmorUnit(emptyHardness, materialHardnessMultiplier);
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeDouble(this.emptyHardness).writeDouble(this.materialHardnessMultiplier);
    }

    public static MimickingBlockArmorUnit fromNetwork(FriendlyByteBuf buf) {
        double emptyHardness = buf.readDouble();
        double materialHardnessMultiplier = buf.readDouble();
        return new MimickingBlockArmorUnit(emptyHardness, materialHardnessMultiplier);
    }

    public static Map<BlockState, MimickingBlockArmorUnit> readAllProperties(Block block, JsonObject obj) {
        StateDefinition definition = block.m_49965_();
        HashSet states = new HashSet(definition.m_61056_());
        Reference2ObjectOpenHashMap propertiesByState = new Reference2ObjectOpenHashMap();
        for (String key : obj.keySet()) {
            Predicate<BlockState> pred = BlockStatePredicateHelper.variantPredicate((StateDefinition<Block, BlockState>)definition, key);
            JsonElement el = obj.get(key);
            if (!el.isJsonObject()) {
                throw new JsonSyntaxException("Invalid info for variant '" + key + "''");
            }
            JsonObject variantInfo = el.getAsJsonObject();
            MimickingBlockArmorUnit properties = MimickingBlockArmorUnit.fromJson(variantInfo);
            Iterator stateIter = states.iterator();
            while (stateIter.hasNext()) {
                BlockState state1 = (BlockState)stateIter.next();
                if (!pred.test(state1)) continue;
                propertiesByState.put(state1, properties);
                stateIter.remove();
            }
        }
        return propertiesByState;
    }

    public static void writePropertiesToBuf(Map<BlockState, MimickingBlockArmorUnit> map, FriendlyByteBuf buf) {
        buf.m_130130_(map.size());
        for (Map.Entry<BlockState, MimickingBlockArmorUnit> entry : map.entrySet()) {
            buf.m_130130_(Block.m_49956_((BlockState)entry.getKey()));
            entry.getValue().toNetwork(buf);
        }
    }

    public static Map<BlockState, MimickingBlockArmorUnit> readPropertiesFromBuf(FriendlyByteBuf buf) {
        int sz = buf.m_130242_();
        Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
        for (int i = 0; i < sz; ++i) {
            BlockState state = Block.m_49803_((int)buf.m_130242_());
            MimickingBlockArmorUnit properties = MimickingBlockArmorUnit.fromNetwork(buf);
            map.put(state, properties);
        }
        return map;
    }
}

