/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.effects;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import rbasamoyai.createbigcannons.cannon_control.effects.CannonSmokeParticle;
import rbasamoyai.createbigcannons.index.CBCParticleTypes;

public class CannonSmokeParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<CannonSmokeParticleData> {
    public static final Codec<CannonSmokeParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("scale").forGetter(data -> Float.valueOf(data.scale)), (App)Vec3.f_231074_.fieldOf("startColor").forGetter(data -> data.startColor), (App)Vec3.f_231074_.fieldOf("endColor").forGetter(data -> data.endColor), (App)Codec.INT.fieldOf("shiftTime").forGetter(data -> data.shiftTime)).apply((Applicative)i, CannonSmokeParticleData::new));
    public static final ParticleOptions.Deserializer<CannonSmokeParticleData> DESERIALIZER = new ParticleOptions.Deserializer<CannonSmokeParticleData>(){

        public CannonSmokeParticleData fromNetwork(ParticleType<CannonSmokeParticleData> type, FriendlyByteBuf buf) {
            float scale = buf.readFloat();
            Vec3 startColor = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
            Vec3 endColor = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
            int shiftTime = buf.m_130242_();
            return new CannonSmokeParticleData(scale, startColor, endColor, shiftTime);
        }

        public CannonSmokeParticleData fromCommand(ParticleType<CannonSmokeParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            float rs = reader.readFloat();
            reader.expect(' ');
            float gs = reader.readFloat();
            reader.expect(' ');
            float bs = reader.readFloat();
            reader.expect(' ');
            float rf = reader.readFloat();
            reader.expect(' ');
            float gf = reader.readFloat();
            reader.expect(' ');
            float bf = reader.readFloat();
            reader.expect(' ');
            int shiftTime = reader.readInt();
            return new CannonSmokeParticleData(scale, new Vec3((double)rs, (double)gs, (double)bs), new Vec3((double)rf, (double)gf, (double)bf), shiftTime);
        }
    };
    private final float scale;
    private final Vec3 startColor;
    private final Vec3 endColor;
    private final int shiftTime;

    public CannonSmokeParticleData(float scale, Vec3 startColor, Vec3 endColor, int shiftTime) {
        this.scale = scale;
        this.startColor = startColor;
        this.endColor = endColor;
        this.shiftTime = shiftTime;
    }

    public CannonSmokeParticleData() {
        this(0.0f, Vec3.f_82478_, Vec3.f_82478_, 1);
    }

    public float scale() {
        return this.scale;
    }

    public Vec3 startColor() {
        return this.startColor;
    }

    public Vec3 endColor() {
        return this.endColor;
    }

    public int shiftTime() {
        return this.shiftTime;
    }

    public ParticleType<?> m_6012_() {
        return CBCParticleTypes.CANNON_SMOKE.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.scale);
        buf.writeFloat((float)this.startColor.m_7096_());
        buf.writeFloat((float)this.startColor.m_7098_());
        buf.writeFloat((float)this.startColor.m_7094_());
        buf.writeFloat((float)this.endColor.m_7096_());
        buf.writeFloat((float)this.endColor.m_7098_());
        buf.writeFloat((float)this.endColor.m_7094_());
        buf.m_130130_(this.shiftTime);
    }

    public String m_5942_() {
        return String.format("%d %f %f %f %f %f %f %d", Float.valueOf(this.scale), this.startColor.m_7096_(), this.startColor.m_7098_(), this.startColor.m_7094_(), this.endColor.m_7096_(), this.endColor.m_7098_(), this.endColor.m_7094_(), this.shiftTime);
    }

    public ParticleOptions.Deserializer<CannonSmokeParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    public Codec<CannonSmokeParticleData> getCodec(ParticleType<CannonSmokeParticleData> type) {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleEngine.SpriteParticleRegistration<CannonSmokeParticleData> getMetaFactory() {
        return CannonSmokeParticle.Provider::new;
    }
}

