/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class ShakeEffect {
    public final PerlinSimplexNoise yawNoise;
    public final PerlinSimplexNoise pitchNoise;
    public final PerlinSimplexNoise rollNoise;
    public final float magnitude;
    private final int startTime;
    private float timer;

    public ShakeEffect(int seed, int startTime, float magnitude) {
        this.yawNoise = new PerlinSimplexNoise((RandomSource)new LegacyRandomSource((long)(seed + 1)), (List)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
        this.pitchNoise = new PerlinSimplexNoise((RandomSource)new LegacyRandomSource((long)seed), (List)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
        this.rollNoise = new PerlinSimplexNoise((RandomSource)new LegacyRandomSource((long)(seed + 2)), (List)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
        this.magnitude = magnitude;
        this.startTime = startTime;
        this.timer = this.startTime;
    }

    public boolean tick() {
        if (this.startTime < 1) {
            return true;
        }
        this.timer -= 1.0f;
        return this.timer < 1.0f;
    }

    public float getProgress(float partialTicks) {
        return this.timer - partialTicks;
    }

    public float getProgressNormalized(float partialTicks) {
        return this.startTime < 1 ? 0.0f : this.getProgress(partialTicks) / (float)this.startTime;
    }
}

