/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.config.CBCConfigs;

public class QuickfiringBreechBlockEntity
extends SmartBlockEntity
implements IBigCannonBlockEntity {
    private BigCannonBehavior cannonBehavior;
    private int openProgress;
    private boolean inPonder;
    private int openDirection;
    private int loadingCooldown;

    public QuickfiringBreechBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.cannonBehavior = new BigCannonBehavior(this, this::canLoadBlock);
        behaviours.add(this.cannonBehavior);
    }

    @Override
    public boolean canLoadBlock(StructureTemplate.StructureBlockInfo blockInfo) {
        return false;
    }

    @Override
    public BigCannonBehavior cannonBehavior() {
        return this.cannonBehavior;
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128379_("InPonder", this.inPonder);
        tag.m_128405_("OpenProgress", this.openProgress);
        tag.m_128405_("OpenDirection", this.openDirection);
        tag.m_128405_("LoadingCooldown", this.loadingCooldown);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.inPonder = tag.m_128471_("InPonder");
        this.openProgress = tag.m_128451_("OpenProgress");
        this.openDirection = Mth.m_14045_((int)tag.m_128451_("OpenDirection"), (int)-1, (int)1);
        this.loadingCooldown = Math.max(0, tag.m_128451_("LoadingCooldown"));
    }

    public void tick() {
        super.tick();
        if (!this.inPonder) {
            if (this.openProgress != 0) {
                this.openProgress = 0;
            }
            if (this.openDirection != 0) {
                this.openDirection = 0;
            }
            if (this.loadingCooldown != 0) {
                this.loadingCooldown = 0;
            }
        }
    }

    public void tickAnimation() {
        if (this.openDirection != 0 && !QuickfiringBreechBlockEntity.isInstantOpen()) {
            this.openProgress = Mth.m_14045_((int)(this.openProgress + this.openDirection), (int)0, (int)Math.max(QuickfiringBreechBlockEntity.getOpeningTime(), 1));
            if (!this.onInteractionCooldown()) {
                this.openDirection = 0;
            }
        }
        if (this.loadingCooldown > 0) {
            --this.loadingCooldown;
        }
    }

    public boolean isOpen() {
        return QuickfiringBreechBlockEntity.isInstantOpen() ? this.openProgress > 0 : this.openProgress >= QuickfiringBreechBlockEntity.getOpeningTime();
    }

    public int getOpenDirection() {
        return this.openDirection;
    }

    public void toggleOpening() {
        if (QuickfiringBreechBlockEntity.isInstantOpen()) {
            this.openProgress = this.openProgress > 0 ? 0 : 1;
            return;
        }
        if (!this.onInteractionCooldown()) {
            this.openDirection = this.isOpen() ? -1 : 1;
        }
    }

    public float getOpenProgress(float partialTicks) {
        if (QuickfiringBreechBlockEntity.isInstantOpen()) {
            return Mth.m_14036_((float)this.openProgress, (float)0.0f, (float)1.0f);
        }
        return Mth.m_14036_((float)(((float)this.openProgress + (float)this.openDirection * partialTicks) / (float)QuickfiringBreechBlockEntity.getOpeningTime()), (float)0.0f, (float)1.0f);
    }

    public int getOpenProgress() {
        return this.openProgress;
    }

    public boolean onInteractionCooldown() {
        return 0 < this.openProgress && this.openProgress < QuickfiringBreechBlockEntity.getOpeningTime();
    }

    public boolean canBeAutomaticallyLoaded() {
        return this.loadingCooldown <= 0 && this.openProgress == 0;
    }

    public void setLoadingCooldown(int value) {
        this.loadingCooldown = value;
    }

    public static int getOpeningTime() {
        return (Integer)CBCConfigs.SERVER.cannons.quickfiringBreechOpeningCooldown.get();
    }

    public static boolean isInstantOpen() {
        return QuickfiringBreechBlockEntity.getOpeningTime() <= 0;
    }
}

