/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.compat.framedblocks;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesProvider;
import rbasamoyai.createbigcannons.block_armor_properties.mimicking_blocks.MimickingBlockArmorUnit;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;

public class FramedDoubleBlockArmorProperties
implements BlockArmorPropertiesProvider {
    private final MimickingBlockArmorUnit defaultPropertiesPrimary;
    private final MimickingBlockArmorUnit defaultPropertiesSecondary;
    private final Map<BlockState, MimickingBlockArmorUnit> primaryPropertiesByState;
    private final Map<BlockState, MimickingBlockArmorUnit> secondaryPropertiesByState;

    public FramedDoubleBlockArmorProperties(MimickingBlockArmorUnit defaultPropertiesPrimary, MimickingBlockArmorUnit defaultPropertiesSecondary, Map<BlockState, MimickingBlockArmorUnit> primaryPropertiesByState, Map<BlockState, MimickingBlockArmorUnit> secondaryPropertiesByState) {
        this.defaultPropertiesPrimary = defaultPropertiesPrimary;
        this.defaultPropertiesSecondary = defaultPropertiesSecondary;
        this.primaryPropertiesByState = primaryPropertiesByState;
        this.secondaryPropertiesByState = secondaryPropertiesByState;
    }

    @Override
    public double hardness(Level level, BlockState state, BlockPos pos, boolean recurse) {
        boolean secondaryUnbreakable;
        MimickingBlockArmorUnit primary = this.primaryPropertiesByState.getOrDefault(state, this.defaultPropertiesPrimary);
        MimickingBlockArmorUnit secondary = this.secondaryPropertiesByState.getOrDefault(state, this.defaultPropertiesSecondary);
        BlockState primaryState = Blocks.f_50016_.m_49966_();
        BlockState secondaryState = Blocks.f_50016_.m_49966_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity fbe = (FramedDoubleBlockEntity)blockEntity;
            primaryState = fbe.getCamo().getState();
            secondaryState = fbe.getCamoTwo().getState();
        }
        boolean bl = secondaryUnbreakable = secondaryState.m_60800_((BlockGetter)level, pos) == -1.0f;
        if (primaryState.m_60800_((BlockGetter)level, pos) == -1.0f) {
            double primaryResistance = primaryState.m_60734_().m_7325_();
            return secondaryUnbreakable ? Math.max(primaryResistance, (double)secondaryState.m_60734_().m_7325_()) : primaryResistance;
        }
        if (secondaryState.m_60800_((BlockGetter)level, pos) == -1.0f) {
            return secondaryState.m_60734_().m_7325_();
        }
        double primaryPart = !recurse || primaryState.m_60795_() ? primary.emptyHardness() : BlockArmorPropertiesHandler.getProperties(primaryState).hardness(level, primaryState, pos, false) * primary.materialHardnessMultiplier();
        double secondaryPart = !recurse || secondaryState.m_60795_() ? secondary.emptyHardness() : BlockArmorPropertiesHandler.getProperties(secondaryState).hardness(level, secondaryState, pos, false) * secondary.materialHardnessMultiplier();
        return primaryPart + secondaryPart;
    }

    public MimickingBlockArmorUnit getPrimaryDefaultProperties() {
        return this.defaultPropertiesPrimary;
    }

    public MimickingBlockArmorUnit getSecondaryDefaultProperties() {
        return this.defaultPropertiesSecondary;
    }

    public Map<BlockState, MimickingBlockArmorUnit> getPrimaryPropertiesByState() {
        return this.primaryPropertiesByState;
    }

    public Map<BlockState, MimickingBlockArmorUnit> getSecondaryPropertiesByState() {
        return this.secondaryPropertiesByState;
    }
}

