/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.forge;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;

public class CBCClientForge {
    public static void prepareClient(IEventBus modEventBus, IEventBus forgeEventBus) {
        CBCBlockPartials.init();
        modEventBus.addListener(CBCClientForge::onClientSetup);
        modEventBus.addListener(CBCClientForge::onRegisterKeyMappings);
        modEventBus.addListener(CBCClientForge::onRegisterParticleFactories);
        modEventBus.addListener(CBCClientForge::onRegisterGuiOverlays);
        forgeEventBus.addListener(CBCClientForge::getFogColor);
        forgeEventBus.addListener(CBCClientForge::getFogDensity);
        forgeEventBus.addListener(CBCClientForge::onClientGameTick);
        forgeEventBus.addListener(CBCClientForge::onScrollMouse);
        forgeEventBus.addListener(CBCClientForge::onFovModify);
        forgeEventBus.addListener(CBCClientForge::onPlayerRenderPre);
        forgeEventBus.addListener(CBCClientForge::onSetupCamera);
        forgeEventBus.addListener(CBCClientForge::onPlayerLogOut);
        forgeEventBus.addListener(CBCClientForge::onClickMouse);
    }

    public static void onRegisterParticleFactories(RegisterParticleProvidersEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        CBCClientCommon.onRegisterParticleFactories(mc, mc.f_91061_);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        CBCClientCommon.onClientSetup();
    }

    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        CBCClientCommon.registerKeyMappings(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    public static void getFogColor(ViewportEvent.ComputeFogColor event) {
        CBCClientCommon.setFogColor(event.getCamera(), (r, g, b) -> {
            event.setRed(r);
            event.setGreen(g);
            event.setBlue(b);
        });
    }

    public static void getFogDensity(ViewportEvent.RenderFog event) {
        if (!event.isCancelable()) {
            return;
        }
        float density = CBCClientCommon.getFogDensity(event.getCamera(), event.getFarPlaneDistance());
        if (density != -1.0f) {
            event.setFarPlaneDistance(density);
            event.setNearPlaneDistance(density);
            event.setCanceled(true);
        }
    }

    public static void onClientGameTick(TickEvent.ClientTickEvent evt) {
        CBCClientCommon.onClientGameTick(Minecraft.m_91087_());
    }

    public static void onClickMouse(InputEvent.InteractionKeyMappingTriggered evt) {
        if (CBCClientCommon.onClickMouse(evt.getKeyMapping()) && evt.isCancelable()) {
            evt.setCanceled(true);
        }
    }

    public static void onScrollMouse(InputEvent.MouseScrollingEvent evt) {
        if (CBCClientCommon.onScrollMouse(Minecraft.m_91087_(), evt.getScrollDelta()) && evt.isCancelable()) {
            evt.setCanceled(true);
        }
    }

    public static void onFovModify(ComputeFovModifierEvent evt) {
        evt.setNewFovModifier(CBCClientCommon.onFovModify(Minecraft.m_91087_(), evt.getNewFovModifier()));
    }

    public static void onPlayerRenderPre(RenderPlayerEvent.Pre evt) {
        CBCClientCommon.onPlayerRenderPre(evt.getPoseStack(), (LivingEntity)evt.getEntity(), evt.getPartialTick());
    }

    public static void onSetupCamera(ViewportEvent.ComputeCameraAngles evt) {
        if (CBCClientCommon.onCameraSetup(evt.getCamera(), evt.getPartialTick(), () -> ((ViewportEvent.ComputeCameraAngles)evt).getYaw(), () -> ((ViewportEvent.ComputeCameraAngles)evt).getPitch(), () -> ((ViewportEvent.ComputeCameraAngles)evt).getRoll(), arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setYaw(arg_0), arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setPitch(arg_0), arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setRoll(arg_0)) && evt.isCancelable()) {
            evt.setCanceled(true);
        }
    }

    public static void onPlayerLogOut(ClientPlayerNetworkEvent.LoggingOut evt) {
        CBCClientCommon.onPlayerLogOut(evt.getPlayer());
    }

    public static void onRegisterGuiOverlays(RegisterGuiOverlaysEvent evt) {
        CBCClientCommon.registerOverlays((id, overlay) -> evt.registerAbove(VanillaGuiOverlay.HOTBAR.id(), id, (gui, graphics, partialTicks, width, height) -> overlay.renderOverlay(graphics, partialTicks, width, height)));
    }

    @Mod.EventBusSubscriber(modid="createbigcannons", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static abstract class ClientModBusEvents {
        @SubscribeEvent
        static void onLoadComplete(FMLLoadCompleteEvent event) {
            ModContainer container = (ModContainer)ModList.get().getModContainerById("createbigcannons").orElseThrow(() -> new IllegalStateException("CBC mod container missing on LoadComplete"));
            container.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> CBCConfigs.createConfigScreen(screen)));
        }
    }
}

