/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.index;

import com.simibubi.create.foundation.particle.ICustomParticleData;
import com.simibubi.create.foundation.utility.Lang;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import rbasamoyai.createbigcannons.cannon_control.effects.CannonPlumeParticleData;
import rbasamoyai.createbigcannons.cannon_control.effects.CannonSmokeParticleData;
import rbasamoyai.createbigcannons.multiloader.IndexPlatform;
import rbasamoyai.createbigcannons.multiloader.ParticlesPlatform;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobParticleData;

public enum CBCParticleTypes {
    CANNON_PLUME(CannonPlumeParticleData::new),
    FLUID_BLOB(FluidBlobParticleData::new),
    CANNON_SMOKE(CannonSmokeParticleData::new);

    private final ParticleEntry<?> entry;

    private <D extends ParticleOptions> CBCParticleTypes(Supplier<ICustomParticleData<D>> typeFactory) {
        String name = Lang.asId((String)this.name());
        this.entry = new ParticleEntry<D>(name, typeFactory);
    }

    public static void register() {
        IndexPlatform.registerDeferredParticles();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerFactories() {
        ParticleEngine particles = Minecraft.m_91087_().f_91061_;
        for (CBCParticleTypes particle : CBCParticleTypes.values()) {
            particle.entry.registerFactory(particles);
        }
    }

    public ParticleType<?> get() {
        return this.entry.object;
    }

    public String parameter() {
        return this.entry.name;
    }

    private static class ParticleEntry<D extends ParticleOptions> {
        private final String name;
        private final Supplier<? extends ICustomParticleData<D>> typeFactory;
        private final ParticleType<D> object;

        public ParticleEntry(String name, Supplier<? extends ICustomParticleData<D>> typeFactory) {
            this.name = name;
            this.typeFactory = typeFactory;
            this.object = this.typeFactory.get().createType();
            IndexPlatform.registerDeferredParticleType(this.name, this.object);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void registerFactory(ParticleEngine particles) {
            ParticlesPlatform.register(this.typeFactory.get(), this.object, particles);
        }
    }
}

