/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.autocannon;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.BaseProjectileProperties;

public abstract class AbstractAutocannonProjectile<T extends BaseProjectileProperties>
extends AbstractCannonProjectile<T> {
    protected int ageRemaining;
    @Nullable
    private Vec3 prevPos = null;

    protected AbstractAutocannonProjectile(EntityType<? extends AbstractAutocannonProjectile> type, Level level) {
        super(type, level);
    }

    @Override
    protected void onTickRotate() {
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        if (!this.isInGround()) {
            Vec3 vel = this.m_20184_();
            if (vel.m_82556_() > 0.005) {
                this.m_146922_((float)(Mth.m_14136_((double)vel.f_82479_, (double)vel.f_82481_) * 57.2957763671875));
                this.m_146926_((float)(Mth.m_14136_((double)vel.f_82480_, (double)vel.m_165924_()) * 57.2957763671875));
            }
            this.m_146922_(this.m_146908_());
            this.m_146926_(this.m_146909_());
        }
    }

    @Override
    protected double overPenetrationPower(double hardness, double curPom) {
        return 0.0;
    }

    @Override
    public void m_8119_() {
        this.prevPos = this.m_20182_();
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46805_(this.m_20183_())) {
            --this.ageRemaining;
            if (this.ageRemaining <= 0) {
                this.expireProjectile();
            }
        }
    }

    @Nullable
    public Vec3 getPreviousPos() {
        return this.prevPos;
    }

    protected void expireProjectile() {
        this.m_146870_();
    }

    public void setTracer(boolean tracer) {
        if (tracer) {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(ID_FLAGS) | 2)));
        } else {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 0xFD)));
        }
    }

    public void setLifetime(int lifetime) {
        this.ageRemaining = lifetime;
    }

    @Override
    protected void onDestroyBlock(BlockState state, BlockHitResult result) {
        if (this.m_9236_() instanceof ServerLevel) {
            BlockPos pos = result.m_82425_();
            if (state.m_60800_((BlockGetter)this.m_9236_(), pos) == -1.0f) {
                return;
            }
            Vec3 curVel = this.m_20184_();
            double curPom = (double)this.getProjectileMass() * curVel.m_82553_();
            double hardness = BlockArmorPropertiesHandler.getProperties(state).hardness(this.m_9236_(), state, pos, true) * 10.0;
            CreateBigCannons.BLOCK_DAMAGE.damageBlock(pos.m_7949_(), (int)Math.min(curPom, hardness), state, this.m_9236_());
            if (curPom > hardness) {
                double startMass = this.getProjectileMass();
                this.m_20256_(curVel.m_82541_().m_82490_(Math.max(curPom - hardness, 0.0) / startMass));
            } else {
                this.onImpact((HitResult)result, false);
                this.m_146870_();
            }
        }
    }

    @Override
    protected void onImpact(HitResult result, boolean stopped) {
        super.onImpact(result, stopped);
        if (stopped && !this.m_213877_()) {
            this.m_146870_();
        }
    }

    public boolean isTracer() {
        return ((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 2) != 0;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Tracer", this.isTracer());
        tag.m_128405_("Age", this.ageRemaining);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setTracer(tag.m_128471_("Tracer"));
        this.ageRemaining = tag.m_128451_("Age");
    }

    @Override
    protected boolean canDeflect(BlockHitResult result) {
        return super.canDeflect(result) && this.f_19796_.m_188501_() < CBCConfigs.SERVER.munitions.autocannonDeflectChance.getF();
    }

    @Override
    protected boolean canBounceOffOf(BlockState state) {
        return super.canBounceOffOf(state) && this.f_19796_.m_188501_() < CBCConfigs.SERVER.munitions.autocannonDeflectChance.getF();
    }
}

