/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.autocannon.ammo_container;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.createbigcannons.index.CBCBlockEntities;
import rbasamoyai.createbigcannons.index.CBCMenuTypes;
import rbasamoyai.createbigcannons.index.CBCShapes;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonAmmoType;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerBlockEntity;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerItem;

public class AutocannonAmmoContainerBlock
extends Block
implements IWrenchable,
SimpleWaterloggedBlock,
IBE<AutocannonAmmoContainerBlockEntity> {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<State> CONTAINER_STATE = EnumProperty.m_61587_((String)"state", State.class);

    public AutocannonAmmoContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(CONTAINER_STATE, (Comparable)((Object)State.CLOSED))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AXIS}).m_61104_(new Property[]{CONTAINER_STATE}).m_61104_(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_8125_().m_122434_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CBCShapes.AUTOCANNON_AMMO_CONTAINER.get((Direction.Axis)state.m_61143_(AXIS));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AutocannonAmmoContainerBlockEntity) {
            AutocannonAmmoContainerBlockEntity be = (AutocannonAmmoContainerBlockEntity)blockEntity;
            if (stack.m_41788_()) {
                be.setCustomName(stack.m_41786_());
            }
            be.setMainAmmoDirect(AutocannonAmmoContainerItem.getMainAmmoStack(stack));
            be.setTracersDirect(AutocannonAmmoContainerItem.getTracerAmmoStack(stack));
            be.setSpacing(AutocannonAmmoContainerItem.getTracerSpacing(stack));
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof AutocannonAmmoContainerBlockEntity) {
            AutocannonAmmoContainerBlockEntity be = (AutocannonAmmoContainerBlockEntity)blockEntity;
            if (player.m_7500_() && be.canDropInCreative()) {
                ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
                be.m_187476_(stack);
                if (be.m_8077_()) {
                    stack.m_41714_(be.m_7770_());
                }
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            if (level.m_7702_(pos) instanceof AutocannonAmmoContainerBlockEntity) {
                level.m_46717_(pos, state.m_60734_());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack itemStack = super.m_7397_(level, pos, state);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AutocannonAmmoContainerBlockEntity) {
            AutocannonAmmoContainerBlockEntity be = (AutocannonAmmoContainerBlockEntity)blockEntity;
            be.m_187476_(itemStack);
        }
        return itemStack;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AutocannonAmmoContainerBlockEntity) {
            AutocannonAmmoContainerBlockEntity be = (AutocannonAmmoContainerBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                CBCMenuTypes.AUTOCANNON_AMMO_CONTAINER.open(splayer, be.m_5446_(), (MenuConstructor)be, buf -> {
                    buf.writeBoolean(be.isCreativeContainer());
                    buf.m_130130_(be.getSpacing());
                    buf.writeBoolean(true);
                    buf.m_130064_(pos);
                });
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof AutocannonAmmoContainerBlockEntity)) {
            return 0;
        }
        AutocannonAmmoContainerBlockEntity be = (AutocannonAmmoContainerBlockEntity)blockEntity;
        AutocannonAmmoType type = be.getAmmoType();
        if (type == AutocannonAmmoType.NONE) {
            return 0;
        }
        if (be.isCreativeContainer()) {
            return be.getTotalCount() == 0 ? 0 : 15;
        }
        return (int)Math.floor((float)be.getTotalCount() / (float)type.getCapacity() * 15.0f);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213897_(state, level, pos, random);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AutocannonAmmoContainerBlockEntity) {
            AutocannonAmmoContainerBlockEntity be = (AutocannonAmmoContainerBlockEntity)blockEntity;
            be.recheckOpen();
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public BlockState m_7417_(BlockState state, Direction face, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, face, otherState, level, pos, otherPos);
    }

    public Class<AutocannonAmmoContainerBlockEntity> getBlockEntityClass() {
        return AutocannonAmmoContainerBlockEntity.class;
    }

    public BlockEntityType<? extends AutocannonAmmoContainerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CBCBlockEntities.AUTOCANNON_AMMO_CONTAINER.get();
    }

    public static enum State implements StringRepresentable
    {
        CLOSED,
        EMPTY,
        FILLED;

        private final String id = this.name().toLowerCase(Locale.ROOT);

        public String m_7912_() {
            return this.id;
        }

        public static State getFromFilled(boolean filled) {
            return filled ? FILLED : EMPTY;
        }
    }
}

