/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import com.simibubi.create.AllFluids;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.EndFluidStack;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlob;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobEffectRegistry;

public class DefaultFluidCompat {
    public static void registerMinecraftBlobEffects() {
        FluidBlobEffectRegistry.registerHitEntity((Fluid)Fluids.f_76193_, DefaultFluidCompat::waterHitEntity);
        FluidBlobEffectRegistry.registerHitEntity((Fluid)Fluids.f_76195_, DefaultFluidCompat::lavaHitEntity);
        FluidBlobEffectRegistry.registerHitBlock((Fluid)Fluids.f_76193_, DefaultFluidCompat::waterHitBlock);
        FluidBlobEffectRegistry.registerHitBlock((Fluid)Fluids.f_76195_, DefaultFluidCompat::lavaHitBlock);
    }

    public static void registerCreateBlobEffects() {
        FluidBlobEffectRegistry.registerHitBlock((Fluid)AllFluids.POTION.get(), DefaultFluidCompat::potionHitBlock);
        FluidBlobEffectRegistry.registerHitEntity((Fluid)AllFluids.POTION.get(), DefaultFluidCompat::potionHitEntity);
    }

    public static void waterHitEntity(EndFluidStack fstack, FluidBlob blob, Level level, EntityHitResult result) {
        Entity entity = result.m_82443_();
        entity.m_20095_();
        if (!level.f_46443_) {
            DefaultFluidCompat.douseFire(entity.m_20183_(), blob, level);
        }
    }

    public static void lavaHitEntity(EndFluidStack fstack, FluidBlob blob, Level level, EntityHitResult result) {
        Entity entity = result.m_82443_();
        entity.m_20254_(100);
        if (!level.f_46443_) {
            DefaultFluidCompat.spawnFire(entity.m_20183_(), blob, level);
        }
    }

    public static void potionHitEntity(EndFluidStack fstack, FluidBlob blob, Level level, EntityHitResult result) {
        if (!level.f_46443_) {
            DefaultFluidCompat.spawnAreaEffectCloud(result.m_82443_().m_20183_(), blob, level);
        }
    }

    public static void waterHitBlock(EndFluidStack fstack, FluidBlob blob, Level level, BlockHitResult result) {
        if (!level.f_46443_) {
            DefaultFluidCompat.douseFire(result.m_82425_().m_121945_(result.m_82434_()), blob, level);
        }
    }

    public static void lavaHitBlock(EndFluidStack fstack, FluidBlob blob, Level level, BlockHitResult result) {
        if (!level.f_46443_) {
            DefaultFluidCompat.spawnFire(result.m_82425_().m_121945_(result.m_82434_()), blob, level);
        }
    }

    public static void potionHitBlock(EndFluidStack fstack, FluidBlob blob, Level level, BlockHitResult result) {
        if (!level.f_46443_) {
            DefaultFluidCompat.spawnAreaEffectCloud(result.m_82425_().m_121945_(result.m_82434_()), blob, level);
        }
    }

    public static void douseFire(BlockPos root, FluidBlob blob, Level level) {
        float chance = FluidBlob.getBlockAffectChance();
        AABB bounds = blob.getAreaOfEffect(root);
        BlockPos pos1 = BlockPos.m_274561_((double)bounds.f_82288_, (double)bounds.f_82289_, (double)bounds.f_82290_);
        BlockPos pos2 = BlockPos.m_274561_((double)bounds.f_82291_, (double)bounds.f_82292_, (double)bounds.f_82293_);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)pos1, (BlockPos)pos2)) {
            if (chance == 0.0f || level.m_213780_().m_188501_() > chance) continue;
            BlockState state = level.m_8055_(pos);
            if (state.m_204336_(BlockTags.f_13076_)) {
                level.m_7471_(pos, false);
                continue;
            }
            if (AbstractCandleBlock.m_151933_((BlockState)state)) {
                AbstractCandleBlock.m_151899_(null, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
                continue;
            }
            if (!CampfireBlock.m_51319_((BlockState)state)) continue;
            level.m_5898_(null, 1009, pos, 0);
            CampfireBlock.m_152749_((Entity)blob.m_19749_(), (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
        }
    }

    public static void spawnFire(BlockPos root, FluidBlob blob, Level level) {
        float chance = FluidBlob.getBlockAffectChance();
        AABB bounds = blob.getAreaOfEffect(root);
        BlockPos pos1 = BlockPos.m_274561_((double)bounds.f_82288_, (double)bounds.f_82289_, (double)bounds.f_82290_);
        BlockPos pos2 = BlockPos.m_274561_((double)bounds.f_82291_, (double)bounds.f_82292_, (double)bounds.f_82293_);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)pos1, (BlockPos)pos2)) {
            if (!(chance > 0.0f) || !(level.m_213780_().m_188501_() <= chance) || !level.m_46859_(pos)) continue;
            level.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos));
        }
    }

    public static void spawnAreaEffectCloud(BlockPos pos, FluidBlob blob, Level level) {
        CompoundTag tag = blob.getFluidStack().data();
        AreaEffectCloud aec = (AreaEffectCloud)EntityType.f_20476_.m_20615_(level);
        aec.m_146884_(Vec3.m_82512_((Vec3i)pos));
        aec.m_19712_((float)(blob.getBlobSize() * 2));
        aec.m_19732_(-0.5f);
        aec.m_19740_(10);
        aec.m_19738_(-aec.m_19743_() / (float)aec.m_19748_());
        aec.m_19722_(PotionUtils.m_43577_((CompoundTag)tag));
        for (MobEffectInstance effect : PotionUtils.m_43566_((CompoundTag)tag)) {
            aec.m_19716_(new MobEffectInstance(effect));
        }
        aec.m_19714_(PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)tag)) | 0xFF000000);
        level.m_7967_((Entity)aec);
    }
}

