/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.grapeshot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import rbasamoyai.createbigcannons.munitions.big_cannon.BigCannonProjectileProperties;
import rbasamoyai.createbigcannons.munitions.config.MunitionPropertiesSerializer;

public class GrapeshotBagProperties
extends BigCannonProjectileProperties {
    private final float grapeshotDamage;
    private final double grapeshotSpread;
    private final int grapeshotCount;

    public GrapeshotBagProperties(float entityDamage, float durabilityMass, boolean rendersInvulnerable, boolean ignoresEntityArmor, double gravity, double drag, float knockback, int addedChargePower, float minimumChargePower, boolean canSquib, float addedRecoil, float grapeshotDamage, double grapeshotSpread, int grapeshotCount) {
        super(entityDamage, durabilityMass, rendersInvulnerable, ignoresEntityArmor, gravity, drag, knockback, addedChargePower, minimumChargePower, canSquib, addedRecoil);
        this.grapeshotDamage = grapeshotDamage;
        this.grapeshotSpread = grapeshotSpread;
        this.grapeshotCount = grapeshotCount;
    }

    public GrapeshotBagProperties(String id, JsonObject obj) {
        super(id, obj);
        this.grapeshotDamage = Math.max(0.0f, MunitionPropertiesSerializer.getOrWarn(obj, "grapeshot_entity_damage", id, Float.valueOf(1.0f), JsonElement::getAsFloat).floatValue());
        this.grapeshotSpread = Math.max(0.0, MunitionPropertiesSerializer.getOrWarn(obj, "grapeshot_spread", id, 1.0, JsonElement::getAsDouble));
        this.grapeshotCount = Math.max(0, MunitionPropertiesSerializer.getOrWarn(obj, "grapeshot_count", id, 1, JsonElement::getAsInt));
    }

    public GrapeshotBagProperties(FriendlyByteBuf buf) {
        super(buf);
        this.grapeshotDamage = buf.readFloat();
        this.grapeshotSpread = buf.readDouble();
        this.grapeshotCount = buf.m_130242_();
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.writeFloat(this.grapeshotDamage).writeDouble(this.grapeshotSpread);
        buf.m_130130_(this.grapeshotCount);
    }

    public float grapeshotDamage() {
        return this.grapeshotDamage;
    }

    public double grapeshotSpread() {
        return this.grapeshotSpread;
    }

    public int grapeshotCount() {
        return this.grapeshotCount;
    }

    public static class Serializer
    implements MunitionPropertiesSerializer<GrapeshotBagProperties> {
        @Override
        public GrapeshotBagProperties fromJson(ResourceLocation loc, JsonObject obj) {
            return new GrapeshotBagProperties(loc.toString(), obj);
        }

        @Override
        public GrapeshotBagProperties fromNetwork(ResourceLocation loc, FriendlyByteBuf buf) {
            return new GrapeshotBagProperties(buf);
        }
    }
}

