/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.shrapnel;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.index.CBCDamageTypes;
import rbasamoyai.createbigcannons.munitions.BaseProjectileProperties;
import rbasamoyai.createbigcannons.munitions.CannonDamageSource;
import rbasamoyai.createbigcannons.munitions.config.DimensionMunitionPropertiesHandler;
import rbasamoyai.createbigcannons.munitions.config.PropertiesMunitionEntity;

public class Shrapnel
extends AbstractHurtingProjectile
implements PropertiesMunitionEntity<BaseProjectileProperties> {
    protected float damage;
    protected float mass;
    private int age;

    public Shrapnel(EntityType<? extends Shrapnel> type, Level level) {
        super(type, level);
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        this.mass = properties == null ? 0.0f : properties.durabilityMass();
    }

    public static <T extends Shrapnel> List<T> spawnShrapnelBurst(Level level, EntityType<T> type, Vec3 position, Vec3 initialVelocity, int count, double spread, float damage) {
        Vec3 forward = initialVelocity.m_82541_();
        Vec3 right = forward.m_82537_(new Vec3(Direction.UP.m_253071_()));
        Vec3 up = forward.m_82537_(right);
        double length = initialVelocity.m_82553_();
        RandomSource random = level.m_213780_();
        ArrayList<Shrapnel> list = new ArrayList<Shrapnel>();
        for (int i = 0; i < count; ++i) {
            double velScale = length * (1.4 + 0.2 * random.m_188500_());
            Vec3 vel = forward.m_82490_(velScale).m_82549_(right.m_82490_((random.m_188500_() - random.m_188500_()) * velScale * spread)).m_82549_(up.m_82490_((random.m_188500_() - random.m_188500_()) * velScale * spread));
            Shrapnel shrapnel = (Shrapnel)type.m_20615_(level);
            double rx = position.f_82479_ + (random.m_188500_() - random.m_188500_()) * 0.0625;
            double ry = position.f_82480_ + (random.m_188500_() - random.m_188500_()) * 0.0625;
            double rz = position.f_82481_ + (random.m_188500_() - random.m_188500_()) * 0.0625;
            shrapnel.m_6034_(rx, ry, rz);
            shrapnel.m_20256_(vel);
            shrapnel.setDamage(damage);
            if (!level.m_7967_((Entity)shrapnel)) continue;
            list.add(shrapnel);
        }
        if (list.size() != count) {
            CreateBigCannons.LOGGER.info("Shrapnel burst failed to spawn {} out of {} shrapnel bullets", (Object)(count - list.size()), (Object)count);
        }
        return list;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.age;
        if (!this.m_20068_() && this.getGravity() < 0.0f) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)this.getGravity(), 0.0));
        }
        if (!this.m_9236_().f_46443_ && this.age > 20) {
            this.m_146870_();
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Age", this.age);
        tag.m_128350_("Damage", this.damage);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.age = tag.m_128451_("Age");
        this.damage = tag.m_128457_("Damage");
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_46865_(pos).m_8055_(pos);
        if (!this.m_9236_().f_46443_ && state.m_60800_((BlockGetter)this.m_9236_(), pos) != -1.0f && this.canDestroyBlock(state)) {
            Vec3 curVel = this.m_20184_();
            double curPom = (double)this.getProjectileMass() * curVel.m_82553_();
            double hardness = BlockArmorPropertiesHandler.getProperties(state).hardness(this.m_9236_(), state, pos, true) * 10.0;
            CreateBigCannons.BLOCK_DAMAGE.damageBlock(pos.m_7949_(), (int)Math.min(curPom, hardness), state, this.m_9236_());
            SoundType type = state.m_60827_();
            this.m_9236_().m_5594_(null, pos, type.m_56775_(), SoundSource.NEUTRAL, type.m_56773_() * 0.25f, type.m_56774_());
            this.m_146870_();
        }
    }

    protected boolean canDestroyBlock(BlockState state) {
        return true;
    }

    protected float getProjectileMass() {
        return this.mass;
    }

    protected void m_5790_(EntityHitResult result) {
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        if (properties == null || properties.ignoresEntityArmor()) {
            result.m_82443_().f_19802_ = 0;
        }
        result.m_82443_().m_6469_(this.getDamageSource(), this.damage);
        if (properties == null || !properties.rendersInvulnerable()) {
            result.m_82443_().f_19802_ = 0;
        }
    }

    protected void m_6532_(HitResult result) {
        EntityHitResult eResult;
        super.m_6532_(result);
        if (!(this.m_9236_().f_46443_ || result instanceof EntityHitResult && (eResult = (EntityHitResult)result).m_82443_().m_6095_() == this.m_6095_())) {
            this.m_146870_();
        }
    }

    protected DamageSource getDamageSource() {
        return new CannonDamageSource((Holder<DamageType>)CannonDamageSource.getDamageRegistry(this.m_9236_()).m_246971_(CBCDamageTypes.SHRAPNEL), (Entity)this);
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return 0.125f;
    }

    protected float m_6884_() {
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        float baseDrag = properties == null ? 0.99f : (float)properties.drag();
        float scalar = (float)DimensionMunitionPropertiesHandler.getProperties(this.m_9236_()).dragMultiplier();
        if (scalar <= 1.0f) {
            return Mth.m_14179_((float)scalar, (float)1.0f, (float)baseDrag);
        }
        float diff = baseDrag - 1.0f;
        return (float)Mth.m_14008_((double)(baseDrag + diff * (scalar - 1.0f)), (double)0.9, (double)baseDrag);
    }

    protected float getGravity() {
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        float val = properties == null ? -0.05f : (float)properties.gravity();
        float multiplier = (float)DimensionMunitionPropertiesHandler.getProperties(this.m_9236_()).gravityMultiplier();
        return val * multiplier;
    }

    protected boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && !(entity instanceof Projectile);
    }
}

