/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.config.DimensionMunitionProperties;
import rbasamoyai.createbigcannons.network.RootPacket;

public class DimensionMunitionPropertiesHandler {
    public static Map<ResourceKey<Level>, DimensionMunitionProperties> DIMENSIONS = new HashMap<ResourceKey<Level>, DimensionMunitionProperties>();
    private static final DimensionMunitionProperties DEFAULT = new DimensionMunitionProperties(1.0, 1.0);

    public static DimensionMunitionProperties getProperties(ResourceKey<Level> dimension) {
        return DIMENSIONS.getOrDefault(dimension, DEFAULT);
    }

    public static DimensionMunitionProperties getProperties(Level level) {
        return DimensionMunitionPropertiesHandler.getProperties((ResourceKey<Level>)level.m_46472_());
    }

    public static void writeBuf(FriendlyByteBuf buf) {
        buf.m_130130_(DIMENSIONS.size());
        for (Map.Entry<ResourceKey<Level>, DimensionMunitionProperties> entry : DIMENSIONS.entrySet()) {
            buf.m_130085_(entry.getKey().m_135782_());
            entry.getValue().toNetwork(buf);
        }
    }

    public static void readBuf(FriendlyByteBuf buf) {
        DIMENSIONS.clear();
        int sz = buf.m_130242_();
        for (int i = 0; i < sz; ++i) {
            ResourceLocation loc = buf.m_130281_();
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)loc);
            DimensionMunitionProperties properties = DimensionMunitionProperties.fromNetwork(buf);
            DIMENSIONS.put((ResourceKey<Level>)key, properties);
        }
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundSyncDimensionMunitionPropertiesPacket(), server);
    }

    public static void syncTo(ServerPlayer player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundSyncDimensionMunitionPropertiesPacket(), player);
    }

    public record ClientboundSyncDimensionMunitionPropertiesPacket(@Nullable FriendlyByteBuf buf) implements RootPacket
    {
        public ClientboundSyncDimensionMunitionPropertiesPacket() {
            this(null);
        }

        public static ClientboundSyncDimensionMunitionPropertiesPacket copyOf(FriendlyByteBuf buf) {
            return new ClientboundSyncDimensionMunitionPropertiesPacket(new FriendlyByteBuf(buf.copy()));
        }

        @Override
        public void rootEncode(FriendlyByteBuf buf) {
            DimensionMunitionPropertiesHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, PacketListener listener, @Nullable ServerPlayer sender) {
            if (this.buf != null) {
                DimensionMunitionPropertiesHandler.readBuf(this.buf);
            }
        }
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        protected ReloadListener() {
            super(GSON, "dimension_munition_properties");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
            DIMENSIONS.clear();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                try {
                    ResourceLocation entityLoc = entry.getKey();
                    ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)entry.getKey());
                    DimensionMunitionProperties properties = DimensionMunitionProperties.fromJson(element.getAsJsonObject(), entityLoc.toString());
                    DIMENSIONS.put((ResourceKey<Level>)dimension, properties);
                }
                catch (Exception exception) {}
            }
        }
    }
}

