/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.stream.Collectors;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.MinecraftClient_BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.BetterCombatClient;
import net.bettercombat.client.collision.OrientedBoundingBox;
import net.bettercombat.client.collision.TargetFinder;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.mixin.client.MinecraftClientAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugRenderer.class})
public class ColliderDebugRenderer {
    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void renderColliderDebug(PoseStack matrices, MultiBufferSource.BufferSource vertexConsumers, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        Minecraft client = Minecraft.m_91087_();
        if (!((MinecraftClientAccessor)client).getEntityRenderDispatcher().m_114377_()) {
            return;
        }
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return;
        }
        if (!BetterCombatClient.config.isDebugOBBEnabled) {
            return;
        }
        Camera camera = client.f_91063_.m_109153_();
        if (!camera.m_90593_()) {
            return;
        }
        if (client.f_91074_.m_21205_() == null) {
            return;
        }
        MinecraftClient_BetterCombat extendedClient = (MinecraftClient_BetterCombat)client;
        int comboCount = extendedClient.getComboCount();
        AttackHand hand = PlayerAttackHelper.getCurrentAttack((Player)client.f_91074_, comboCount);
        if (hand == null) {
            return;
        }
        WeaponAttributes attributes = hand.attributes();
        if (attributes == null) {
            return;
        }
        Entity cursorTarget = extendedClient.getCursorTarget();
        TargetFinder.TargetResult target = TargetFinder.findAttackTargetResult((Player)player, cursorTarget, hand.attack(), attributes.attackRange());
        boolean collides = target.entities.size() > 0;
        Vec3 cameraOffset = camera.m_90583_().m_82548_();
        OrientedBoundingBox obb = target.obb.copy().offset(cameraOffset).updateVertex();
        List<OrientedBoundingBox> collidingObbs = target.entities.stream().map(entity -> new OrientedBoundingBox(entity.m_20191_()).offset(cameraOffset).scale(0.95).updateVertex()).collect(Collectors.toList());
        this.drawOutline(matrices, obb, collidingObbs, collides);
    }

    private void drawOutline(PoseStack matrixStack, OrientedBoundingBox obb, List<OrientedBoundingBox> otherObbs, boolean collides) {
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        if (collides) {
            this.outlineOBB(matrixStack, obb, bufferBuilder, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f);
        } else {
            this.outlineOBB(matrixStack, obb, bufferBuilder, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.5f);
        }
        this.look(matrixStack, obb, bufferBuilder, 0.5f);
        for (OrientedBoundingBox otherObb : otherObbs) {
            this.outlineOBB(matrixStack, otherObb, bufferBuilder, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f);
        }
        tessellator.m_85914_();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableBlend();
    }

    private void outlineOBB(PoseStack matrixStack, OrientedBoundingBox box, BufferBuilder buffer, float red1, float green1, float blue1, float red2, float green2, float blue2, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        buffer.m_252986_(matrix4f, (float)box.vertex1.f_82479_, (float)box.vertex1.f_82480_, (float)box.vertex1.f_82481_).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex1.f_82479_, (float)box.vertex1.f_82480_, (float)box.vertex1.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex2.f_82479_, (float)box.vertex2.f_82480_, (float)box.vertex2.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex3.f_82479_, (float)box.vertex3.f_82480_, (float)box.vertex3.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex4.f_82479_, (float)box.vertex4.f_82480_, (float)box.vertex4.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex1.f_82479_, (float)box.vertex1.f_82480_, (float)box.vertex1.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex5.f_82479_, (float)box.vertex5.f_82480_, (float)box.vertex5.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex6.f_82479_, (float)box.vertex6.f_82480_, (float)box.vertex6.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex2.f_82479_, (float)box.vertex2.f_82480_, (float)box.vertex2.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex6.f_82479_, (float)box.vertex6.f_82480_, (float)box.vertex6.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex7.f_82479_, (float)box.vertex7.f_82480_, (float)box.vertex7.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex3.f_82479_, (float)box.vertex3.f_82480_, (float)box.vertex3.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex7.f_82479_, (float)box.vertex7.f_82480_, (float)box.vertex7.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex8.f_82479_, (float)box.vertex8.f_82480_, (float)box.vertex8.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex4.f_82479_, (float)box.vertex4.f_82480_, (float)box.vertex4.f_82481_).m_85950_(red1, green1, blue1, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex8.f_82479_, (float)box.vertex8.f_82480_, (float)box.vertex8.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex5.f_82479_, (float)box.vertex5.f_82480_, (float)box.vertex5.f_82481_).m_85950_(red2, green2, blue2, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.vertex5.f_82479_, (float)box.vertex5.f_82480_, (float)box.vertex5.f_82481_).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_6122_(0, 0, 0, 0).m_5752_();
    }

    private void look(PoseStack matrixStack, OrientedBoundingBox box, BufferBuilder buffer, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_85950_(0.0f, 0.0f, 0.0f, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_85950_(1.0f, 0.0f, 0.0f, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.axisZ.f_82479_, (float)box.axisZ.f_82480_, (float)box.axisZ.f_82481_).m_85950_(1.0f, 0.0f, 0.0f, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_85950_(1.0f, 0.0f, 0.0f, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_85950_(0.0f, 1.0f, 0.0f, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.axisY.f_82479_, (float)box.axisY.f_82480_, (float)box.axisY.f_82481_).m_85950_(0.0f, 1.0f, 0.0f, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_85950_(0.0f, 1.0f, 0.0f, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_85950_(0.0f, 0.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.axisX.f_82479_, (float)box.axisX.f_82480_, (float)box.axisX.f_82481_).m_85950_(0.0f, 0.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_85950_(0.0f, 0.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix4f, (float)box.center.f_82479_, (float)box.center.f_82480_, (float)box.center.f_82481_).m_85950_(0.0f, 0.0f, 0.0f, alpha).m_5752_();
    }

    public void printDebug(OrientedBoundingBox obb) {
        Vec3 extent_x = obb.axisX.m_82490_(obb.extent.f_82479_);
        Vec3 extent_y = obb.axisY.m_82490_(obb.extent.f_82480_);
        Vec3 extent_z = obb.axisZ.m_82490_(obb.extent.f_82481_);
        System.out.println("Center: " + this.vec3Short(obb.center) + " Extent: " + this.vec3Short(obb.extent));
        System.out.println("scaledAxisX: " + this.vec3Short(obb.scaledAxisX) + "scaledAxisY: " + this.vec3Short(obb.scaledAxisY) + "scaledAxisZ: " + this.vec3Short(obb.scaledAxisZ));
        System.out.println("1:" + this.vec3Short(obb.vertex1) + " 2:" + this.vec3Short(obb.vertex2) + " 3:" + this.vec3Short(obb.vertex3) + " 4:" + this.vec3Short(obb.vertex4));
        System.out.println("5:" + this.vec3Short(obb.vertex5) + " 6:" + this.vec3Short(obb.vertex6) + " 7:" + this.vec3Short(obb.vertex7) + " 8:" + this.vec3Short(obb.vertex8));
    }

    private String vec3Short(Vec3 vec) {
        return "{" + String.format("%.3f", vec.f_82479_) + ", " + String.format("%.3f", vec.f_82480_) + ", " + String.format("%.3f", vec.f_82481_) + "}";
    }

    private Vec3[] getVertices(AABB box) {
        return new Vec3[]{new Vec3(box.f_82288_, (double)((float)box.f_82289_), (double)((float)box.f_82290_)), new Vec3(box.f_82291_, (double)((float)box.f_82289_), (double)((float)box.f_82290_)), new Vec3(box.f_82288_, (double)((float)box.f_82292_), (double)((float)box.f_82290_)), new Vec3(box.f_82288_, (double)((float)box.f_82289_), (double)((float)box.f_82293_)), new Vec3(box.f_82291_, (double)((float)box.f_82292_), (double)((float)box.f_82290_)), new Vec3(box.f_82288_, (double)((float)box.f_82292_), (double)((float)box.f_82293_)), new Vec3(box.f_82291_, (double)((float)box.f_82289_), (double)((float)box.f_82293_)), new Vec3(box.f_82291_, (double)((float)box.f_82292_), (double)((float)box.f_82293_))};
    }
}

