/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.core;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.core.IWorldMapClientPlayNetHandler;
import xaero.map.core.IWorldMapSMultiBlockChangePacket;
import xaero.map.file.MapSaveLoad;
import xaero.map.misc.Misc;

public class XaeroWorldMapCore {
    public static Field chunkCleanField = null;
    public static WorldMapSession currentSession;

    public static void ensureField() {
        if (chunkCleanField == null) {
            try {
                chunkCleanField = LevelChunk.class.getDeclaredField("xaero_wm_chunkClean");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void chunkUpdateCallback(int chunkX, int chunkZ) {
        XaeroWorldMapCore.ensureField();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            try {
                for (int x = chunkX - 1; x < chunkX + 2; ++x) {
                    for (int z = chunkZ - 1; z < chunkZ + 2; ++z) {
                        LevelChunk chunk = world.m_6325_(x, z);
                        if (chunk == null) continue;
                        chunkCleanField.set(chunk, false);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onChunkData(int x, int z, ClientboundLevelChunkPacketData packetIn) {
        XaeroWorldMapCore.chunkUpdateCallback(x, z);
    }

    public static void onChunkLightData(int x, int z) {
        XaeroWorldMapCore.chunkUpdateCallback(x, z);
    }

    public static void onHandleLevelChunkWithLight(ClientboundLevelChunkWithLightPacket packet) {
        XaeroWorldMapCore.onChunkLightData(packet.m_195717_(), packet.m_195718_());
    }

    public static void onHandleLightUpdatePacket(ClientboundLightUpdatePacket packet) {
        XaeroWorldMapCore.onChunkLightData(packet.m_132349_(), packet.m_132352_());
    }

    public static void onQueueLightRemoval(ClientboundForgetLevelChunkPacket packet) {
        XaeroWorldMapCore.onChunkLightData(packet.m_132149_(), packet.m_132152_());
    }

    public static void onBlockChange(ClientboundBlockUpdatePacket packetIn) {
        XaeroWorldMapCore.chunkUpdateCallback(packetIn.m_131749_().m_123341_() >> 4, packetIn.m_131749_().m_123343_() >> 4);
    }

    public static void onMultiBlockChange(ClientboundSectionBlocksUpdatePacket packetIn) {
        IWorldMapSMultiBlockChangePacket packetAccess = (IWorldMapSMultiBlockChangePacket)packetIn;
        XaeroWorldMapCore.chunkUpdateCallback(packetAccess.xaero_wm_getSectionPos().m_123341_(), packetAccess.xaero_wm_getSectionPos().m_123343_());
    }

    public static void onPlayNetHandler(ClientPacketListener netHandler, ClientboundLoginPacket packet) {
        if (!WorldMap.loaded) {
            return;
        }
        try {
            WorldMapSession worldmapSession;
            IWorldMapClientPlayNetHandler netHandlerAccess = (IWorldMapClientPlayNetHandler)netHandler;
            if (netHandlerAccess.getXaero_worldmapSession() != null) {
                return;
            }
            if (currentSession != null) {
                WorldMap.LOGGER.info("Previous world map session still active. Probably using MenuMobs. Forcing it to end...");
                XaeroWorldMapCore.cleanupCurrentSession();
            }
            currentSession = worldmapSession = new WorldMapSession();
            worldmapSession.init(netHandler, packet.f_132361_());
            netHandlerAccess.setXaero_worldmapSession(worldmapSession);
            WorldMap.settings.updateRegionCacheHashCode();
        }
        catch (Throwable e) {
            if (currentSession != null) {
                XaeroWorldMapCore.cleanupCurrentSession();
            }
            RuntimeException wrappedException = new RuntimeException("Exception initializing Xaero's World Map! ", e);
            WorldMap.crashHandler.setCrashedBy(wrappedException);
        }
    }

    private static void cleanupCurrentSession() {
        try {
            currentSession.cleanup();
        }
        catch (Throwable supressed) {
            WorldMap.LOGGER.error("suppressed exception", supressed);
        }
        finally {
            currentSession = null;
        }
    }

    public static void onPlayNetHandlerCleanup(ClientPacketListener netHandler) {
        if (!WorldMap.loaded) {
            return;
        }
        try {
            WorldMapSession netHandlerSession = ((IWorldMapClientPlayNetHandler)netHandler).getXaero_worldmapSession();
            if (netHandlerSession == null) {
                return;
            }
            try {
                netHandlerSession.cleanup();
            }
            finally {
                if (netHandlerSession == currentSession) {
                    currentSession = null;
                }
                ((IWorldMapClientPlayNetHandler)netHandler).setXaero_worldmapSession(null);
            }
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception finalizing Xaero's World Map! ", e);
            WorldMap.crashHandler.setCrashedBy(wrappedException);
        }
    }

    public static void onDeleteWorld(LevelStorageSource.LevelStorageAccess levelStorageAccess) {
        Path worldMapCacheFolder;
        if (!WorldMap.loaded) {
            return;
        }
        Path worldName = levelStorageAccess.m_78283_(LevelResource.f_78182_).getParent().getFileName();
        if (!worldName.toString().isEmpty() && (worldMapCacheFolder = MapSaveLoad.getRootFolder(worldName.toString())).toFile().exists()) {
            try {
                Misc.deleteFileIf(worldMapCacheFolder, path -> {
                    String pathString = worldMapCacheFolder.relativize((Path)path).toString().replace('\\', '/');
                    return pathString.contains("/cache/") || pathString.endsWith("/cache") || pathString.contains("/cache_");
                }, 20);
                WorldMap.LOGGER.info(String.format("Deleted world map cache at %s", worldMapCacheFolder));
            }
            catch (IOException e) {
                WorldMap.LOGGER.error(String.format("Failed to delete world map cache at %s!", worldMapCacheFolder), (Throwable)e);
            }
        }
    }

    public static void onMinecraftRunTick() {
        if (WorldMap.events != null) {
            WorldMap.events.handleClientRunTickStart();
        }
    }

    public static boolean onSystemChat(Component component) {
        if (!WorldMap.loaded) {
            return false;
        }
        return WorldMap.events.handleClientSystemChatReceivedEvent(component);
    }

    public static boolean onHandleDisguisedChatMessage(ChatType.Bound chatType, Component component) {
        if (!WorldMap.loaded) {
            return true;
        }
        return !WorldMap.events.handleClientPlayerChatReceivedEvent(chatType, component, null);
    }

    public static boolean onRenderCall(boolean renderingInGame) {
        if (!WorldMap.loaded) {
            return renderingInGame;
        }
        if (WorldMap.events.handleRenderTick(true)) {
            return false;
        }
        return renderingInGame;
    }

    public static void handlePlayerSetSpawnPacket(ClientboundSetDefaultSpawnPositionPacket packet) {
        if (!WorldMap.loaded) {
            return;
        }
        WorldMap.events.handlePlayerSetSpawnEvent(packet.m_133123_(), Minecraft.m_91087_().f_91073_);
    }

    public static boolean onRenderCrosshair(GuiGraphics guiGraphics) {
        if (!WorldMap.loaded) {
            return false;
        }
        return WorldMap.events.handleRenderCrosshairOverlay(guiGraphics);
    }
}

