/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.decorations;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.apexcore.lib.block.BaseMultiBlock;
import xyz.apex.forge.apexcore.lib.block.MultiBlockPattern;
import xyz.apex.forge.apexcore.lib.block.VoxelShaper;
import xyz.apex.forge.fantasyfurniture.AllPatterns;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.IDyeable;

public class WallMirrorMultiBlock
extends BaseMultiBlock {
    public static final VoxelShape SHAPE = VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)2.0, (double)15.0, (double)4.0, (double)5.0, (double)16.0), Block.m_49796_((double)1.0, (double)27.0, (double)15.0, (double)4.0, (double)30.0, (double)16.0), Block.m_49796_((double)12.0, (double)27.0, (double)15.0, (double)15.0, (double)30.0, (double)16.0), Block.m_49796_((double)12.0, (double)2.0, (double)15.0, (double)15.0, (double)5.0, (double)16.0), Block.m_49796_((double)2.0, (double)3.0, (double)15.0, (double)14.0, (double)29.0, (double)16.0)});
    public static final VoxelShaper SHAPER = VoxelShaper.forHorizontal((VoxelShape)SHAPE, (Direction)Direction.NORTH);

    public WallMirrorMultiBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void registerProperties(Consumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        consumer.accept((Property<?>)FACING_4_WAY);
        consumer.accept((Property<?>)WATERLOGGED);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        Direction facing = BaseBlock.getFacing((BlockState)blockState);
        VoxelShape shape = SHAPER.get(facing);
        return this.isMultiBlockOrigin(blockState) ? shape : shape.m_83216_(0.0, -1.0, 0.0);
    }

    public MultiBlockPattern getMultiBlockPattern() {
        return AllPatterns.PATTERN_1x1x2;
    }

    public static class Dyeable
    extends WallMirrorMultiBlock
    implements IDyeable {
        public Dyeable(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_(IDyeable.registerDefaultBlockState(this.m_49966_()));
        }

        public MapColor getMapColor(BlockState blockState, BlockGetter level, BlockPos pos, MapColor defaultColor) {
            MapColor mapColor = super.getMapColor(blockState, level, pos, defaultColor);
            return IDyeable.getDyedMapColor(blockState, level, pos, mapColor);
        }

        @Override
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            IDyeable.registerProperties(consumer);
        }

        @Nullable
        protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
            placementBlockState = super.modifyPlacementState(placementBlockState, ctx);
            return IDyeable.getStateForPlacement(ctx, placementBlockState);
        }

        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
            InteractionResult interactionResult = IDyeable.use(blockState, level, pos, player, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            return super.m_6227_(blockState, level, pos, player, hand, result);
        }

        public ItemStack getCloneItemStack(BlockState blockState, HitResult target, BlockGetter level, BlockPos pos, Player player) {
            ItemStack stack = super.getCloneItemStack(blockState, target, level, pos, player);
            return IDyeable.getCloneItemStack(blockState, level, pos, stack);
        }

        public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
            super.m_5871_(stack, level, tooltip, flag);
            IDyeable.appendHoverText(this, tooltip);
        }
    }
}

