/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client;

import de.cristelknight.doapi.client.render.block.storage.api.StorageBlockEntityRenderer;
import de.cristelknight.doapi.client.render.block.storage.api.StorageTypeRenderer;
import de.cristelknight.doapi.terraform.sign.TerraformSignHelper;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.satisfy.meadow.client.gui.CheeseFormGui;
import net.satisfy.meadow.client.gui.CookingCauldronGui;
import net.satisfy.meadow.client.gui.FondueGui;
import net.satisfy.meadow.client.gui.WoodcutterGui;
import net.satisfy.meadow.client.model.FurArmorHat;
import net.satisfy.meadow.client.model.WaterBuffaloModel;
import net.satisfy.meadow.client.model.WoolyCowModel;
import net.satisfy.meadow.client.render.block.storage.CheeseRackRenderer;
import net.satisfy.meadow.client.render.block.storage.FlowerPotSmallRenderer;
import net.satisfy.meadow.client.render.block.storage.WheelBarrowRenderer;
import net.satisfy.meadow.client.render.entity.ShearableVarCowRenderer;
import net.satisfy.meadow.client.render.entity.WaterBuffaloRenderer;
import net.satisfy.meadow.registry.ArmorRegistry;
import net.satisfy.meadow.registry.BoatsAndSignsRegistry;
import net.satisfy.meadow.registry.EntityRegistry;
import net.satisfy.meadow.registry.ObjectRegistry;
import net.satisfy.meadow.registry.ScreenHandlerRegistry;
import net.satisfy.meadow.registry.StorageTypeRegistry;

public class MeadowClient {
    public static final ModelLayerLocation SHEARABLE_MEADOW_COW_MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("meadow", "shearable_meadow_cow"), "head");
    public static final ModelLayerLocation WATER_BUFFALO_MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("meadow", "water_buffalo"), "head");

    public static void preInitClient() {
        MeadowClient.registerEntityRenderers();
        MeadowClient.registerEntityModelLayers();
        TerraformSignHelper.regsterSignSprite((ResourceLocation)BoatsAndSignsRegistry.PINE_SIGN_TEXTURE);
        TerraformSignHelper.regsterSignSprite((ResourceLocation)BoatsAndSignsRegistry.PINE_HANGING_SIGN_TEXTURE);
    }

    public static void initClient() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)ObjectRegistry.PINE_DOOR.get(), (Block)ObjectRegistry.PINE_TRAPDOOR.get(), (Block)ObjectRegistry.DELPHINIUM.get(), (Block)ObjectRegistry.ALPINE_POPPY.get(), (Block)ObjectRegistry.SAXIFRAGE.get(), (Block)ObjectRegistry.ENZIAN.get(), (Block)ObjectRegistry.COOKING_CAULDRON.get(), (Block)ObjectRegistry.FRAME.get(), (Block)ObjectRegistry.TABLE.get(), (Block)ObjectRegistry.FIRE_LOG.get(), (Block)ObjectRegistry.ERIOPHORUM.get(), (Block)ObjectRegistry.ERIOPHORUM_TALL.get(), (Block)ObjectRegistry.SMALL_FIR.get(), (Block)ObjectRegistry.PINE_SAPLING.get(), (Block)ObjectRegistry.CHAIR.get(), (Block)ObjectRegistry.POTTED_DELPHINIUM.get(), (Block)ObjectRegistry.POTTED_ALPINE_POPPY.get(), (Block)ObjectRegistry.POTTED_SAXIFRAGE.get(), (Block)ObjectRegistry.POTTED_ENZIAN.get(), (Block)ObjectRegistry.POTTED_ERIOPHORUM.get(), (Block)ObjectRegistry.ERIOPHORUM_TALL.get(), (Block)ObjectRegistry.PINE_SAPLING.get(), (Block)ObjectRegistry.POTTED_PINE_SAPLING.get(), (Block)ObjectRegistry.FIRE_LILY.get(), (Block)ObjectRegistry.POTTED_FIRE_LILY.get(), (Block)ObjectRegistry.WOODEN_FLOWER_POT_SMALL.get(), (Block)ObjectRegistry.FONDUE.get(), (Block)ObjectRegistry.OIL_LANTERN.get(), (Block)ObjectRegistry.WHEELBARROW.get(), (Block)ObjectRegistry.PINE_LEAVES_2.get(), (Block)ObjectRegistry.WOODEN_FLOWER_POT_BIG.get(), (Block)ObjectRegistry.WOODCUTTER.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)ObjectRegistry.HEART_PATTERNED_WINDOW.get(), (Block)ObjectRegistry.SUN_PATTERNED_WINDOW.get(), (Block)ObjectRegistry.PINE_WINDOW.get()});
        MeadowClient.registerStorageTypeRenderers();
        MeadowClient.registerClientScreens();
        ColorHandlerRegistry.registerBlockColors((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return BiomeColors.m_108811_((BlockAndTintGetter)world, (BlockPos)pos);
        }, (Supplier[])new Supplier[]{ObjectRegistry.WOODEN_WATER_CAULDRON, ObjectRegistry.WATERING_CAN});
    }

    public static void registerStorageTypeRenderers() {
        StorageBlockEntityRenderer.registerStorageType((ResourceLocation)StorageTypeRegistry.WHEEL_BARROW, (StorageTypeRenderer)new WheelBarrowRenderer());
        StorageBlockEntityRenderer.registerStorageType((ResourceLocation)StorageTypeRegistry.FLOWER_POT_SMALL, (StorageTypeRenderer)new FlowerPotSmallRenderer());
        StorageBlockEntityRenderer.registerStorageType((ResourceLocation)StorageTypeRegistry.CHEESE_RACK, (StorageTypeRenderer)new CheeseRackRenderer());
    }

    private static void registerClientScreens() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenHandlerRegistry.CHEESE_FORM_SCREEN_HANDLER.get()), CheeseFormGui::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenHandlerRegistry.WOODCUTTER_SCREEN_HANDLER.get()), WoodcutterGui::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenHandlerRegistry.COOKING_CAULDRON_SCREEN_HANDLER.get()), CookingCauldronGui::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenHandlerRegistry.FONDUE_SCREEN_HANDLER.get()), FondueGui::new);
    }

    private static void registerEntityRenderers() {
        EntityRendererRegistry.register(EntityRegistry.SHEARABLE_MEADOW_VAR_COW, ShearableVarCowRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.WATER_BUFFALO, WaterBuffaloRenderer::new);
    }

    public static void registerEntityModelLayers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)FurArmorHat.LAYER_LOCATION, FurArmorHat::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)SHEARABLE_MEADOW_COW_MODEL_LAYER, WoolyCowModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)WATER_BUFFALO_MODEL_LAYER, WaterBuffaloModel::getTexturedModelData);
        ArmorRegistry.registerArmorModelLayers();
    }
}

