/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.satisfy.meadow.block.entity.CookingCauldronBlockEntity;
import net.satisfy.meadow.client.gui.CookingCauldronGui;
import net.satisfy.meadow.compat.jei.MeadowJEIPlugin;
import net.satisfy.meadow.recipes.CookingCauldronRecipe;
import net.satisfy.meadow.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class CookingCauldronCategory
implements IRecipeCategory<CookingCauldronRecipe> {
    public static final RecipeType<CookingCauldronRecipe> COOKING_CAULDRON = RecipeType.create((String)"meadow", (String)"cooking", CookingCauldronRecipe.class);
    public static final int WIDTH = 124;
    public static final int HEIGHT = 55;
    public static final int WIDTH_OF = 26;
    public static final int HEIGHT_OF = 10;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable burnicon;
    private final IDrawableAnimated arrow;
    private final Component localizedName;

    public CookingCauldronCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(CookingCauldronGui.BACKGROUND, 26, 10, 124, 55);
        this.arrow = helper.drawableBuilder(CookingCauldronGui.BACKGROUND, 178, 16, 17, 29).buildAnimated(CookingCauldronBlockEntity.getMaxCookingTime(), IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ObjectRegistry.COOKING_CAULDRON.get()).m_5456_().m_7968_());
        this.burnicon = helper.createDrawable(CookingCauldronGui.BACKGROUND, 176, 0, 17, 15);
        this.localizedName = Component.m_237115_((String)"rei.meadow.cooking_cauldron_category");
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CookingCauldronRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        int s = ingredients.size();
        for (int row = 0; row < 2; ++row) {
            int current;
            for (int slot = 0; slot < 3 && s - 1 >= (current = slot + row + row * 2); ++slot) {
                MeadowJEIPlugin.addSlot(builder, 30 + slot * 18 - 26, 17 + row * 18 - 10, (Ingredient)ingredients.get(current));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 98, 16).addItemStack(recipe.getResultItem());
    }

    public void draw(CookingCauldronRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 66, 0);
        this.burnicon.draw(guiGraphics, 98, 41);
    }

    @NotNull
    public RecipeType<CookingCauldronRecipe> getRecipeType() {
        return COOKING_CAULDRON;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

