/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.forge;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.satisfy.meadow.forge.capabilities.MeadowCapabilities;
import net.satisfy.meadow.forge.capabilities.VarHolder;

public class MeadowExpectPlatformImpl {
    public static boolean isModLoaded(String modid) {
        ModList modList = ModList.get();
        if (modList != null) {
            return modList.isLoaded(modid);
        }
        return MeadowExpectPlatformImpl.isModPreLoaded(modid);
    }

    public static boolean isModPreLoaded(String modid) {
        return MeadowExpectPlatformImpl.getPreLoadedModInfo(modid) != null;
    }

    @Nullable
    public static ModInfo getPreLoadedModInfo(String modId) {
        for (ModInfo info : LoadingModList.get().getMods()) {
            if (!info.getModId().equals(modId)) continue;
            return info;
        }
        return null;
    }

    public static int getTypeVariant(Entity entity) {
        Optional holder;
        LazyOptional optional = entity.getCapability(MeadowCapabilities.VAR_HOLDER_CAPABILITY);
        if (optional.isPresent() && (holder = optional.resolve()).isPresent()) {
            return ((VarHolder)holder.get()).getVariant();
        }
        return 0;
    }

    public static void setTypeVariant(Entity entity, int var) {
        LazyOptional optional = entity.getCapability(MeadowCapabilities.VAR_HOLDER_CAPABILITY);
        if (optional.isPresent()) {
            Optional holder = optional.resolve();
            holder.ifPresent(varHolder -> varHolder.setVar(var));
        }
    }
}

