/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.recipes;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.meadow.recipes.WoodcuttingRecipeJsonFormat;
import net.satisfy.meadow.registry.RecipeRegistry;

public class WoodcuttingRecipe
implements Recipe<Container> {
    private final Ingredient input;
    private final ItemStack outputStack;
    private final ResourceLocation id;

    public WoodcuttingRecipe(Ingredient input, ItemStack outputStack, ResourceLocation id) {
        this.id = id;
        this.input = input;
        this.outputStack = outputStack;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return this.input.test(inventory.m_8020_(0));
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryManager) {
        return this.outputStack.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList defaultedList = NonNullList.m_122779_();
        defaultedList.add((Object)this.input);
        return defaultedList;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack getResultItem() {
        return this.m_8043_(null);
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return this.outputStack;
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.WOODCUTTING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.WOODCUTTING.get();
    }

    public static class Serializer
    implements RecipeSerializer<WoodcuttingRecipe> {
        public WoodcuttingRecipe fromJson(ResourceLocation id, JsonObject json) {
            WoodcuttingRecipeJsonFormat recipeJson = (WoodcuttingRecipeJsonFormat)new Gson().fromJson((JsonElement)json, WoodcuttingRecipeJsonFormat.class);
            if (recipeJson.inputItem == null || recipeJson.outputItem == null) {
                throw new JsonSyntaxException("A required attribute is missing!");
            }
            if (recipeJson.outputAmount == 0) {
                recipeJson.outputAmount = 1;
            }
            Ingredient input = Ingredient.m_43917_((JsonElement)recipeJson.inputItem);
            Item outputItem = (Item)BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(recipeJson.outputItem)).orElseThrow(() -> new JsonSyntaxException("No such item " + recipeJson.outputItem));
            ItemStack output = new ItemStack((ItemLike)outputItem, recipeJson.outputAmount);
            return new WoodcuttingRecipe(input, output, id);
        }

        public WoodcuttingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf packetData) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)packetData);
            ItemStack output = packetData.m_130267_();
            return new WoodcuttingRecipe(input, output, id);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, WoodcuttingRecipe recipe) {
            recipe.getInput().m_43923_(friendlyByteBuf);
            friendlyByteBuf.m_130055_(recipe.outputStack);
        }
    }
}

