/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.registry;

import de.cristelknight.doapi.client.render.feature.CustomArmorManager;
import de.cristelknight.doapi.client.render.feature.CustomArmorSet;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.satisfy.meadow.client.model.FurArmorHat;
import net.satisfy.meadow.client.model.FurArmorInner;
import net.satisfy.meadow.client.model.FurArmorOuter;
import net.satisfy.meadow.item.armor.FurBoots;
import net.satisfy.meadow.item.armor.FurChest;
import net.satisfy.meadow.item.armor.FurHead;
import net.satisfy.meadow.item.armor.FurLegs;
import net.satisfy.meadow.registry.ObjectRegistry;
import net.satisfy.meadow.util.MeadowIdentifier;
import org.jetbrains.annotations.NotNull;

public class ArmorRegistry {
    private static final Map<Item, FurArmorHat<?>> models = new HashMap();

    public static void registerArmorModelLayers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)FurArmorOuter.LAYER_LOCATION, FurArmorOuter::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)FurArmorInner.LAYER_LOCATION, FurArmorInner::createBodyLayer);
    }

    public static <T extends LivingEntity> void registerArmorModels(CustomArmorManager<T> armors, EntityModelSet modelLoader) {
        armors.addArmor(new CustomArmorSet(new Item[]{(Item)ObjectRegistry.FUR_HELMET.get(), (Item)ObjectRegistry.FUR_CHESTPLATE.get(), (Item)ObjectRegistry.FUR_LEGGINGS.get(), (Item)ObjectRegistry.FUR_BOOTS.get()}).setTexture((ResourceLocation)new MeadowIdentifier("fur")).setOuterModel(new FurArmorOuter(modelLoader.m_171103_(FurArmorOuter.LAYER_LOCATION))).setInnerModel(new FurArmorInner(modelLoader.m_171103_(FurArmorInner.LAYER_LOCATION))));
    }

    public static Model getHatModel(Item item, ModelPart baseHead) {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        FurArmorHat model = models.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.FUR_HELMET.get()) {
                return new FurArmorHat(modelSet.m_171103_(FurArmorHat.LAYER_LOCATION));
            }
            return null;
        });
        assert (model != null);
        model.copyHead(baseHead);
        return model;
    }

    public static void appendToolTip(@NotNull List<Component> tooltip) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        tooltip.add(Component.m_130674_((String)""));
        tooltip.add(Component.m_130674_((String)(String.valueOf(ChatFormatting.DARK_GREEN) + I18n.m_118938_((String)"tooltip.meadow.fur_armor", (Object[])new Object[0]))));
        tooltip.add(Component.m_130674_((String)((helmet != null && helmet.m_41720_() instanceof FurHead ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.FUR_HELMET.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((chestplate != null && chestplate.m_41720_() instanceof FurChest ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.FUR_CHESTPLATE.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((leggings != null && leggings.m_41720_() instanceof FurLegs ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.FUR_LEGGINGS.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((boots != null && boots.m_41720_() instanceof FurBoots ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.FUR_BOOTS.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)""));
        tooltip.add(Component.m_130674_((String)(String.valueOf(ChatFormatting.GRAY) + I18n.m_118938_((String)"tooltip.meadow.fur_armor2", (Object[])new Object[0]))));
        tooltip.add(Component.m_130674_((String)((helmet != null && helmet.m_41720_() instanceof FurHead && chestplate != null && chestplate.m_41720_() instanceof FurChest && leggings != null && leggings.m_41720_() instanceof FurLegs && boots != null && boots.m_41720_() instanceof FurBoots ? ChatFormatting.DARK_GREEN.toString() : ChatFormatting.GRAY.toString()) + I18n.m_118938_((String)"tooltip.meadow.fur_armor3", (Object[])new Object[0]))));
    }
}

