/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.registry;

import de.cristelknight.doapi.DoApiCommonEP;
import de.cristelknight.doapi.terraform.boat.TerraformBoatType;
import de.cristelknight.doapi.terraform.boat.item.TerraformBoatItemHelper;
import de.cristelknight.doapi.terraform.sign.TerraformSignHelper;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.satisfy.meadow.registry.ObjectRegistry;
import net.satisfy.meadow.util.MeadowIdentifier;

public class BoatsAndSignsRegistry {
    public static final ResourceLocation PINE_BOAT_TYPE = new MeadowIdentifier("pine");
    public static final ResourceLocation PINE_SIGN_TEXTURE = new MeadowIdentifier("entity/signs/pine");
    public static final ResourceLocation PINE_HANGING_SIGN_TEXTURE = new MeadowIdentifier("entity/signs/hanging/pine");
    public static final ResourceLocation PINE_HANGING_SIGN_GUI_TEXTURE = new MeadowIdentifier("textures/gui/hanging_signs/pine");
    public static final RegistrySupplier<Block> PINE_SIGN = BoatsAndSignsRegistry.registerPineSign();
    public static final RegistrySupplier<Block> PINE_WALL_SIGN = BoatsAndSignsRegistry.registerPineWallSign();
    public static final RegistrySupplier<Item> PINE_SIGN_ITEM = BoatsAndSignsRegistry.registerPineSignItem();
    public static final RegistrySupplier<Block> PINE_HANGING_SIGN = BoatsAndSignsRegistry.registerPineHangingSign();
    public static final RegistrySupplier<Block> PINE_WALL_HANGING_SIGN = BoatsAndSignsRegistry.registerPineWallHangingSign();
    public static final RegistrySupplier<Item> PINE_HANGING_SIGN_ITEM = BoatsAndSignsRegistry.registerPineHangingSignItem();
    public static final RegistrySupplier<Item> PINE_BOAT = BoatsAndSignsRegistry.registerPineBoat(false);
    public static final RegistrySupplier<Item> PINE_CHEST_BOAT = BoatsAndSignsRegistry.registerPineBoat(true);

    public static void init() {
        DoApiCommonEP.registerBoatType((ResourceLocation)PINE_BOAT_TYPE, (TerraformBoatType)new TerraformBoatType.Builder().item(PINE_BOAT).chestItem(PINE_CHEST_BOAT).build());
        TerraformSignHelper.regsterSignSprite((ResourceLocation)PINE_SIGN_TEXTURE);
        TerraformSignHelper.regsterSignSprite((ResourceLocation)PINE_HANGING_SIGN_TEXTURE);
    }

    private static RegistrySupplier<Block> registerPineSign() {
        return ObjectRegistry.registerWithoutItem("pine_sign", () -> TerraformSignHelper.getSign((ResourceLocation)PINE_SIGN_TEXTURE));
    }

    private static RegistrySupplier<Block> registerPineWallSign() {
        return ObjectRegistry.registerWithoutItem("pine_wall_sign", () -> TerraformSignHelper.getWallSign((ResourceLocation)PINE_SIGN_TEXTURE));
    }

    private static RegistrySupplier<Item> registerPineSignItem() {
        return ObjectRegistry.registerItem("pine_sign", () -> new SignItem(ObjectRegistry.getSettings().m_41487_(16), (Block)PINE_SIGN.get(), (Block)PINE_WALL_SIGN.get()));
    }

    private static RegistrySupplier<Block> registerPineHangingSign() {
        return ObjectRegistry.registerWithoutItem("pine_hanging_sign", () -> TerraformSignHelper.getHangingSign((ResourceLocation)PINE_HANGING_SIGN_TEXTURE, (ResourceLocation)PINE_HANGING_SIGN_GUI_TEXTURE));
    }

    private static RegistrySupplier<Block> registerPineWallHangingSign() {
        return ObjectRegistry.registerWithoutItem("pine_wall_hanging_sign", () -> TerraformSignHelper.getWallHangingSign((ResourceLocation)PINE_HANGING_SIGN_TEXTURE, (ResourceLocation)PINE_HANGING_SIGN_GUI_TEXTURE));
    }

    private static RegistrySupplier<Item> registerPineHangingSignItem() {
        return ObjectRegistry.registerItem("pine_hanging_sign", () -> new HangingSignItem((Block)PINE_HANGING_SIGN.get(), (Block)PINE_WALL_HANGING_SIGN.get(), ObjectRegistry.getSettings().m_41487_(16)));
    }

    private static RegistrySupplier<Item> registerPineBoat(boolean withChest) {
        return TerraformBoatItemHelper.registerBoatItem(ObjectRegistry.ITEMS, (String)(withChest ? "pine_chest_boat" : "pine_boat"), (ResourceLocation)PINE_BOAT_TYPE, (boolean)withChest);
    }
}

