/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.satisfy.meadow.Meadow;
import net.satisfy.meadow.entity.ShearableVarCow;
import net.satisfy.meadow.entity.WaterBuffalo;

public class EntityRegistry {
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"meadow", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<EntityType<WaterBuffalo>> WATER_BUFFALO = EntityRegistry.create("water_buffalo", () -> EntityType.Builder.m_20704_(WaterBuffalo::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20712_(new ResourceLocation("meadow", "water_buffalo").toString()));
    public static final RegistrySupplier<EntityType<ShearableVarCow>> SHEARABLE_MEADOW_VAR_COW = EntityRegistry.create("wooly_cow", () -> EntityType.Builder.m_20704_(ShearableVarCow::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20712_(new ResourceLocation("meadow", "wooly_cow").toString()));

    public static void registerCow(Supplier<? extends EntityType<? extends Animal>> typeSupplier) {
        EntityAttributeRegistry.register(typeSupplier, Cow::m_28307_);
    }

    public static <T extends EntityType<?>> RegistrySupplier<T> create(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(new ResourceLocation("meadow", path), type);
    }

    public static void init() {
        Meadow.LOGGER.debug("Registering Mod Entities for meadow");
        ENTITY_TYPES.register();
        EntityRegistry.registerCow(SHEARABLE_MEADOW_VAR_COW);
        EntityRegistry.registerCow(WATER_BUFFALO);
    }
}

