/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable;

import com.mrcrayfish.controllable.client.ControllerInput;
import com.mrcrayfish.controllable.client.ControllerProperties;
import com.mrcrayfish.controllable.client.InputProcessor;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.input.ControllerManager;
import com.mrcrayfish.controllable.client.input.glfw.GLFWControllerManager;
import com.mrcrayfish.controllable.client.input.sdl2.SDL2ControllerManager;
import com.mrcrayfish.framework.platform.Services;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

public class Controllable {
    private static ControllerManager manager;
    private static File configFolder;
    private static boolean jeiLoaded;

    public static void init() {
        configFolder = Services.CONFIG.getConfigPath().toFile();
        jeiLoaded = Services.PLATFORM.isModLoaded("jei");
        ControllerProperties.load(configFolder);
        Controllable.getManager().init();
    }

    public static ControllerInput getInput() {
        return InputProcessor.instance().getInput();
    }

    public static File getConfigFolder() {
        return configFolder;
    }

    public static boolean isJeiLoaded() {
        return jeiLoaded;
    }

    @Nullable
    public static Controller getController() {
        return Controllable.getManager().getActiveController();
    }

    public static ControllerManager getManager() {
        if (manager == null) {
            manager = !Minecraft.f_91002_ ? new SDL2ControllerManager() : new GLFWControllerManager();
        }
        return manager;
    }
}

